/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewRegistry
implements IViewRegistry {
    @Inject
    private MApplication application;
    @Inject
    private IExtensionRegistry extensionRegistry;
    private Map<String, IViewDescriptor> descriptors = new HashMap<String, IViewDescriptor>();

    @PostConstruct
    void postConstruct() {
        for (MPartDescriptor descriptor : this.application.getDescriptors()) {
            if (descriptor.getContributionURI().equals("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor")) continue;
            this.descriptors.put(descriptor.getElementId(), new ViewDescriptor(this.application, descriptor, null));
        }
        IExtensionPoint point = this.extensionRegistry.getExtensionPoint("org.eclipse.ui.views");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element;
            IExtension extension = iExtensionArray[n2];
            String category = WorkbenchMessages.ICategory_general;
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                element = iConfigurationElementArray[n4];
                if (element.getName().equals("category")) {
                    category = element.getAttribute("name");
                }
                ++n4;
            }
            iConfigurationElementArray = extension.getConfigurationElements();
            n3 = iConfigurationElementArray.length;
            n4 = 0;
            while (n4 < n3) {
                element = iConfigurationElementArray[n4];
                if (element.getName().equals("view")) {
                    MPartDescriptor descriptor = BasicFactoryImpl.eINSTANCE.createPartDescriptor();
                    descriptor.setLabel(element.getAttribute("name"));
                    String id = element.getAttribute("id");
                    descriptor.setElementId(id);
                    if (id.equals("org.eclipse.ui.views.ResourceNavigator") || id.equals("org.eclipse.ui.navigator.ProjectExplorer")) {
                        descriptor.setCategory("org.eclipse.e4.primaryNavigationStack");
                    } else if (id.equals("org.eclipse.ui.views.ContentOutline")) {
                        descriptor.setCategory("org.eclipse.e4.secondaryNavigationStack");
                    } else {
                        descriptor.setCategory("org.eclipse.e4.secondaryDataStack");
                    }
                    List tags = descriptor.getTags();
                    tags.add("View");
                    tags.add("categoryTag:" + category);
                    descriptor.setCloseable(true);
                    descriptor.setAllowMultiple(Boolean.parseBoolean(element.getAttribute("allowMultiple")));
                    descriptor.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView");
                    String iconURI = element.getAttribute("icon");
                    if (iconURI != null) {
                        StringBuilder builder = new StringBuilder("platform:/plugin/");
                        builder.append(element.getNamespaceIdentifier()).append('/');
                        if (iconURI.startsWith("$nl$")) {
                            iconURI = iconURI.substring(4);
                        }
                        builder.append(iconURI);
                        descriptor.setIconURI(builder.toString());
                    }
                    this.application.getDescriptors().add(descriptor);
                    this.descriptors.put(descriptor.getElementId(), new ViewDescriptor(this.application, descriptor, element));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IViewDescriptor find(String id) {
        return this.descriptors.get(id);
    }

    public IViewCategory[] getCategories() {
        E4Util.unsupported("getCategories");
        return null;
    }

    public IViewDescriptor[] getViews() {
        return this.descriptors.values().toArray(new IViewDescriptor[this.descriptors.size()]);
    }

    public IStickyViewDescriptor[] getStickyViews() {
        E4Util.unsupported("getStickyViews");
        return null;
    }

    public void dispose() {
    }

    public IViewCategory findCategory(String string) {
        return null;
    }

    public Category getMiscCategory() {
        return null;
    }
}

