/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorRequestor
extends Requestor {
    private final Constructor<?> constructor;

    public ConstructorRequestor(Constructor<?> constructor, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier) {
        super(null, injector, primarySupplier, tempSupplier, null, false);
        this.constructor = constructor;
    }

    @Override
    public Object execute() throws InjectionException {
        Object result = null;
        boolean wasAccessible = true;
        if (!this.constructor.isAccessible()) {
            this.constructor.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                result = this.constructor.newInstance(this.actualArgs);
            }
            catch (IllegalArgumentException e) {
                throw new InjectionException(e);
            }
            catch (InstantiationException e) {
                throw new InjectionException("Unable to instantiate " + this.constructor, e);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException(e);
            }
            catch (InvocationTargetException e) {
                Throwable originalException = e.getCause();
                throw new InjectionException(originalException != null ? originalException : e);
            }
        }
        finally {
            if (!wasAccessible) {
                this.constructor.setAccessible(false);
            }
        }
        return result;
    }

    @Override
    public IObjectDescriptor[] getDependentObjects() {
        Annotation[][] annotations = this.constructor.getParameterAnnotations();
        Type[] logicalParams = this.constructor.getGenericParameterTypes();
        Class<?>[] compilerParams = this.constructor.getParameterTypes();
        if (compilerParams.length > logicalParams.length) {
            Type[] tmp = new Type[compilerParams.length];
            System.arraycopy(compilerParams, 0, tmp, 0, compilerParams.length - logicalParams.length);
            System.arraycopy(logicalParams, 0, tmp, compilerParams.length - logicalParams.length, logicalParams.length);
            logicalParams = tmp;
        }
        IObjectDescriptor[] descriptors = new IObjectDescriptor[logicalParams.length];
        int i = 0;
        while (i < logicalParams.length) {
            descriptors[i] = new ObjectDescriptor(logicalParams[i], annotations[i]);
            ++i;
        }
        return descriptors;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        }
        tmp.append('(');
        tmp.append(')');
        return tmp.toString();
    }
}

