/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class DetachedDropAgent
extends DropAgent {
    private EModelService modelService;
    private Rectangle curRect;

    public DetachedDropAgent(EModelService modelSvc) {
        this.modelService = modelSvc;
    }

    public boolean canDrop(MUIElement dragElement, CursorInfo info) {
        return dragElement instanceof MPart && info.curElement == null;
    }

    public boolean drop(MUIElement dragElement, CursorInfo info) {
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        this.modelService.detach((MPartSashContainerElement)dragElement, this.curRect.x, this.curRect.y, this.curRect.width, this.curRect.height);
        return true;
    }

    public Rectangle getRectangle(MUIElement dragElement, CursorInfo info) {
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        MElementContainer parentME = dragElement.getParent();
        Control ctrl = (Control)parentME.getWidget();
        this.curRect = ctrl.getBounds();
        this.curRect.width += 10;
        this.curRect.height += 22;
        Point cp = ctrl.getDisplay().getCursorLocation();
        this.curRect.x = cp.x - this.curRect.width / 2;
        this.curRect.y = cp.y - this.curRect.height / 2;
        return this.curRect;
    }
}

