/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MinMaxAddon {
    private static String trimURI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack";
    static String ID_SUFFIX = "(minimized)";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    private EventHandler installHook = new EventHandler(){

        public void handleEvent(Event event) {
            final MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            Widget widget = (Widget)event.getProperty("NewValue");
            if (changedElement instanceof MPartStack && widget instanceof CTabFolder && !changedElement.getTags().contains("EditorStack") && changedElement.getElementId() != null) {
                CTabFolder folder = (CTabFolder)widget;
                folder.setMinimizeVisible(true);
                folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void minimize(CTabFolderEvent event) {
                        MinMaxAddon.this.minimizeStack((MPartStack)changedElement);
                    }

                    public void restore(CTabFolderEvent event) {
                        MinMaxAddon.this.restoreStack((MPartStack)changedElement);
                    }
                });
            }
        }
    };
    private EventHandler perspectiveRemovedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("REMOVE".equals(eventType)) {
                MUIElement removed = (MUIElement)event.getProperty("OldValue");
                String perspectiveId = removed.getElementId();
                System.out.println("Perspective Removed: " + removed.getElementId());
                MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                MTrimBar bar = MinMaxAddon.this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    };

    @PostConstruct
    void hookListeners() {
        String topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget");
        this.eventBroker.subscribe(topic, null, this.installHook, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children");
        this.eventBroker.subscribe(topic, null, this.perspectiveRemovedListener, false);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.installHook);
        this.eventBroker.unsubscribe(this.perspectiveRemovedListener);
    }

    void minimizeStack(MPartStack stack) {
        MTrimmedWindow window = (MTrimmedWindow)this.modelService.getTopLevelWindowFor((MUIElement)stack);
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(stack.getElementId()) + this.getMinimizedStackSuffix(stack);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(trimURI);
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)stack.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            SideValue side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
            MTrimBar bar = this.modelService.getTrim(window, side);
            MToolControl spacer = (MToolControl)this.modelService.find("PerspectiveSpacer", (MUIElement)bar);
            if (spacer != null) {
                int spacerIndex = bar.getChildren().indexOf(spacer);
                bar.getChildren().add(spacerIndex - 1, trimStack);
                Control ctrl = (Control)trimStack.getWidget();
                if (ctrl != null) {
                    Control spacerCtrl = (Control)spacer.getWidget();
                    ctrl.moveAbove(spacerCtrl);
                }
            } else {
                bar.getChildren().add(trimStack);
                if (!bar.isToBeRendered()) {
                    bar.setToBeRendered(true);
                }
            }
        } else {
            trimStack.setVisible(true);
        }
        stack.setVisible(false);
    }

    void restoreStack(MPartStack stack) {
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        String trimId = String.valueOf(stack.getElementId()) + this.getMinimizedStackSuffix(stack);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
    }

    private String getMinimizedStackSuffix(MPartStack stack) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor((MUIElement)stack);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

