/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarRenderer;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedToolBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup = new HashMap();

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MRenderedToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        final MRenderedToolBar toolBar = (MRenderedToolBar)element;
        if (!(toolBar.getContributionManager() instanceof ToolBarManager)) {
            return null;
        }
        ToolBarManager tbm = (ToolBarManager)toolBar.getContributionManager();
        ToolBar tb = tbm.createControl((Composite)parent);
        tbm.update(true);
        tb.setData(ToolBarManager.class.getName(), (Object)tbm);
        tb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RenderedToolBarRenderer.this.cleanUp(toolBar);
            }
        });
        tb.getParent().layout(true);
        return tb;
    }

    protected void cleanUp(MRenderedToolBar element) {
        ArrayList<ArrayList<MToolBarElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MToolBarElement> list : lists) {
            for (MToolBarElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        IEclipseContext ctx = this.getContext((MUIElement)container);
        ExpressionContext eContext = new ExpressionContext(ctx);
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        MElementContainer<MUIElement> toolbarObj = container;
        MToolBar toolbarModel = (MToolBar)toolbarObj;
        ContributionsAnalyzer.gatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute, (ExpressionContext)eContext);
        ToolBarRenderer.addToolBarContributions(toolbarModel, toContribute, ctx, eContext, this.pendingCleanup);
    }
}

