/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.ElementReferenceRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    Image viewMenuImage;
    @Inject
    IStylingEngine stylingEngine;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IPresentationEngine renderer;
    private EventHandler itemUpdater;
    private EventHandler dirtyUpdater;
    private boolean ignoreTabSelChanges = false;
    private ActivationJob activationJob = null;

    private synchronized void activateStack(MElementContainer<MUIElement> stack) {
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf == null || ctf.isDisposed()) {
            return;
        }
        if (this.activationJob == null) {
            this.activationJob = new ActivationJob();
            this.activationJob.stackToActivate = stack;
            ctf.getDisplay().asyncExec((Runnable)this.activationJob);
        } else {
            this.activationJob.stackToActivate = stack;
        }
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.itemUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (!(element instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)element;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                if (element.getParent() != null && element.getParent().getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                List<MPlaceholder> refs = ElementReferenceRenderer.getRenderedPlaceholders(element);
                for (MPlaceholder ref : refs) {
                    CTabItem cti;
                    MElementContainer refParent = ref.getParent();
                    if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                    StackRenderer.this.updateTab(cti, part, attName, newValue);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.dirtyUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)objElement;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                MElementContainer parent = part.getParent();
                if (parent != null && parent.getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)parent);
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                List<MPlaceholder> refs = ElementReferenceRenderer.getRenderedPlaceholders((MUIElement)part);
                for (MPlaceholder ref : refs) {
                    CTabItem cti;
                    MElementContainer refParent = ref.getParent();
                    if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                    StackRenderer.this.updateTab(cti, part, attName, newValue);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Dirtyable", (String)"dirty"), this.dirtyUpdater);
    }

    protected void updateTab(CTabItem cti, MPart part, String attName, Object newValue) {
        if ("label".equals(attName)) {
            String newName = (String)newValue;
            cti.setText(this.getLabel((MUILabel)part, newName));
        } else if ("iconURI".equals(attName)) {
            cti.setImage(this.getImage((MUILabel)part));
        } else if ("tooltip".equals(attName)) {
            String newTTip = (String)newValue;
            cti.setToolTipText(newTTip);
        } else if ("dirty".equals(attName)) {
            boolean hasAsterisk;
            Boolean dirtyState = (Boolean)newValue;
            String text = cti.getText();
            boolean bl = hasAsterisk = text.charAt(0) == '*';
            if (dirtyState.booleanValue()) {
                if (!hasAsterisk) {
                    cti.setText(String.valueOf('*') + text);
                }
            } else if (hasAsterisk) {
                cti.setText(text.substring(1));
            }
        }
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.dirtyUpdater);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        if (newName == null) {
            newName = "";
        }
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComposite = (Composite)parent;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "PartStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        int styleModifier = 0;
        CTabFolder ctf = new CTabFolder(parentComposite, 0x800 | styleModifier);
        this.bindWidget(element, ctf);
        return ctf;
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement element) {
        Control ctrl;
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder) {
            part = (MPart)((MPlaceholder)element).getRef();
            part.setCurSharedRef((MPlaceholder)element);
        }
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        CTabItem cti = this.findItemForPart(element, stack);
        if (cti != null) {
            if (element.getWidget() != null) {
                cti.setControl((Control)element.getWidget());
            }
            return;
        }
        int createFlags = 0;
        if (part != null && part.isCloseable()) {
            createFlags |= 0x40;
        }
        int index = this.calcIndexFor(stack, element);
        cti = new CTabItem(ctf, createFlags, index);
        cti.setData("modelElement", (Object)element);
        cti.setText(this.getLabel((MUILabel)part, part.getLabel()));
        cti.setImage(this.getImage((MUILabel)part));
        cti.setToolTipText(part.getTooltip());
        if (element.getWidget() != null && (ctrl = (Control)element.getWidget()).getParent() == ctf) {
            cti.setControl((Control)element.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement element, MElementContainer<MUIElement> stack) {
        CTabFolder ctf;
        if (stack == null) {
            stack = element.getParent();
        }
        if ((ctf = (CTabFolder)stack.getWidget()) == null) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == element) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        if (ctf == null) {
            return;
        }
        CTabItem cti = this.findItemForPart(child, parentElement);
        if (cti != null) {
            cti.setControl(null);
            cti.dispose();
        }
        if (parentElement.getSelectedElement() == child) {
            Control tb = ctf.getTopRight();
            if (tb != null) {
                ctf.setTopRight(null);
                tb.dispose();
            }
            MUIElement defaultSel = this.getFirstVisibleElement(parentElement);
            parentElement.setSelectedElement(defaultSel);
        }
    }

    private MUIElement getFirstVisibleElement(MElementContainer<MUIElement> stack) {
        for (MUIElement mPart : stack.getChildren()) {
            if (!mPart.isToBeRendered()) continue;
            return mPart;
        }
        return null;
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (StackRenderer.this.ignoreTabSelChanges) {
                    return;
                }
                MUIElement ele = (MUIElement)e.item.getData("modelElement");
                ele.getParent().setSelectedElement(ele);
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                MUIElement uiElement = (MUIElement)event.item.getData("modelElement");
                MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
                IEclipseContext partContext = part.getContext();
                IEclipseContext context = partContext == null ? StackRenderer.this.context : partContext;
                EPartService partService = (EPartService)context.get(EPartService.class.getName());
                if (partService.savePart(part, true)) {
                    partService.hidePart(part);
                } else {
                    event.doit = false;
                }
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder ctf = (CTabFolder)event.widget;
                MElementContainer stack = (MElementContainer)ctf.getData("modelElement");
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
    }

    @Override
    protected void showTab(MUIElement element) {
        ToolBar tb;
        Control ctrl;
        super.showTab(element);
        CTabFolder ctf = (CTabFolder)this.getParentWidget(element);
        CTabItem cti = this.findItemForPart(element, null);
        if (cti == null) {
            this.createTab((MElementContainer<MUIElement>)element.getParent(), element);
            cti = this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
        }
        if ((ctrl = (Control)element.getWidget()) != null && ctrl.getParent() != ctf) {
            ctrl.setParent((Composite)ctf);
            cti.setControl(ctrl);
        } else if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            cti.setControl(tabCtrl);
        }
        this.ignoreTabSelChanges = true;
        ctf.setSelection(cti);
        this.ignoreTabSelChanges = false;
        if (ctf.getTopRight() != null) {
            Control curTB = ctf.getTopRight();
            ctf.setTopRight(null);
            curTB.dispose();
        }
        if ((tb = this.getToolbar(element)) != null) {
            if (tb.getSize().y > ctf.getTabHeight()) {
                ctf.setTabHeight(tb.getSize().y);
            }
            String cssClassName = (String)ctf.getData("org.eclipse.e4.ui.css.CssClassName");
            this.stylingEngine.setClassname((Object)tb, cssClassName);
            ctf.setTopRight((Control)tb, 131072);
            ctf.layout(true);
            ctf.notifyListeners(11, null);
        }
    }

    private ToolBar getToolbar(MUIElement uiElement) {
        ToolBar tb;
        boolean hasTB;
        MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
        MMenu viewMenu = this.getViewMenu(part);
        boolean bl = hasTB = part.getToolbar() != null;
        if (viewMenu == null && !hasTB) {
            return null;
        }
        CTabFolder ctf = (CTabFolder)this.getParentWidget(uiElement);
        MToolBar tbModel = part.getToolbar();
        if (tbModel != null) {
            if (tbModel.getWidget() != null) {
                CTabFolder oldCTF;
                ToolBar oldTB = (ToolBar)tbModel.getWidget();
                if (oldTB.getParent() instanceof CTabFolder && (oldCTF = (CTabFolder)oldTB.getParent()).getTopRight() == oldTB) {
                    oldCTF.setTopRight(null);
                }
                oldTB.setParent((Composite)ctf);
                return oldTB;
            }
            tbModel.setToBeRendered(true);
            tb = (ToolBar)this.renderer.createGui((MUIElement)tbModel, (Object)ctf);
        } else {
            tb = new ToolBar((Composite)ctf, 0x800100);
        }
        if (viewMenu != null) {
            this.addMenuButton(part, tb, viewMenu);
        }
        tb.pack();
        return tb;
    }

    private MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }

    private void addMenuButton(MPart part, ToolBar tb, MMenu menu) {
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        MPart part = (MPart)item.getData("thePart");
        Control ctrl = (Control)part.getWidget();
        Menu menu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell());
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private class ActivationJob
    implements Runnable {
        public MElementContainer<MUIElement> stackToActivate = null;

        private ActivationJob() {
        }

        public void run() {
            StackRenderer.this.activationJob = null;
            if (this.stackToActivate != null && this.stackToActivate.getSelectedElement() != null) {
                MUIElement selElement = this.stackToActivate.getSelectedElement();
                if (!selElement.isToBeRendered()) {
                    return;
                }
                if (selElement instanceof MPlaceholder) {
                    selElement = ((MPlaceholder)selElement).getRef();
                }
                StackRenderer.this.activate((MPart)selElement);
            }
        }
    }
}

