/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup = new HashMap();

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(final MUIElement element, Object parent) {
        MTrimBar trimContainer;
        SideValue side;
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        int orientation = 256;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            orientation = 512;
        }
        ToolBar tb = null;
        tb = new ToolBar((Composite)parent, orientation | 0x40 | 0x800000 | 0x20000);
        tb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolBarRenderer.this.cleanUp((MToolBar)element);
            }
        });
        return tb;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        super.processContents(container);
        IEclipseContext ctx = this.getContext((MUIElement)container);
        ExpressionContext eContext = new ExpressionContext(ctx);
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        MElementContainer<MUIElement> toolbarObj = container;
        MToolBar toolbarModel = (MToolBar)toolbarObj;
        ContributionsAnalyzer.gatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute, (ExpressionContext)eContext);
        ToolBarRenderer.addToolBarContributions(toolbarModel, toContribute, ctx, eContext, this.pendingCleanup);
    }

    public static void addToolBarContributions(final MToolBar toolbarModel, ArrayList<MToolBarContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext, HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup) {
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MToolBarElement child : toolbarModel.getChildren()) {
            String elementId = child.getElementId();
            if (!(child instanceof MToolBarSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MToolBarContribution contribution : curList) {
                ArrayList<ArrayList<Object>> lists;
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MToolBar)toolbarModel, (MToolBarContribution)contribution, toRemove = new ArrayList(), existingSeparatorNames)) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!toolbarModel.isToBeRendered() || !toolbarModel.isVisible() || toolbarModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MToolBarContribution)contribution, (ExpressionContext)eContext);
                            for (MToolBarElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                if ((lists = pendingCleanup.get(toolbarModel)) == null) {
                    lists = new ArrayList();
                    pendingCleanup.put(toolbarModel, lists);
                }
                lists.add(toRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    protected void cleanUp(MToolBar element) {
        ArrayList<ArrayList<MToolBarElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MToolBarElement> list : lists) {
            for (MToolBarElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }
}

