/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    private HashMap<MTrimBar, ArrayList<ArrayList<MTrimElement>>> pendingCleanup = new HashMap();
    ControlListener childResizeListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            Control ctrl = (Control)e.widget;
            Control[] changed = new Control[]{ctrl};
            ctrl.getShell().layout(changed, 4);
        }

        public void controlMoved(ControlEvent e) {
        }
    };

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MTrimBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        if (!(parentComp.getLayout() instanceof TrimmedPartLayout)) {
            return null;
        }
        final MTrimBar trimModel = (MTrimBar)element;
        TrimmedPartLayout tpl = (TrimmedPartLayout)parentComp.getLayout();
        Composite result = null;
        switch (trimModel.getSide().getValue()) {
            case 0: {
                result = tpl.getTrimComposite(parentComp, 128);
                break;
            }
            case 1: {
                result = tpl.getTrimComposite(parentComp, 1024);
                break;
            }
            case 2: {
                result = tpl.getTrimComposite(parentComp, 16384);
                break;
            }
            case 3: {
                result = tpl.getTrimComposite(parentComp, 131072);
                break;
            }
            default: {
                return null;
            }
        }
        result.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TrimBarRenderer.this.cleanUp(trimModel);
            }
        });
        return result;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null) {
            widget.dispose();
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        if (!(me instanceof MTrimBar)) {
            return;
        }
        super.processContents(me);
        IEclipseContext ctx = this.getContext((MUIElement)me);
        ExpressionContext eContext = new ExpressionContext(ctx);
        MElementContainer<MUIElement> trimObj = me;
        MTrimBar trimModel = (MTrimBar)trimObj;
        ArrayList<MTrimContribution> toContribute = new ArrayList<MTrimContribution>();
        ContributionsAnalyzer.gatherTrimContributions((MTrimBar)trimModel, (List)this.application.getTrimContributions(), (String)trimModel.getElementId(), toContribute, (ExpressionContext)eContext);
        this.addTrimContributions(trimModel, toContribute, ctx, eContext);
    }

    private void addTrimContributions(final MTrimBar trimModel, ArrayList<MTrimContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext) {
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MTrimContribution> curList = new ArrayList<MTrimContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MTrimContribution contribution : curList) {
                ArrayList<ArrayList<Object>> lists;
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MTrimBar)trimModel, (MTrimContribution)contribution, toRemove = new ArrayList())) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!trimModel.isToBeRendered() || !trimModel.isVisible() || trimModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MTrimContribution)contribution, (ExpressionContext)eContext);
                            for (MTrimElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                if ((lists = this.pendingCleanup.get(trimModel)) == null) {
                    lists = new ArrayList();
                    this.pendingCleanup.put(trimModel, lists);
                }
                lists.add(toRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (element.getWidget() instanceof Control) {
            Control ctrl = (Control)element.getWidget();
            ctrl.addControlListener(this.childResizeListener);
        }
    }

    protected void cleanUp(MTrimBar element) {
        ArrayList<ArrayList<MTrimElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MTrimElement> list : lists) {
            for (MTrimElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }
}

