/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.client.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.equinox.jmx.client.remote.RemoteMBeanConnection;
import org.eclipse.equinox.jmx.common.NamedNotification;
import org.eclipse.equinox.jmx.internal.client.Activator;

public class RemoteNotificationHandler {
    private int NOTIFICATION_RETRIEVAL_INTERVAL = 5000;
    private final Map objectNameListeners = new HashMap();
    private final NotificationRetriever retriever = new NotificationRetriever();
    private final NotificationDispatcher dispatcher = new NotificationDispatcher();
    private final RemoteMBeanConnection connection;
    private boolean started;

    public RemoteNotificationHandler(RemoteMBeanConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (!this.started) {
            this.start();
        }
        Map map = this.objectNameListeners;
        synchronized (map) {
            ArrayList<NotificationListener> listeners = null;
            listeners = (ArrayList<NotificationListener>)this.objectNameListeners.get(name);
            if (listeners == null) {
                listeners = new ArrayList<NotificationListener>();
                this.objectNameListeners.put(name, listeners);
            }
            listeners.add(listener);
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.retriever.start();
        this.dispatcher.start();
    }

    public synchronized void stop() {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNotification(NamedNotification notification) {
        ObjectName name = notification.getObjectName();
        Map map = this.objectNameListeners;
        synchronized (map) {
            List listeners = (List)this.objectNameListeners.get(name);
            if (listeners != null) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    ((NotificationListener)iter.next()).handleNotification((Notification)notification, null);
                }
            }
        }
    }

    private class NotificationDispatcher
    extends Thread {
        private List notificationQueue = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchNotifications(NamedNotification[] notifications) {
            List list = this.notificationQueue;
            synchronized (list) {
                boolean added = false;
                int i = 0;
                while (i < notifications.length) {
                    if (notifications[i] != null) {
                        added |= this.notificationQueue.add(notifications[i]);
                    }
                    ++i;
                }
                if (added) {
                    this.notificationQueue.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (RemoteNotificationHandler.this.started && !Thread.currentThread().isInterrupted()) {
                List list = this.notificationQueue;
                synchronized (list) {
                    while (this.notificationQueue.isEmpty()) {
                        try {
                            this.notificationQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Activator.log(e);
                            Thread.currentThread().interrupt();
                            continue block5;
                        }
                    }
                    while (this.notificationQueue.size() > 0) {
                        NamedNotification nn = (NamedNotification)this.notificationQueue.remove(0);
                        RemoteNotificationHandler.this.dispatchNotification(nn);
                    }
                }
            }
            RemoteNotificationHandler.this.started = false;
        }
    }

    private class NotificationRetriever
    extends Thread {
        private long startId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (RemoteNotificationHandler.this.started) {
                try {
                    NamedNotification[] result = RemoteNotificationHandler.this.connection.retrieveNotifications(this.startId);
                    if (result.length <= 0) continue;
                    RemoteNotificationHandler.this.dispatcher.dispatchNotifications(result);
                    this.startId = result[result.length - 1].getNotificationId() + 1L;
                    NotificationRetriever notificationRetriever = this;
                    synchronized (notificationRetriever) {
                        this.wait(RemoteNotificationHandler.this.NOTIFICATION_RETRIEVAL_INTERVAL);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                    break;
                }
            }
            RemoteNotificationHandler.this.started = false;
        }
    }
}

