/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.RootContribution;

public class MBeanServerProxy {
    private final MBeanServerConnection server;

    public MBeanServerProxy(MBeanServerConnection server) {
        this.server = server;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.server;
    }

    public ContributionProxy[] getRootContributions() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object result = this.getMBeanServerConnection().invoke(RootContribution.OBJECT_NAME, "queryRootContributions", null, null);
        if (result instanceof ContributionProxy[]) {
            return (ContributionProxy[])result;
        }
        if (result instanceof Object[]) {
            Object[] objProxies = (Object[])result;
            ContributionProxy[] proxies = new ContributionProxy[objProxies.length];
            int i = 0;
            while (i < objProxies.length) {
                if (objProxies[i] instanceof ContributionProxy) {
                    proxies[i] = (ContributionProxy)objProxies[i];
                }
                ++i;
            }
            return proxies;
        }
        return null;
    }

    public RootContribution getRootContribution() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (RootContribution)this.getMBeanServerConnection().invoke(RootContribution.OBJECT_NAME, "queryRootContribution", null, null);
    }

    public Object invokeContributionOperation(ContributionProxy contribution, String methodName, Object[] args, String[] argsSignature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, NotCompliantMBeanException {
        return this.getMBeanServerConnection().invoke(contribution.getObjectName(), methodName, args, argsSignature);
    }
}

