/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.viewsupport;

import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.JMXPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class BundleImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor baseDescriptor;
    private int bundleState;
    private Point size;

    public BundleImageDescriptor(ImageDescriptor baseDescriptor, int bundleState, Point size) {
        this.baseDescriptor = baseDescriptor;
        this.bundleState = bundleState;
        this.size = size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.baseDescriptor);
        this.drawImage(bg, 0, 0);
        this.drawBottomLeft();
    }

    protected Point getSize() {
        return this.size;
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        int x = 0;
        ImageData data = null;
        switch (this.bundleState) {
            case 32: {
                data = this.getImageData(JMXPluginImages.IMGDESC_OVR_BUNDLE_ACTIVE);
                break;
            }
            case 2: {
                data = this.getImageData(JMXPluginImages.IMGDESC_OVR_BUNDLE_INSTALLED);
                break;
            }
            case 4: {
                data = this.getImageData(JMXPluginImages.IMGDESC_OVR_BUNDLE_RESOLVED);
                break;
            }
            default: {
                return;
            }
        }
        this.drawImage(data, x, size.y - data.height);
        x += data.width;
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        return data;
    }
}

