/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.RootContributionMBean;
import org.eclipse.equinox.jmx.internal.common.Activator;

public class RootContribution
extends ContributionProxy
implements RootContributionMBean {
    private static final long serialVersionUID = 7227341044245163642L;
    public static final String CLASS_NAME;
    public static final String NOTIFICATION_TYPE = "contributions";
    public static final String DEFAULT_DOMAIN = "jmxserver";
    public static final String OBJECT_NAME_STR;
    public static ObjectName OBJECT_NAME;
    private final Set contributions = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.jmx.common.RootContribution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        OBJECT_NAME_STR = "jmxserver:type=" + CLASS_NAME;
        try {
            OBJECT_NAME = ObjectName.getInstance(OBJECT_NAME_STR);
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    public RootContribution() {
        this(new ContributionProxy[0]);
    }

    public RootContribution(ContributionProxy[] rootContributionProxies) {
        super("root", null, null, OBJECT_NAME, null);
        this.updateContributionProxies(rootContributionProxies);
    }

    public void registerContributionProxy(ContributionProxy proxy) {
        Iterator iter = this.contributions.iterator();
        boolean addproxy = true;
        while (iter.hasNext()) {
            ContributionProxy rootProxy = (ContributionProxy)iter.next();
            if (!rootProxy.getName().equals(proxy.getName())) continue;
            addproxy |= false;
            break;
        }
        if (addproxy) {
            this.contributions.add(proxy);
        }
    }

    public void unregisterContributionProxy(ContributionProxy proxy) {
        Iterator iter = this.contributions.iterator();
        while (iter.hasNext()) {
            ContributionProxy rootProxy = (ContributionProxy)iter.next();
            if (!rootProxy.getName().equals(proxy.getName())) continue;
            iter.remove();
            break;
        }
    }

    public void updateContributionProxies(ContributionProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.contributions.clear();
        int i = 0;
        while (i < proxies.length) {
            this.contributions.add(proxies[i]);
            ++i;
        }
    }

    public Set getRootContributionProxies() {
        return this.contributions;
    }

    public RootContribution queryRootContribution() {
        return this;
    }

    public ContributionProxy[] queryRootContributions() {
        return this.contributions.toArray(new ContributionProxy[this.contributions.size()]);
    }
}

