/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.vm;

import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.common.util.MBeanInfoWrapper;
import org.eclipse.equinox.jmx.internal.vm.Activator;
import org.eclipse.equinox.jmx.internal.vm.VMStatsMessages;
import org.eclipse.equinox.jmx.server.Contribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryContribution
extends Contribution
implements NotificationListener {
    private static final String ICON_PATH = "icons/memory.gif";
    private long heapCommited;
    private long heapInit;
    private long heapMax;
    private long heapUsed;
    private long nonHeapCommited;
    private long nonHeapInit;
    private long nonHeapMax;
    private long nonHeapUsed;
    private MBeanInfo mbeanInfo;

    public MemoryContribution(MemoryMXBean delegate) {
        super((Object)delegate);
        NotificationEmitter emitter = (NotificationEmitter)((Object)delegate);
        emitter.addNotificationListener(this, null, null);
        this.mbeanInfo = MBeanInfoWrapper.createMBeanInfo(delegate.getClass(), (String)delegate.toString(), (MBeanAttributeInfo[])new MBeanAttributeInfo[0], (MBeanNotificationInfo[])new MBeanNotificationInfo[0]);
        new Thread(){

            public void run() {
                while (true) {
                    if (MemoryContribution.this.memUsageChanged()) {
                        MemoryContribution.this.contributionStateChanged(new ContributionNotificationEvent("contribution.updated"));
                    }
                    try {
                        1.sleep(1500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    protected String getName() {
        return VMStatsMessages.mem_title;
    }

    protected Object[] getChildren() {
        return null;
    }

    protected Set<String> getProperties() {
        TreeSet<String> result = new TreeSet<String>();
        MemoryMXBean memDelegate = (MemoryMXBean)this.contributionDelegate;
        MemoryUsage mu = memDelegate.getHeapMemoryUsage();
        result.add(VMStatsMessages.mem_heapusage);
        result.add(String.valueOf(VMStatsMessages.mem_commited) + ": " + (mu.getCommitted() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_initreq) + ": " + (mu.getInit() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_max) + ": " + (mu.getMax() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_used) + ": " + (mu.getUsed() >> 10) + "KB");
        mu = memDelegate.getNonHeapMemoryUsage();
        result.add(VMStatsMessages.mem_noheapusage);
        result.add(String.valueOf(VMStatsMessages.mem_commited) + ": " + (mu.getCommitted() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_initreq) + ": " + (mu.getInit() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_max) + ": " + (mu.getMax() >> 10) + "KB");
        result.add(String.valueOf(VMStatsMessages.mem_used) + ": " + (mu.getUsed() >> 10) + "KB");
        return result;
    }

    protected MBeanInfo getMBeanInfo(Object delegate) {
        return this.mbeanInfo;
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        return null;
    }

    public Object getAttribute(String attribute) {
        return null;
    }

    public void setAttribute(Attribute attribute) {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        super.contributionStateChanged(new ContributionNotificationEvent("contribution.updated"));
    }

    private boolean memUsageChanged() {
        MemoryMXBean mbean = (MemoryMXBean)this.contributionDelegate;
        MemoryUsage m = mbean.getHeapMemoryUsage();
        boolean changed = false;
        if (m.getCommitted() != this.heapCommited || m.getInit() != this.heapInit || m.getMax() != this.heapMax || m.getUsed() != this.heapUsed) {
            changed = true;
            this.heapCommited = m.getCommitted();
            this.heapInit = m.getInit();
            this.heapMax = m.getMax();
            this.heapUsed = m.getUsed();
        }
        if ((m = mbean.getNonHeapMemoryUsage()).getCommitted() != this.nonHeapCommited || m.getInit() != this.nonHeapInit || m.getMax() != this.nonHeapMax || m.getUsed() != this.nonHeapUsed) {
            changed = true;
            this.nonHeapCommited = m.getCommitted();
            this.nonHeapInit = m.getInit();
            this.nonHeapMax = m.getMax();
            this.nonHeapUsed = m.getUsed();
        }
        return changed;
    }

    protected URL getImageLocation() {
        return Activator.getImageLocation(ICON_PATH);
    }
}

