/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.photon.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            data[i] = new TransferData();
            data[i].type = types[i];
            ++i;
        }
        return data;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        int i = 0;
        while (i < types.length) {
            if (transferData.type == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] buffer = (byte[])object;
        transferData.pData = OS.malloc(buffer.length);
        OS.memmove(transferData.pData, buffer, buffer.length);
        transferData.length = buffer.length;
        transferData.result = 1;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (transferData.pData == 0 || !this.isSupportedType(transferData)) {
            return null;
        }
        int size = transferData.length;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        OS.memmove(buffer, transferData.pData, size);
        return buffer;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

