/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int flags;
        int fontPtr;
        int parentHandle = 0;
        if (this.parent != null && OS.PtWidgetIsRealized(this.parent.shellHandle)) {
            parentHandle = this.parent.shellHandle;
        }
        byte[] title = null;
        if (this.title != null) {
            title = Converter.wcsToMbcs(null, this.title, true);
        }
        byte[] font = null;
        if (this.fontData != null) {
            if (this.fontData.stem != null) {
                font = this.fontData.stem;
            } else {
                byte[] buffer;
                int size;
                byte[] description = Converter.wcsToMbcs(null, this.fontData.getName(), true);
                int osStyle = 0;
                int style = this.fontData.getStyle();
                if ((style & 1) != 0) {
                    osStyle |= 1;
                }
                if ((style & 2) != 0) {
                    osStyle |= 2;
                }
                if (OS.PfGenerateFontName(description, osStyle, size = this.fontData.getHeight(), buffer = new byte[80]) != 0) {
                    font = buffer;
                }
            }
            this.fontData = null;
        }
        if ((fontPtr = OS.PtFontSelection(parentHandle, null, title, font, -1, flags = 115, null)) != 0) {
            int length = OS.strlen(fontPtr);
            font = new byte[length + 1];
            OS.memmove(font, fontPtr, length);
            this.fontData = FontData.photon_new(font);
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

