/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.ExtensionPointProxy;
import org.eclipse.e4.ui.internal.workbench.IDelegateInitializer;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.menus.ExtensionContribution;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuHelper {
    public static final String MAIN_MENU_ID = "org.eclipse.ui.main.menu";
    private static Field urlField;

    public static void trace(String msg, Throwable error) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)msg, (Throwable)error);
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = MenuHelper.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = MenuHelper.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            String parentName = parent.getName();
            if (parentName.equals("actionSet") || parentName.equals("viewContribution") || parentName.equals("editorContribution")) {
                actionSetId = MenuHelper.getId(parent);
            }
            obj = parent.getParent();
        }
        return "AUTOGEN:::" + actionSetId + '/' + id;
    }

    public static String getImageUrl(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Class<?> idc = imageDescriptor.getClass();
        if (idc.getName().endsWith("URLImageDescriptor")) {
            URL url = MenuHelper.getUrl(idc, imageDescriptor);
            return url.toExternalForm();
        }
        return null;
    }

    private static URL getUrl(Class idc, ImageDescriptor imageDescriptor) {
        try {
            if (urlField == null) {
                urlField = idc.getDeclaredField("url");
                urlField.setAccessible(true);
            }
            return (URL)urlField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean getVisibleEnabled(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("visibleWhen");
        String checkEnabled = null;
        if (children.length > 0) {
            checkEnabled = children[0].getAttribute("checkEnabled");
        }
        return checkEnabled != null && checkEnabled.equalsIgnoreCase("true");
    }

    static MExpression getVisibleWhen(IConfigurationElement commandAddition) {
        try {
            IConfigurationElement[] visibleChild;
            IConfigurationElement[] visibleConfig = commandAddition.getChildren("visibleWhen");
            if (visibleConfig.length > 0 && visibleConfig.length < 2 && (visibleChild = visibleConfig[0].getChildren()).length > 0) {
                Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic.value");
                exp.setCoreExpression((Object)visWhen);
                return exp;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = MenuHelper.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static int getMode(IConfigurationElement element) {
        if ("FORCE_TEXT".equals(element.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getPath(IConfigurationElement element) {
        return element.getAttribute("path");
    }

    static String getMenuBarPath(IConfigurationElement element) {
        return element.getAttribute("menubarPath");
    }

    static String getToolBarPath(IConfigurationElement element) {
        return element.getAttribute("toolbarPath");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    static String getIconPath(IConfigurationElement element) {
        return element.getAttribute("icon");
    }

    static String getDisabledIconPath(IConfigurationElement element) {
        return element.getAttribute("disabledIcon");
    }

    static String getHoverIconPath(IConfigurationElement element) {
        return element.getAttribute("hoverIcon");
    }

    static String getIconUrl(IConfigurationElement element, String attr) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!iconPath.startsWith("platform:")) {
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        URL url = null;
        try {
            url = FileLocator.find((URL)new URL(iconPath));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url == null ? null : url.toString();
    }

    static String getHelpContextId(IConfigurationElement element) {
        return element.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.valueOf(val);
    }

    public static String getClassSpec(IConfigurationElement element) {
        return element.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static ItemType getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            return ItemType.PUSH;
        }
        if ("toggle".equals(style)) {
            return ItemType.CHECK;
        }
        if ("radio".equals(style)) {
            return ItemType.RADIO;
        }
        if ("pulldown".equals(style)) {
            MenuHelper.trace("Failed to get style for pulldown", null);
        }
        return ItemType.PUSH;
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static Map<String, String> getParameters(IConfigurationElement element) {
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] parameters = element.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            String value = parameters[i].getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
        return map;
    }

    public static MMenu createMenuAddition(IConfigurationElement menuAddition) {
        int idx;
        MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
        String id = MenuHelper.getId(menuAddition);
        element.setElementId(id);
        String text = MenuHelper.getLabel(menuAddition);
        String mnemonic = MenuHelper.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        element.setIconURI(MenuHelper.getIconUrl(menuAddition, "icon"));
        element.setLabel(Util.safeString(text));
        IConfigurationElement[] iConfigurationElementArray = menuAddition.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals("dynamic")) {
                ExtensionPointProxy proxy = new ExtensionPointProxy(child, "class", (IDelegateInitializer)new ExtensionContribution());
                MRenderedMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createRenderedMenuItem();
                menuItem.setElementId(MenuHelper.getId(child));
                menuItem.setContributionItem((Object)proxy);
                element.getChildren().add(menuItem);
            }
            ++n2;
        }
        return element;
    }

    public static MMenuElement createLegacyMenuActionAdditions(MApplication app, final IConfigurationElement element) {
        int idx;
        final String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconUrl(element, "icon");
        String cmdId = MenuHelper.getActionSetCommandId(element);
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        String style = element.getAttribute("style");
        String pulldown = element.getAttribute("pulldown");
        if ("pulldown".equals(style) || pulldown != null && pulldown.equals("true")) {
            MRenderedMenu menu = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
            menu.setElementId(id);
            menu.setLabel(text);
            if (iconUri != null) {
                menu.setIconURI(iconUri);
            }
            ECommandService cs = (ECommandService)app.getContext().get(ECommandService.class);
            final ParameterizedCommand parmCmd = cs.createCommand(cmdId, null);
            menu.setContributionManager((Object)new IMenuCreator(){
                private ActionDelegateHandlerProxy handlerProxy;

                private ActionDelegateHandlerProxy getProxy() {
                    if (this.handlerProxy == null) {
                        this.handlerProxy = new ActionDelegateHandlerProxy(element, "class", id, parmCmd, PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, null, null);
                    }
                    return this.handlerProxy;
                }

                private IWorkbenchWindowPulldownDelegate getDelegate() {
                    this.getProxy();
                    if (this.handlerProxy == null) {
                        return null;
                    }
                    if (this.handlerProxy.getDelegate() == null) {
                        this.handlerProxy.loadDelegate();
                    }
                    return (IWorkbenchWindowPulldownDelegate)this.handlerProxy.getDelegate();
                }

                public Menu getMenu(Menu parent) {
                    IWorkbenchWindowPulldownDelegate2 delegate = (IWorkbenchWindowPulldownDelegate2)this.getDelegate();
                    if (delegate == null) {
                        return null;
                    }
                    return delegate.getMenu(parent);
                }

                public Menu getMenu(Control parent) {
                    return this.getDelegate() == null ? null : this.getDelegate().getMenu(parent);
                }

                public void dispose() {
                    if (this.handlerProxy != null) {
                        this.handlerProxy.dispose();
                        this.handlerProxy = null;
                    }
                }
            });
            return menu;
        }
        ItemType type = ItemType.PUSH;
        if ("toggle".equals(style)) {
            type = ItemType.CHECK;
        } else if ("radio".equals(style)) {
            type = ItemType.RADIO;
        }
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(id);
        item.setLabel(text);
        item.setType(type);
        item.setCommand(cmd);
        if (iconUri != null) {
            item.setIconURI(iconUri);
        }
        return item;
    }

    public static String getDescription(IConfigurationElement configElement) {
        return configElement.getAttribute("description");
    }

    public static MToolBarElement createLegacyToolBarActionAdditions(MApplication app, final IConfigurationElement element) {
        int idx;
        String cmdId = MenuHelper.getActionSetCommandId(element);
        final String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconUrl(element, "icon");
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            item.setType(ItemType.PUSH);
        } else if ("toggle".equals(style)) {
            item.setType(ItemType.CHECK);
        } else if ("radio".equals(style)) {
            item.setType(ItemType.RADIO);
        } else if ("pulldown".equals(style)) {
            MRenderedMenu menu = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
            ECommandService cs = (ECommandService)app.getContext().get(ECommandService.class);
            final ParameterizedCommand parmCmd = cs.createCommand(cmdId, null);
            menu.setContributionManager((Object)new IMenuCreator(){
                private ActionDelegateHandlerProxy handlerProxy;

                private ActionDelegateHandlerProxy getProxy() {
                    if (this.handlerProxy == null) {
                        this.handlerProxy = new ActionDelegateHandlerProxy(element, "class", id, parmCmd, PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, null, null);
                    }
                    return this.handlerProxy;
                }

                private IWorkbenchWindowPulldownDelegate getDelegate() {
                    this.getProxy();
                    if (this.handlerProxy == null) {
                        return null;
                    }
                    if (this.handlerProxy.getDelegate() == null) {
                        this.handlerProxy.loadDelegate();
                    }
                    return (IWorkbenchWindowPulldownDelegate)this.handlerProxy.getDelegate();
                }

                public Menu getMenu(Menu parent) {
                    IWorkbenchWindowPulldownDelegate2 delegate = (IWorkbenchWindowPulldownDelegate2)this.getDelegate();
                    if (delegate == null) {
                        return null;
                    }
                    return delegate.getMenu(parent);
                }

                public Menu getMenu(Control parent) {
                    return this.getDelegate() == null ? null : this.getDelegate().getMenu(parent);
                }

                public void dispose() {
                    if (this.handlerProxy != null) {
                        this.handlerProxy.dispose();
                        this.handlerProxy = null;
                    }
                }
            });
            item.setMenu((MMenu)menu);
        } else {
            item.setType(ItemType.PUSH);
        }
        item.setElementId(id);
        item.setCommand(cmd);
        if (iconUri == null) {
            item.setLabel(text);
        } else {
            item.setIconURI(iconUri);
        }
        return item;
    }
}

