/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SplitDropAgent
extends DropAgent {
    EModelService modelService;

    public SplitDropAgent(EModelService modelService) {
        this.modelService = modelService;
    }

    public boolean canDrop(MUIElement dragElement, CursorInfo info) {
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        if (info.curElement == dragElement && dragElement.getParent().getWidget() instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)dragElement.getParent().getWidget();
            return ctf.getItemCount() > 1;
        }
        return dragElement instanceof MStackElement && info.curElement instanceof MStackElement;
    }

    private int whereToDrop(Control ctrl, Point cursorPos) {
        int dyr;
        int dyl;
        int dy;
        Rectangle bb = ctrl.getBounds();
        Rectangle displayBB = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bb);
        int dxl = cursorPos.x - displayBB.x;
        int dxr = displayBB.x + displayBB.width - cursorPos.x;
        int dx = Math.min(dxl, dxr);
        int where = dx < (dy = Math.min(dyl = cursorPos.y - displayBB.y, dyr = displayBB.y + displayBB.height - cursorPos.y)) ? (dxl < dxr ? 2 : 3) : (dyl < dyr ? 0 : 1);
        return where;
    }

    public boolean drop(MUIElement dragElement, CursorInfo info) {
        MElementContainer relParent;
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        MUIElement relTo = info.curElement;
        Control ctrl = (Control)relTo.getWidget();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (relTo.getCurSharedRef() != null) {
            relTo = relTo.getCurSharedRef();
        }
        if ((relParent = relTo.getParent()) instanceof MPartStack) {
            relTo = relParent;
        }
        if (dragElement.getParent() != null) {
            dragElement.getParent().getChildren().remove(dragElement);
        }
        MUIElement toInsert = dragElement;
        if (dragElement instanceof MStackElement) {
            MPartStack newPS = BasicFactoryImpl.eINSTANCE.createPartStack();
            newPS.getChildren().add((MStackElement)dragElement);
            newPS.setSelectedElement((MUIElement)((MStackElement)dragElement));
            toInsert = newPS;
        }
        this.modelService.insert((MPartSashContainerElement)toInsert, (MPartSashContainerElement)relTo, where, 50);
        return true;
    }

    public Cursor getCursor(Display display, MUIElement dragElement, CursorInfo info) {
        MPart dropPart = (MPart)info.curElement;
        Control ctrl = (Control)dropPart.getWidget();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (where == 0) {
            return display.getSystemCursor(10);
        }
        if (where == 1) {
            return display.getSystemCursor(11);
        }
        if (where == 2) {
            return display.getSystemCursor(13);
        }
        if (where == 3) {
            return display.getSystemCursor(12);
        }
        return display.getSystemCursor(4);
    }

    public Rectangle getRectangle(MUIElement dragElement, CursorInfo info) {
        MPart dropPart = (MPart)info.curElement;
        Control ctrl = (Control)dropPart.getWidget();
        if (ctrl.getParent() instanceof CTabFolder) {
            ctrl = ctrl.getParent();
        }
        Rectangle bounds = ctrl.getBounds();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (where == 0) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height / 2);
        }
        if (where == 1) {
            bounds = new Rectangle(bounds.x, bounds.y + bounds.height / 2, bounds.width, bounds.height / 2);
        }
        if (where == 2) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width / 2, bounds.height);
        }
        if (where == 3) {
            bounds = new Rectangle(bounds.x + bounds.width / 2, bounds.y, bounds.width / 2, bounds.height);
        }
        return ctrl.getDisplay().map((Control)ctrl.getParent(), null, bounds);
    }
}

