/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartServiceImpl
implements EPartService {
    private EventHandler selectedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (!PartServiceImpl.this.listeners.isEmpty()) {
                MPart selectedPart;
                Object selected;
                Object oldSelected = event.getProperty("OldValue");
                if (oldSelected instanceof MPlaceholder) {
                    oldSelected = ((MPlaceholder)oldSelected).getRef();
                }
                if ((selected = event.getProperty("NewValue")) instanceof MPlaceholder) {
                    selected = ((MPlaceholder)selected).getRef();
                }
                MPart oldSelectedPart = oldSelected instanceof MPart ? (MPart)oldSelected : null;
                MPart mPart = selectedPart = selected instanceof MPart ? (MPart)selected : null;
                if (oldSelectedPart != null && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    PartServiceImpl.this.firePartHidden(oldSelectedPart);
                }
                if (selectedPart != null && selectedPart.isToBeRendered() && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    PartServiceImpl.this.firePartVisible(selectedPart);
                    PartServiceImpl.this.firePartBroughtToTop(selectedPart);
                }
            }
        }
    };
    @Inject
    private MApplication application;
    private MElementContainer<MUIElement> rootContainer;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private EModelService modelService;
    @Inject
    private Logger logger;
    @Inject
    @Optional
    private ISaveHandler saveHandler;
    @Inject
    private IEventBroker eventBroker;
    private MPart activePart;
    private MPart lastActivePart;
    private ListenerList listeners = new ListenerList();
    private boolean constructed = false;

    @Inject
    public void setRootContainer(@Named(value="partServiceRoot") MElementContainer root) {
        this.rootContainer = root;
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart p) {
        if (this.activePart != p) {
            this.lastActivePart = this.activePart;
            this.activePart = p;
            if (this.constructed && !this.listeners.isEmpty()) {
                if (this.lastActivePart != null && this.lastActivePart != this.activePart) {
                    this.firePartDeactivated(this.lastActivePart);
                }
                if (this.activePart != null) {
                    this.firePartActivated(this.activePart);
                }
            }
        }
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/ElementContainer", "selectedElement"), this.selectedHandler);
        this.constructed = true;
        if (this.rootContainer == null) {
            this.application.getContext().runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext eventsContext) {
                    IEclipseContext childContext = (IEclipseContext)eventsContext.getLocal("activeChildContext");
                    if (childContext != null) {
                        PartServiceImpl.this.rootContainer = (MElementContainer)childContext.get(MWindow.class.getName());
                    }
                    return true;
                }
            });
        }
    }

    @PreDestroy
    void preDestroy() {
        this.constructed = false;
        this.eventBroker.unsubscribe(this.selectedHandler);
    }

    private void firePartActivated(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partActivated(part);
            ++n2;
        }
    }

    private void firePartDeactivated(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partDeactivated(part);
            ++n2;
        }
    }

    private void firePartHidden(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partHidden(part);
            ++n2;
        }
    }

    private void firePartVisible(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partVisible(part);
            ++n2;
        }
    }

    private void firePartBroughtToTop(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partBroughtToTop(part);
            ++n2;
        }
    }

    @Override
    public void addPartListener(IPartListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePartListener(IPartListener listener) {
        this.listeners.remove((Object)listener);
    }

    private MWindow getWindow() {
        return (MWindow)((MContext)this.rootContainer).getContext().get(MWindow.class);
    }

    private MContext getParentWithContext(MUIElement part) {
        MElementContainer parent;
        MElementContainer intermediate = parent = part.getParent();
        while (parent != null) {
            if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                return (MContext)parent;
            }
            intermediate = parent;
            parent = parent.getParent();
        }
        MPlaceholder placeholder = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)intermediate);
        parent = placeholder.getParent();
        while (parent != null) {
            if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                return (MContext)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void bringToTop(MPart part) {
        if (this.isInContainer(part)) {
            MElementContainer parent = part.getParent();
            if (parent == null) {
                parent = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)part).getParent();
            }
            MUIElement oldSelectedElement = parent.getSelectedElement();
            this.modelService.bringToTop(this.getWindow(), (MUIElement)part);
            if (oldSelectedElement != part && parent.getChildren().contains(part) && parent instanceof MGenericStack) {
                this.internalFixContext(part, oldSelectedElement);
            }
        }
    }

    private IEclipseContext getSubContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        if (element instanceof MElementContainer) {
            MUIElement selectedElement = ((MElementContainer)element).getSelectedElement();
            if (selectedElement instanceof MContext) {
                return ((MContext)selectedElement).getContext();
            }
            if (selectedElement instanceof MElementContainer) {
                return this.getSubContext(selectedElement);
            }
        }
        return null;
    }

    private void internalFixContext(MPart part, MUIElement oldSelectedElement) {
        if (oldSelectedElement == null) {
            return;
        }
        MContext parentPart = this.getParentWithContext(oldSelectedElement);
        if (parentPart == null) {
            return;
        }
        IEclipseContext parentContext = parentPart.getContext();
        IEclipseContext oldContext = this.getSubContext(oldSelectedElement);
        Object child = parentContext.get("activeChildContext");
        if (child == null || oldContext == null || child == oldContext) {
            parentContext.set("activeChildContext", (Object)(part == null ? null : part.getContext()));
        }
    }

    @Override
    public MPart findPart(String id) {
        MUIElement element = this.modelService.find(id, (MUIElement)this.rootContainer);
        if (element instanceof MPlaceholder) {
            ((MPlaceholder)element).getRef().setCurSharedRef((MPlaceholder)element);
            element = ((MPlaceholder)element).getRef();
        }
        return element instanceof MPart ? (MPart)element : null;
    }

    @Override
    public Collection<MPart> getParts() {
        return this.modelService.findElements((MUIElement)this.rootContainer, null, MPart.class, null);
    }

    @Override
    public boolean isPartVisible(MPart part) {
        if (this.isInContainer(part)) {
            MElementContainer parent = part.getParent();
            if (parent instanceof MPartStack) {
                return parent.getSelectedElement() == part;
            }
            return part.isVisible();
        }
        return false;
    }

    private boolean isInContainer(MPart part) {
        return this.isInContainer(this.rootContainer, part);
    }

    private boolean isInContainer(MElementContainer<?> container, MPart part) {
        for (Object object : container.getChildren()) {
            if (object == part) {
                return true;
            }
            if (object instanceof MElementContainer) {
                if (!this.isInContainer((MElementContainer)object, part)) continue;
                return true;
            }
            if (object instanceof MPlaceholder) {
                MUIElement ref = ((MPlaceholder)object).getRef();
                if (ref == part) {
                    return true;
                }
                if (!(ref instanceof MElementContainer) || !this.isInContainer((MElementContainer)ref, part)) continue;
                return true;
            }
            if (object instanceof MPerspective) {
                MPerspective persp = (MPerspective)object;
                for (MWindow dw : persp.getWindows()) {
                    if (!this.isInContainer((MElementContainer<?>)dw, part)) continue;
                    return true;
                }
                continue;
            }
            if (!(object instanceof MWindow)) continue;
            MWindow win = (MWindow)object;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, part)) continue;
                return true;
            }
        }
        if (container instanceof MWindow) {
            MWindow win = (MWindow)container;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, part)) continue;
                return true;
            }
        }
        if (container instanceof MPerspective) {
            MPerspective persp = (MPerspective)container;
            for (MWindow dw : persp.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, part)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void activate(MPart part) {
        this.activate(part, true);
    }

    @Override
    public void activate(MPart part, boolean requiresFocus) {
        if (part == this.activePart) {
            return;
        }
        if (!this.isInContainer(part)) {
            return;
        }
        this.modelService.bringToTop(this.getWindow(), (MUIElement)part);
        IEclipseContext context = part.getContext();
        IEclipseContext parent = context.getParent();
        while (parent != null) {
            parent.set("activeChildContext", (Object)context);
            context = parent;
            parent = parent.getParent();
        }
        Object object = part.getObject();
        if (object != null && requiresFocus) {
            ContextInjectionFactory.invoke((Object)object, Focus.class, (IEclipseContext)part.getContext(), null);
        }
    }

    @Override
    public MPart getActivePart() {
        return this.activePart;
    }

    @Override
    public void deactivate(MPart part) {
        MElementContainer parent = part.getParent();
        MPart oldSelectedElement = (MPart)parent.getSelectedElement();
        if (oldSelectedElement == part) {
            parent.setSelectedElement(null);
            this.internalFixContext(null, (MUIElement)oldSelectedElement);
        }
    }

    private MPartDescriptor findDescriptor(String id) {
        for (MPartDescriptor descriptor : this.application.getDescriptors()) {
            if (!descriptor.getElementId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    private MPart createPart(MPartDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId(descriptor.getElementId());
        part.getMenus().addAll(descriptor.getMenus());
        part.setToolbar(descriptor.getToolbar());
        part.setCloseable(descriptor.isCloseable());
        part.setContributionURI(descriptor.getContributionURI());
        part.setLabel(descriptor.getLabel());
        part.setIconURI(descriptor.getIconURI());
        part.setTooltip(descriptor.getTooltip());
        part.getHandlers().addAll(descriptor.getHandlers());
        part.getTags().addAll(descriptor.getTags());
        part.getBindingContexts().addAll(descriptor.getBindingContexts());
        return part;
    }

    @Override
    public MPart createPart(String id) {
        MPartDescriptor descriptor = this.findDescriptor(id);
        return this.createPart(descriptor);
    }

    @Override
    public MPlaceholder createSharedPart(String id, MWindow sharedWindow) {
        return this.createSharedPart(id, sharedWindow, false);
    }

    @Override
    public MPlaceholder createSharedPart(String id, MWindow sharedWindow, boolean force) {
        MPart sharedPart = null;
        if (!force) {
            for (MUIElement element : sharedWindow.getSharedElements()) {
                if (!element.getElementId().equals(id)) continue;
                sharedPart = (MPart)element;
                break;
            }
        }
        if (sharedPart == null) {
            MPartDescriptor descriptor = this.findDescriptor(id);
            sharedPart = this.createPart(descriptor);
            if (sharedPart == null) {
                return null;
            }
            sharedWindow.getSharedElements().add(sharedPart);
        }
        MPlaceholder sharedPartRef = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        sharedPartRef.setElementId(sharedPart.getElementId());
        sharedPartRef.setRef((MUIElement)sharedPart);
        return sharedPartRef;
    }

    private MPart addPart(MPart providedPart, MPart localPart) {
        if (providedPart == localPart && this.isInContainer(providedPart)) {
            return providedPart;
        }
        MPartDescriptor descriptor = this.findDescriptor(providedPart.getElementId());
        if (descriptor == null) {
            if (providedPart != localPart) {
                MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
                if (providedPart.getCurSharedRef() instanceof MPlaceholder) {
                    stack.getChildren().add(providedPart.getCurSharedRef());
                } else {
                    stack.getChildren().add(providedPart);
                }
                this.rootContainer.getChildren().add(stack);
            }
        } else {
            if (providedPart != localPart && !descriptor.isAllowMultiple()) {
                return localPart;
            }
            if (this.isInContainer(providedPart)) {
                return providedPart;
            }
            String category = descriptor.getCategory();
            if (category == null) {
                this.addToLastContainer(null, providedPart);
            } else {
                List elements = this.modelService.findElements((MUIElement)this.rootContainer, null, null, Collections.singletonList(category));
                if (elements.isEmpty()) {
                    this.addToLastContainer(category, providedPart);
                } else {
                    Object element = elements.get(0);
                    if (element instanceof MPartStack) {
                        MPartStack stack = (MPartStack)element;
                        if (providedPart.getCurSharedRef() instanceof MPlaceholder) {
                            stack.getChildren().add(providedPart.getCurSharedRef());
                        } else {
                            stack.getChildren().add(providedPart);
                        }
                    } else if (element instanceof MElementContainer) {
                        ((MElementContainer)element).getChildren().add(providedPart);
                    } else {
                        this.addToLastContainer(category, providedPart);
                    }
                }
            }
        }
        return providedPart;
    }

    private void addToLastContainer(String category, MPart part) {
        MElementContainer<?> lastContainer = this.getLastContainer();
        if (lastContainer instanceof MPartStack) {
            MPartStack stack = (MPartStack)lastContainer;
            if (part.getCurSharedRef() instanceof MPlaceholder) {
                stack.getChildren().add(part.getCurSharedRef());
            } else {
                stack.getChildren().add(part);
            }
        } else {
            lastContainer.getChildren().add(part);
        }
        if (category != null) {
            lastContainer.getTags().add(category);
        }
    }

    private MElementContainer<?> getLastContainer() {
        MElementContainer<MUIElement> searchRoot = this.rootContainer;
        List children = searchRoot.getChildren();
        if (children.size() == 0) {
            MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
            searchRoot.getChildren().add(stack);
            return stack;
        }
        MElementContainer<?> lastContainer = this.getLastContainer(searchRoot, children);
        if (lastContainer == null) {
            MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
            searchRoot.getChildren().add(stack);
            return stack;
        }
        return lastContainer;
    }

    private MElementContainer<?> getLastContainer(MElementContainer<?> container, List<?> children) {
        if (children.isEmpty()) {
            return null;
        }
        int i = children.size() - 1;
        while (i > -1) {
            MElementContainer childContainer;
            MElementContainer<?> lastContainer;
            Object muiElement = children.get(i);
            if (muiElement instanceof MElementContainer && (lastContainer = this.getLastContainer(childContainer = (MElementContainer)muiElement, childContainer.getChildren())) != null) {
                return lastContainer;
            }
            --i;
        }
        return container;
    }

    private MPart showPart(EPartService.PartState partState, MPart providedPart, MPart localPart) {
        MPart part = this.addPart(providedPart, localPart);
        switch (partState) {
            case ACTIVATE: {
                this.activate(part);
                return part;
            }
            case VISIBLE: {
                MPart activePart = this.getActivePart();
                if (activePart == null) {
                    this.bringToTop(part);
                } else if (activePart.getParent() == part.getParent()) {
                    part.setToBeRendered(true);
                    if (part.getCurSharedRef() != null) {
                        part.getCurSharedRef().setToBeRendered(true);
                        this.engine.createGui((MUIElement)part.getCurSharedRef());
                    } else {
                        this.engine.createGui((MUIElement)part);
                    }
                } else {
                    this.bringToTop(part);
                }
                return part;
            }
            case CREATE: {
                part.setToBeRendered(true);
                if (part.getCurSharedRef() != null) {
                    part.getCurSharedRef().setToBeRendered(true);
                    this.engine.createGui((MUIElement)part.getCurSharedRef());
                } else {
                    this.engine.createGui((MUIElement)part);
                }
                return part;
            }
        }
        return part;
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)((Object)partState));
        MPart part = this.findPart(id);
        if (part != null) {
            return this.showPart(part, partState);
        }
        MPartDescriptor descriptor = this.findDescriptor(id);
        part = this.createPart(descriptor);
        if (part == null) {
            return null;
        }
        return this.showPart(partState, part, part);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)((Object)partState));
        MPart localPart = this.findPart(part.getElementId());
        if (localPart != null) {
            return this.showPart(partState, part, localPart);
        }
        return this.showPart(partState, part, part);
    }

    @Override
    public void hidePart(MPart part) {
        this.hidePart(part, false);
    }

    @Override
    public void hidePart(MPart part, boolean force) {
        if (this.isInContainer(part)) {
            Object toBeRemoved;
            MElementContainer parent;
            MPlaceholder sharedRef = part.getCurSharedRef();
            if (sharedRef != null) {
                sharedRef.setToBeRendered(false);
            } else {
                part.setToBeRendered(false);
            }
            if ((force || part.getTags().contains("removeOnHide")) && (parent = (toBeRemoved = sharedRef != null ? sharedRef : part).getParent()) != null) {
                List children = parent.getChildren();
                children.remove(toBeRemoved);
                if (parent.getSelectedElement() == toBeRemoved) {
                    if (children.isEmpty()) {
                        parent.setSelectedElement(null);
                    } else {
                        parent.setSelectedElement((MUIElement)children.get(0));
                    }
                }
            }
        }
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        ArrayList<MPart> dirtyParts = new ArrayList<MPart>();
        for (MPart part : this.getParts()) {
            if (!part.isDirty()) continue;
            dirtyParts.add(part);
        }
        return dirtyParts;
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        if (!part.isDirty()) {
            return true;
        }
        if (confirm && this.saveHandler != null) {
            switch (this.saveHandler.promptToSave(part)) {
                case NO: {
                    return true;
                }
                case CANCEL: {
                    return false;
                }
            }
        }
        Object client = part.getObject();
        try {
            ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)part.getContext());
        }
        catch (InjectionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                this.logger.error(e.getMessage());
            } else {
                this.logger.error(throwable);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean saveAll(boolean confirm) {
        Collection<MPart> dirtyParts = this.getDirtyParts();
        if (dirtyParts.isEmpty()) {
            return true;
        }
        if (confirm && this.saveHandler != null) {
            ISaveHandler.Save[] decisions;
            List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
            ISaveHandler.Save[] saveArray = decisions = this.saveHandler.promptToSave(dirtyPartsList);
            int n = decisions.length;
            int n2 = 0;
            while (n2 < n) {
                ISaveHandler.Save decision = saveArray[n2];
                if (decision == ISaveHandler.Save.CANCEL) {
                    return false;
                }
                ++n2;
            }
            int i = 0;
            while (i < decisions.length) {
                if (decisions[i] == ISaveHandler.Save.YES && !this.savePart(dirtyPartsList.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        for (MPart dirtyPart : dirtyParts) {
            if (this.savePart(dirtyPart, false)) continue;
            return false;
        }
        return true;
    }

    private Collection<MInputPart> getInputParts() {
        return this.modelService.findElements((MUIElement)this.rootContainer, null, MInputPart.class, null);
    }

    @Override
    public Collection<MInputPart> getInputParts(String inputUri) {
        Assert.isNotNull((Object)inputUri, (String)"Input uri must not be null");
        ArrayList<MInputPart> rv = new ArrayList<MInputPart>();
        for (MInputPart p : this.getInputParts()) {
            if (!inputUri.equals(p.getInputURI())) continue;
            rv.add(p);
        }
        return rv;
    }
}

