/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.pde.ui.templates.AbstractChoiceOption;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioChoiceOption
extends AbstractChoiceOption {
    private Button[] fButtons;
    private Label fLabel;

    public RadioChoiceOption(BaseOptionTemplateSection section, String name, String label, String[][] choices) {
        super(section, name, label, choices);
        Assert.isTrue((choices.length == 2 ? 1 : 0) != 0);
    }

    private Button createRadioButton(Composite parent, int span, String[] choice) {
        Button button = new Button(parent, 16);
        button.setData((Object)choice[0]);
        button.setText(choice[1]);
        GridData gd = this.fill((Control)button, span);
        gd.horizontalIndent = 10;
        return button;
    }

    public void createControl(Composite parent, int span) {
        this.fLabel = this.createLabel(parent, 1);
        this.fLabel.setEnabled(this.isEnabled());
        this.fill((Control)this.fLabel, span);
        Composite radioComp = this.createComposite(parent, span);
        GridData gd = this.fill((Control)radioComp, span);
        gd.horizontalIndent = 10;
        GridLayout layout = new GridLayout(this.fChoices.length, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        radioComp.setLayout((Layout)layout);
        this.fButtons = new Button[this.fChoices.length];
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (RadioChoiceOption.this.isBlocked()) {
                    return;
                }
                if (b.getSelection()) {
                    RadioChoiceOption.this.setValue(b.getData().toString());
                    RadioChoiceOption.this.getSection().validateOptions(RadioChoiceOption.this);
                }
            }
        };
        int i = 0;
        while (i < this.fChoices.length) {
            this.fButtons[i] = this.createRadioButton(radioComp, 1, this.fChoices[i]);
            this.fButtons[i].addSelectionListener((SelectionListener)listener);
            this.fButtons[i].setEnabled(this.isEnabled());
            ++i;
        }
        if (this.getChoice() != null) {
            this.selectChoice(this.getChoice());
        }
    }

    protected void setOptionValue(Object value) {
        if (this.fButtons != null && value != null) {
            this.selectChoice(value.toString());
        }
    }

    protected void setOptionEnabled(boolean enabled) {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(enabled);
            int i = 0;
            while (i < this.fButtons.length) {
                this.fButtons[i].setEnabled(enabled);
                ++i;
            }
        }
    }

    protected void selectOptionChoice(String choice) {
        int i = 0;
        while (i < this.fButtons.length) {
            Button button = this.fButtons[i];
            String bname = button.getData().toString();
            if (bname.equals(choice)) {
                button.setSelection(true);
            } else {
                button.setSelection(false);
            }
            ++i;
        }
    }
}

