/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.expressions.AndExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.services.LegacyEvalContext;

public class LegacyHandlerService
implements IHandlerService {
    static final String LEGACY_H_ID = "legacy::handler::";
    private IEclipseContext eclipseContext;
    private IEvaluationContext evalContext;
    private Expression defaultExpression = null;

    public static IHandlerActivation registerLegacyHandler(IEclipseContext context, String id, String cmdId, IHandler handler, Expression activeWhen) {
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        Command command = cs.getCommand(cmdId);
        E4HandlerProxy handlerProxy = new E4HandlerProxy(command, handler);
        HandlerActivation activation = new HandlerActivation(context, cmdId, handler, handlerProxy, activeWhen);
        LegacyHandlerService.addHandlerActivation(activation);
        EHandlerService hs = (EHandlerService)context.get(EHandlerService.class);
        hs.activateHandler(cmdId, (Object)new HandlerSelectionFunction(cmdId));
        return activation;
    }

    static void addHandlerActivation(HandlerActivation eActivation) {
        ArrayList<HandlerActivation> handlerActivations = (ArrayList<HandlerActivation>)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        handlerActivations = handlerActivations == null ? new ArrayList<HandlerActivation>() : new ArrayList(handlerActivations);
        handlerActivations.add(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    static void removeHandlerActivation(HandlerActivation eActivation) {
        ArrayList handlerActivations = (ArrayList)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        handlerActivations = handlerActivations == null ? new ArrayList() : new ArrayList(handlerActivations);
        handlerActivations.remove(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    public LegacyHandlerService(IEclipseContext context) {
        this.eclipseContext = context;
        this.evalContext = new LegacyEvalContext(this.eclipseContext);
        IWorkbenchWindow window = (IWorkbenchWindow)this.eclipseContext.get(IWorkbenchWindow.class.getName());
        if (window != null) {
            this.defaultExpression = new WorkbenchWindowExpression(window);
        }
    }

    public void addSourceProvider(ISourceProvider provider) {
    }

    public void removeSourceProvider(ISourceProvider provider) {
    }

    public void dispose() {
        WorkbenchPlugin.log("LegacyHandlerService.dispose: should it do something?");
    }

    public IHandlerActivation activateHandler(IHandlerActivation activation) {
        HandlerActivation handlerActivation = (HandlerActivation)activation;
        handlerActivation.participating = true;
        LegacyHandlerService.addHandlerActivation(handlerActivation);
        return activation;
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler) {
        return this.activateHandler(commandId, handler, this.defaultExpression, false);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, boolean global) {
        if (global || this.defaultExpression == null) {
            return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, handler, expression);
        }
        AndExpression andExpr = new AndExpression();
        andExpr.add(expression);
        andExpr.add(this.defaultExpression);
        return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, handler, andExpr);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriorities) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    public ExecutionEvent createExecutionEvent(Command command, Event event) {
        LegacyEvalContext legacy = new LegacyEvalContext(this.getFocusContext(PlatformUI.getWorkbench().getDisplay()));
        ExecutionEvent e = new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, (Object)legacy);
        return e;
    }

    public ExecutionEvent createExecutionEvent(ParameterizedCommand command, Event event) {
        LegacyEvalContext legacy = new LegacyEvalContext(this.getFocusContext(PlatformUI.getWorkbench().getDisplay()));
        ExecutionEvent e = new ExecutionEvent(command.getCommand(), command.getParameterMap(), (Object)event, (Object)legacy);
        return e;
    }

    public void deactivateHandler(IHandlerActivation activation) {
        HandlerActivation eActivation = (HandlerActivation)activation;
        eActivation.participating = false;
        LegacyHandlerService.removeHandlerActivation(eActivation);
    }

    public void deactivateHandlers(Collection activations) {
        Object[] array = activations.toArray();
        int i = 0;
        while (i < array.length) {
            ((HandlerActivation)array[i]).participating = false;
            ++i;
        }
        i = 0;
        while (i < array.length) {
            this.deactivateHandler((IHandlerActivation)array[i]);
            ++i;
        }
    }

    public Object executeCommand(String commandId, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        ECommandService cs = (ECommandService)this.getFocusContext(PlatformUI.getWorkbench().getDisplay()).get(ECommandService.class.getName());
        Command command = cs.getCommand(commandId);
        return this.executeCommand(ParameterizedCommand.generateCommand((Command)command, null), event);
    }

    public Object executeCommand(ParameterizedCommand command, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        EHandlerService hs = (EHandlerService)this.getFocusContext(PlatformUI.getWorkbench().getDisplay()).get(EHandlerService.class.getName());
        return hs.executeHandler(command);
    }

    public Object executeCommandInContext(ParameterizedCommand command, Event event, IEvaluationContext context) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        if (context instanceof LegacyEvalContext) {
            EHandlerService hs = (EHandlerService)((LegacyEvalContext)context).eclipseContext.get(EHandlerService.class.getName());
            return hs.executeHandler(command);
        }
        return this.executeCommand(command, event);
    }

    public IEvaluationContext createContextSnapshot(boolean includeSelection) {
        return new LegacyEvalContext(this.getFocusContext(PlatformUI.getWorkbench().getDisplay()).createChild());
    }

    public IEvaluationContext getCurrentState() {
        return this.evalContext;
    }

    public void readRegistry() {
        this.readDefaultHandlers();
        this.readHandlers();
    }

    /*
     * Unable to fully structure code
     */
    private void readHandlers() {
        registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class.getName());
        extPoint = registry.getExtensionPoint("org.eclipse.ui.handlers");
        var7_4 = elements = extPoint.getConfigurationElements();
        var6_5 = elements.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block5: {
                configElement = var7_4[var5_6];
                commandId = configElement.getAttribute("commandId");
                if (commandId == null || commandId.length() == 0 || (defaultHandler = configElement.getAttribute("class")) == null && configElement.getChildren("class").length == 0) break block5;
                activeWhen = null;
                awChildren = configElement.getChildren("activeWhen");
                if (awChildren.length <= 0) ** GOTO lbl24
                subChildren = awChildren[0].getChildren();
                if (subChildren.length != 1) {
                    Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), null);
                } else {
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        activeWhen = elementHandler.create(converter, subChildren[0]);
                    }
                    catch (CoreException e) {
                        Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), (Throwable)e);
                    }
lbl24:
                    // 3 sources

                    LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, (IHandler)new HandlerProxy(commandId, configElement, "class"), activeWhen);
                }
            }
            ++var5_6;
        }
    }

    private void readDefaultHandlers() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class.getName());
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.ui.commands");
        IConfigurationElement[] iConfigurationElementArray = elements = extPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultHandler;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String id = configElement.getAttribute("id");
            if (id != null && id.length() != 0 && ((defaultHandler = configElement.getAttribute("defaultHandler")) != null || configElement.getChildren("defaultHandler").length != 0)) {
                LegacyHandlerService.registerLegacyHandler(this.eclipseContext, id, id, (IHandler)new HandlerProxy(id, configElement, "defaultHandler"), null);
            }
            ++n2;
        }
    }

    public void setHelpContextId(IHandler handler, String helpContextId) {
    }

    private IEclipseContext getFocusContext(Display display) {
        Control control = display.getFocusControl();
        Object modelObj = null;
        while (control != null) {
            modelObj = control.getData("modelElement");
            if (modelObj instanceof MContext) {
                return ((MContext)modelObj).getContext();
            }
            control = control.getParent();
        }
        return this.eclipseContext;
    }

    static class HandlerSelectionFunction
    extends ContextFunction {
        private final String commandId;

        public HandlerSelectionFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context) {
            List handlerActivations = (List)context.get(LegacyHandlerService.LEGACY_H_ID + this.commandId);
            if (handlerActivations == null) {
                return null;
            }
            HandlerActivation bestActivation = null;
            LegacyEvalContext legacyEvalContext = new LegacyEvalContext(context);
            for (HandlerActivation handlerActivation : handlerActivations) {
                if (!handlerActivation.participating || !handlerActivation.evaluate(legacyEvalContext)) continue;
                if (bestActivation == null) {
                    bestActivation = handlerActivation;
                    continue;
                }
                int comparison = bestActivation.compareTo(handlerActivation);
                if (comparison >= 0) continue;
                bestActivation = handlerActivation;
            }
            if (bestActivation != null) {
                return bestActivation.proxy;
            }
            IEclipseContext parent = context.getParent();
            if (parent == null) {
                return null;
            }
            return parent.get("handler::" + this.commandId);
        }
    }
}

