/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.keys.IBindingService;

public final class BindingService
implements IBindingService {
    @Inject
    private MApplication application;
    @Inject
    private EBindingService bindingService;
    @Inject
    private ECommandService commandService;
    @Inject
    private BindingManager manager;
    @Inject
    @Optional
    private KeyBindingDispatcher dispatcher;
    private ArrayList<MBindingTable> tablesToRemove = new ArrayList();
    private ArrayList<Runnable> bindingsToRemove = new ArrayList();

    public void dispose() {
        System.err.println("BindingService.dispose()");
        for (Runnable r : this.bindingsToRemove) {
            r.run();
        }
        for (MBindingTable table : this.tablesToRemove) {
            this.application.getBindingTables().remove(table);
        }
    }

    public void addBindingManagerListener(IBindingManagerListener listener) {
        this.manager.addBindingManagerListener(listener);
    }

    public void removeBindingManagerListener(IBindingManagerListener listener) {
        this.manager.removeBindingManagerListener(listener);
    }

    public TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        Collection seq = this.bindingService.getSequencesFor(parameterizedCommand);
        return seq.toArray(new TriggerSequence[seq.size()]);
    }

    public TriggerSequence[] getActiveBindingsFor(String commandId) {
        return this.getActiveBindingsFor(this.commandService.createCommand(commandId, null));
    }

    public Scheme getActiveScheme() {
        return this.manager.getActiveScheme();
    }

    public TriggerSequence getBestActiveBindingFor(ParameterizedCommand command) {
        TriggerSequence seq = this.bindingService.getBestSequenceFor(command);
        return seq;
    }

    public TriggerSequence getBestActiveBindingFor(String commandId) {
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, null);
        return this.bindingService.getBestSequenceFor(cmd);
    }

    public String getBestActiveBindingFormattedFor(String commandId) {
        TriggerSequence sequence = this.bindingService.getBestSequenceFor(this.commandService.createCommand(commandId, null));
        return sequence == null ? null : sequence.format();
    }

    public Binding[] getBindings() {
        return this.manager.getBindings();
    }

    public TriggerSequence getBuffer() {
        if (this.dispatcher == null) {
            return KeySequence.getInstance();
        }
        return this.dispatcher.getBuffer();
    }

    public String getDefaultSchemeId() {
        return BindingPersistence.getDefaultSchemeId();
    }

    public Scheme[] getDefinedSchemes() {
        return this.manager.getDefinedSchemes();
    }

    public String getLocale() {
        return this.manager.getLocale();
    }

    public Map getPartialMatches(TriggerSequence trigger) {
        TriggerSequence[] prefixes = trigger.getPrefixes();
        int prefixesLength = prefixes.length;
        if (prefixesLength == 0) {
            return Collections.EMPTY_MAP;
        }
        Collection partialMatches = this.bindingService.getPartialMatches(trigger);
        HashMap prefixTable = new HashMap();
        for (Binding binding : partialMatches) {
            int i = 0;
            while (i < prefixesLength) {
                TriggerSequence prefix = prefixes[i];
                Object value = prefixTable.get(prefix);
                if (prefixTable.containsKey(prefix) && value instanceof Map) {
                    ((Map)value).put(prefixTable, binding);
                } else {
                    HashMap map = new HashMap();
                    prefixTable.put(prefix, map);
                    map.put(prefixTable, binding);
                }
                ++i;
            }
        }
        return prefixTable;
    }

    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.getPerfectMatch(trigger);
    }

    public String getPlatform() {
        return Util.getWS();
    }

    public Scheme getScheme(String schemeId) {
        return this.manager.getScheme(schemeId);
    }

    public boolean isKeyFilterEnabled() {
        return this.dispatcher == null ? false : this.dispatcher.getKeyDownFilter().isEnabled();
    }

    public boolean isPartialMatch(TriggerSequence trigger) {
        return this.bindingService.isPartialMatch(trigger);
    }

    public boolean isPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.isPerfectMatch(trigger);
    }

    public void openKeyAssistDialog() {
        E4Util.unsupported("openKeyAssistDialog");
    }

    public void readRegistryAndPreferences(ICommandService commandService) {
        BindingPersistence reader = new BindingPersistence(this.manager, commandService);
        reader.reRead();
        for (Binding binding : this.manager.getActiveBindingsDisregardingContextFlat()) {
            this.addBinding(binding);
        }
    }

    private MCommand findCommand(String id) {
        for (MCommand cmd : this.application.getCommands()) {
            if (!id.equals(cmd.getElementId())) continue;
            return cmd;
        }
        return null;
    }

    public void savePreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        E4Util.unsupported("savePreferences");
    }

    public void setKeyFilterEnabled(boolean enabled) {
        if (this.dispatcher != null) {
            this.dispatcher.getKeyDownFilter().setEnabled(enabled);
        }
    }

    public Collection getConflictsFor(TriggerSequence sequence) {
        return this.bindingService.getConflictsFor(sequence);
    }

    public final void addBinding(Binding binding) {
        MBindingTable table = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContextId().equals(binding.getContextId())) continue;
            table = bt;
            break;
        }
        if (table == null) {
            table = CommandsFactoryImpl.eINSTANCE.createBindingTable();
            this.tablesToRemove.add(table);
            table.setBindingContextId(binding.getContextId());
            table.setElementId(binding.getContextId());
            this.application.getBindingTables().add(table);
        }
        final MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        ParameterizedCommand parmCmd = binding.getParameterizedCommand();
        MCommand cmd = this.findCommand(parmCmd.getId());
        if (cmd == null) {
            return;
        }
        keyBinding.setCommand(cmd);
        keyBinding.setKeySequence(binding.getTriggerSequence().format());
        Iterator iterator = parmCmd.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            MParameter p = CommandsFactoryImpl.eINSTANCE.createParameter();
            p.setElementId((String)entry.getKey());
            p.setName((String)entry.getKey());
            p.setValue((String)entry.getValue());
            keyBinding.getParameters().add(p);
        }
        table.getBindings().add(keyBinding);
        if (!this.tablesToRemove.contains(table)) {
            final MBindingTable theTable = table;
            this.bindingsToRemove.add(new Runnable(){

                public void run() {
                    theTable.getBindings().remove(keyBinding);
                }
            });
        }
    }

    public final void removeBinding(Binding binding) {
        MBindingTable table = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContextId().equals(binding.getContextId())) continue;
            table = bt;
            break;
        }
        if (table == null) {
            return;
        }
        MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        ParameterizedCommand parmCmd = binding.getParameterizedCommand();
        MCommand cmd = this.findCommand(parmCmd.getId());
        if (cmd == null) {
            return;
        }
        keyBinding.setCommand(cmd);
        keyBinding.setKeySequence(binding.getTriggerSequence().format());
        Iterator iterator = parmCmd.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            MParameter p = CommandsFactoryImpl.eINSTANCE.createParameter();
            p.setElementId((String)entry.getKey());
            p.setName((String)entry.getKey());
            p.setValue((String)entry.getValue());
            keyBinding.getParameters().add(p);
        }
        table.getBindings().remove(keyBinding);
        this.manager.removeBinding(binding);
    }

    public BindingManager getBindingManager() {
        return this.manager;
    }
}

