/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.menus.ActionSet;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.EditorAction;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.ViewAction;
import org.eclipse.ui.internal.services.RegistryPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MenuPersistence
extends RegistryPersistence {
    private MApplication application;
    private IEclipseContext appContext;
    private ArrayList<MenuAdditionCacheEntry> cacheEntries = new ArrayList();
    private ArrayList<ActionSet> actionContributions = new ArrayList();
    private ArrayList<EditorAction> editorActionContributions = new ArrayList();
    private ArrayList<ViewAction> viewActionContributions = new ArrayList();
    private ArrayList<MMenuContribution> menuContributions = new ArrayList();
    private ArrayList<MToolBarContribution> toolBarContributions = new ArrayList();
    private ArrayList<MTrimContribution> trimContributions = new ArrayList();
    private final Comparator<IConfigurationElement> comparer = new Comparator<IConfigurationElement>(){

        @Override
        public int compare(IConfigurationElement c1, IConfigurationElement c2) {
            return c1.getContributor().getName().compareToIgnoreCase(c2.getContributor().getName());
        }
    };

    MenuPersistence(MApplication application, IEclipseContext appContext) {
        this.application = application;
        this.appContext = appContext;
    }

    @Override
    public final void dispose() {
        ControlContributionRegistry.clear();
        this.application.getMenuContributions().removeAll(this.menuContributions);
        this.application.getToolBarContributions().removeAll(this.toolBarContributions);
        this.application.getTrimContributions().removeAll(this.trimContributions);
        this.menuContributions.clear();
        this.cacheEntries.clear();
        this.actionContributions.clear();
        this.editorActionContributions.clear();
        this.viewActionContributions.clear();
        super.dispose();
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public boolean menusNeedUpdating(IRegistryChangeEvent event) {
        IExtensionDelta[] menuDeltas = event.getExtensionDeltas("org.eclipse.ui", "menus");
        return menuDeltas.length != 0;
    }

    @Override
    protected final void read() {
        super.read();
        this.readTrimAdditions();
        ArrayList<MMenuContribution> menuC = new ArrayList<MMenuContribution>();
        ArrayList<MToolBarContribution> toolbarC = new ArrayList<MToolBarContribution>();
        ArrayList<MTrimContribution> trimC = new ArrayList<MTrimContribution>();
        this.readAdditions(menuC, toolbarC, trimC);
        this.readActionSets(menuC, toolbarC, trimC);
        this.readEditorActions(menuC, toolbarC, trimC);
        this.readViewActions(menuC, toolbarC, trimC);
        ContributionsAnalyzer.mergeContributions(menuC, this.menuContributions);
        this.application.getMenuContributions().addAll(this.menuContributions);
        ContributionsAnalyzer.mergeToolBarContributions(toolbarC, this.toolBarContributions);
        this.application.getToolBarContributions().addAll(this.toolBarContributions);
        ContributionsAnalyzer.mergeTrimContributions(trimC, this.trimContributions);
        this.application.getTrimContributions().addAll(this.trimContributions);
    }

    public void readTrimAdditions() {
    }

    public void readAdditions(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] menusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int i = 0;
        while (i < menusExtensionPoint.length) {
            if ("menuContribution".equals(menusExtensionPoint[i].getName())) {
                configElements.add(menusExtensionPoint[i]);
            }
            ++i;
        }
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement configElement : configElements) {
            if (this.isProgramaticContribution(configElement)) {
                E4Util.unsupported("Programmatic Contribution Factories not supported");
                continue;
            }
            MenuAdditionCacheEntry menuContribution = new MenuAdditionCacheEntry(this.application, this.appContext, configElement, configElement.getAttribute("locationURI"), configElement.getNamespaceIdentifier());
            this.cacheEntries.add(menuContribution);
            menuContribution.addToModel(menuContributions, toolBarContributions, trimContributions);
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement menuAddition) {
        return menuAddition.getAttribute("class") != null;
    }

    private void readActionSets(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        configElements.addAll(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.ui.actionSets")));
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement element : configElements) {
            ActionSet actionSet = new ActionSet(this.application, this.appContext, element);
            this.actionContributions.add(actionSet);
            actionSet.addToModel(menuContributions, toolBarContributions, trimContributions);
        }
    }

    private void readEditorActions(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        configElements.addAll(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.ui.editorActions")));
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement element : configElements) {
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals("action")) {
                    EditorAction editorAction = new EditorAction(this.application, this.appContext, element, child);
                    this.editorActionContributions.add(editorAction);
                    editorAction.addToModel(menuContributions, toolBarContributions, trimContributions);
                }
                ++n2;
            }
        }
    }

    private void readViewActions(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        configElements.addAll(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.ui.viewActions")));
        Collections.sort(configElements, this.comparer);
        for (IConfigurationElement element : configElements) {
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals("action")) {
                    ViewAction viewAction = new ViewAction(this.application, this.appContext, element, child);
                    this.viewActionContributions.add(viewAction);
                    viewAction.addToModel(menuContributions, toolBarContributions, trimContributions);
                }
                ++n2;
            }
        }
    }
}

