/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;

public class ModelChangeTable {
    private Hashtable fChangeTable = new Hashtable();
    private int fTotalModelChanges = 0;
    private ArrayList fPreSelected = new ArrayList();

    public void addToChangeTable(IPluginModelBase model, IFile file, Object change, boolean selected) {
        ModelChange modelChange;
        if (change == null) {
            return;
        }
        if (this.fChangeTable.containsKey(model)) {
            modelChange = (ModelChange)this.fChangeTable.get(model);
        } else {
            modelChange = new ModelChange(model, selected);
            this.fChangeTable.put(model, modelChange);
            ++this.fTotalModelChanges;
            if (selected) {
                this.fPreSelected.add(modelChange);
            }
        }
        modelChange.addChange(file, new ModelChangeElement(modelChange, change));
    }

    public Collection getAllModelChanges() {
        return this.fChangeTable.values();
    }

    public ModelChange getModelChange(IPluginModelBase modelKey) {
        if (this.fChangeTable.containsKey(modelKey)) {
            return (ModelChange)this.fChangeTable.get(modelKey);
        }
        return null;
    }

    public Object[] getPreSelected() {
        return this.fPreSelected.toArray();
    }

    public boolean hasPreSelected() {
        return this.fPreSelected.size() > 0;
    }

    public boolean isEmpty() {
        return this.fChangeTable.size() == 0;
    }
}

