/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.PreferenceInitializer;
import org.osgi.service.prefs.Preferences;

public class Utils {
    private static final String[] PREFERRED_AUTH_METHODS = new String[]{"gssapi-with-mic", "publickey", "password", "keyboard-interactive"};

    public static String getDefaultAuthMethods() {
        String defaultValue = PREFERRED_AUTH_METHODS[0];
        int i = 1;
        while (i < PREFERRED_AUTH_METHODS.length) {
            defaultValue = String.valueOf(defaultValue) + "," + PREFERRED_AUTH_METHODS[i];
            ++i;
        }
        return defaultValue;
    }

    public static String loadPrivateKeys(JSch jsch, String current_pkeys) {
        org.eclipse.core.runtime.Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        String ssh_home = preferences.getString("SSH2HOME");
        String pkeys = preferences.getString("PRIVATEKEY");
        if (ssh_home.length() == 0) {
            ssh_home = PreferenceInitializer.SSH_HOME_DEFAULT;
        }
        String[] pkey = pkeys.split(",");
        String[] _pkey = current_pkeys.split(",");
        String result = "";
        int i = 0;
        while (i < pkey.length) {
            File file = new File(pkey[i]);
            if (!file.isAbsolute()) {
                file = new File(ssh_home, pkey[i]);
            }
            if (file.exists()) {
                boolean notyet = true;
                int j = 0;
                while (j < _pkey.length) {
                    if (pkey[i].equals(_pkey[j])) {
                        notyet = false;
                        break;
                    }
                    ++j;
                }
                try {
                    if (notyet) {
                        jsch.addIdentity(file.getPath());
                    }
                    result = result.length() == 0 ? pkey[i] : String.valueOf(result) + "," + pkey[i];
                }
                catch (JSchException e) {
                    JSchCorePlugin.log(4, "An error occurred loading the SSH2 private keys", e);
                }
            }
            ++i;
        }
        return result;
    }

    public static Session createSession(JSch jsch, String username, String hostname, int port) throws JSchException {
        if (port == -1) {
            port = 22;
        }
        Session session = jsch.getSession(username, hostname, port);
        Utils.setProxy(session);
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("PreferredAuthentications", Utils.getEnabledPreferredAuthMethods());
        session.setConfig(config);
        return session;
    }

    public static void setProxy(Session session) {
        Proxy proxy = Utils.getProxyForHost(session.getHost(), "SOCKS");
        if (proxy == null) {
            proxy = Utils.getProxyForHost(session.getHost(), "HTTPS");
        }
        if (proxy != null) {
            session.setProxy(proxy);
        }
    }

    private static int getPort(IProxyData data) {
        int port = data.getPort();
        if (port == -1) {
            if (data.getType().equals("HTTP")) {
                port = 80;
            } else if (data.getType().equals("HTTPS")) {
                port = 443;
            } else if (data.getType().equals("SOCKS")) {
                port = 1080;
            }
        }
        return port;
    }

    private static IProxyData getProxyData(String host, String type) {
        IProxyService proxyService = JSchCorePlugin.getPlugin().getProxyService();
        if (proxyService == null) {
            return null;
        }
        IProxyData data = proxyService.getProxyDataForHost(host, type);
        if (data == null || data.getHost() == null || Utils.getJSchProxyType(data) == null) {
            return null;
        }
        return data;
    }

    private static String getJSchProxyType(IProxyData data) {
        if (data.getType().equals("HTTPS")) {
            return "HTTP";
        }
        if (data.getType().equals("SOCKS")) {
            return "SOCKS5";
        }
        return null;
    }

    public static Proxy getProxyForHost(String host, String proxyType) {
        IProxyService proxyService = JSchCorePlugin.getPlugin().getProxyService();
        if (proxyService == null) {
            return null;
        }
        boolean useProxy = proxyService.isProxiesEnabled();
        if (!useProxy) {
            return null;
        }
        ProxyHTTP proxy = null;
        IProxyData data = Utils.getProxyData(host, proxyType);
        if (data == null) {
            return null;
        }
        String _type = Utils.getJSchProxyType(data);
        if (_type == null) {
            return null;
        }
        String _host = data.getHost();
        int _port = Utils.getPort(data);
        boolean useAuth = data.isRequiresAuthentication();
        String _user = "";
        String _pass = "";
        if (useAuth) {
            _user = data.getUserId();
            _pass = data.getPassword();
        }
        String proxyhost = String.valueOf(_host) + ":" + _port;
        if (_type.equals("HTTP")) {
            proxy = new ProxyHTTP(proxyhost);
            if (useAuth) {
                proxy.setUserPasswd(_user, _pass);
            }
        } else if (_type.equals("SOCKS5")) {
            proxy = new ProxySOCKS5(proxyhost);
            if (useAuth) {
                ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
            }
        }
        return proxy;
    }

    public static void migrateSSH2Preferences() {
        org.eclipse.core.runtime.Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences")) {
            preferences.setValue("org.eclipse.jsch.core.hasMigratedSsh2Preferences", true);
            Utils.migrateSSH2Preferences((Preferences)new InstanceScope().getNode(""));
        }
    }

    public static void migrateSSH2Preferences(Preferences node) {
        Preferences jschPrefs = node.node(JSchCorePlugin.ID);
        Preferences ssh2Prefs = node.node("org.eclipse.team.cvs.ssh2");
        String oldHome = ssh2Prefs.get("CVSSSH2PreferencePage.SSH2HOME", null);
        String oldKey = ssh2Prefs.get("CVSSSH2PreferencePage.PRIVATEKEY", null);
        if (oldHome != null) {
            jschPrefs.put("SSH2HOME", oldHome);
            ssh2Prefs.remove("CVSSSH2PreferencePage.SSH2HOME");
        }
        if (oldKey != null) {
            jschPrefs.put("PRIVATEKEY", oldKey);
            ssh2Prefs.remove("CVSSSH2PreferencePage.PRIVATEKEY");
        }
    }

    public static String getEnabledPreferredAuthMethods() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_AUTH_METHODS", Utils.getDefaultAuthMethods(), null);
    }

    public static String getMethodsOrder() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getString(JSchCorePlugin.ID, "CVSSSH2PreferencePage.PREF_AUTH_METHODS_ORDER", Utils.getDefaultAuthMethods(), null);
    }

    public static void setEnabledPreferredAuthMethods(String methods, String order) {
        IPreferencesService service = Platform.getPreferencesService();
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_AUTH_METHODS", methods);
        service.getRootNode().node("instance").node(JSchCorePlugin.ID).put("CVSSSH2PreferencePage.PREF_AUTH_METHODS_ORDER", order);
    }
}

