/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;

public class ScpFromMessageBySftp
extends ScpFromMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private String remoteFile;
    private File localFile;
    private boolean isRecursive = false;
    private boolean verbose = false;

    public ScpFromMessageBySftp(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        super(verbose, session);
        this.verbose = verbose;
        this.remoteFile = aRemoteFile;
        this.localFile = aLocalFile;
        this.isRecursive = recursive;
    }

    public ScpFromMessageBySftp(Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(false, session, aRemoteFile, aLocalFile, recursive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException, JSchException {
        block8: {
            ChannelSftp channel = this.openSftpChannel();
            try {
                try {
                    channel.connect();
                    try {
                        SftpATTRS attrs = channel.stat(this.remoteFile);
                        if (attrs.isDir() && !this.remoteFile.endsWith("/")) {
                            this.remoteFile = this.remoteFile + "/";
                        }
                    }
                    catch (SftpException ee) {
                        // empty catch block
                    }
                    this.getDir(channel, this.remoteFile, this.localFile);
                }
                catch (SftpException e) {
                    throw new JSchException(e.toString());
                }
                Object var4_5 = null;
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (channel != null) {
                    channel.disconnect();
                }
                throw throwable;
            }
            channel.disconnect();
        }
        this.log("done\n");
    }

    private void getDir(ChannelSftp channel, String remoteFile, File localFile) throws IOException, SftpException {
        String pwd = remoteFile;
        if (remoteFile.lastIndexOf(47) != -1 && remoteFile.length() > 1) {
            pwd = remoteFile.substring(0, remoteFile.lastIndexOf(47));
        }
        channel.cd(pwd);
        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        Vector files = channel.ls(remoteFile);
        for (int i = 0; i < files.size(); ++i) {
            ChannelSftp.LsEntry le = (ChannelSftp.LsEntry)files.elementAt(i);
            String name = le.getFilename();
            if (le.getAttrs().isDir()) {
                if (name.equals(".") || name.equals("..")) continue;
                this.getDir(channel, channel.pwd() + "/" + name + "/", new File(localFile, le.getFilename()));
                continue;
            }
            this.getFile(channel, le, localFile);
        }
        channel.cd("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFile(ChannelSftp channel, ChannelSftp.LsEntry le, File localFile) throws IOException, SftpException {
        boolean trackProgress;
        String remoteFile = le.getFilename();
        if (!localFile.exists()) {
            String path = localFile.getAbsolutePath();
            int i = 0;
            i = path.lastIndexOf(File.pathSeparator);
            if (i != -1 && path.length() > File.pathSeparator.length()) {
                new File(path.substring(0, i)).mkdirs();
            }
        }
        if (localFile.isDirectory()) {
            localFile = new File(localFile, remoteFile);
        }
        long startTime = System.currentTimeMillis();
        long totalLength = le.getAttrs().getSize();
        SftpProgressMonitor monitor = null;
        boolean bl = trackProgress = this.getVerbose() && totalLength > 102400L;
        if (trackProgress) {
            monitor = this.getProgressMonitor();
        }
        try {
            this.log("Receiving: " + remoteFile + " : " + le.getAttrs().getSize());
            channel.get(remoteFile, localFile.getAbsolutePath(), monitor);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, (int)totalLength);
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        this.logStats(startTime, endTime, (int)totalLength);
    }
}

