/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.samples.ProjectNamesPage;
import org.eclipse.pde.internal.ui.samples.ReviewPage;
import org.eclipse.pde.internal.ui.samples.SampleOperation;
import org.eclipse.pde.internal.ui.samples.SelectionPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;

public class SampleWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement[] samples;
    private IConfigurationElement selection;
    private ProjectNamesPage namesPage;
    private ReviewPage lastPage;
    private boolean sampleEditorNeeded = true;
    private boolean switchPerspective = true;
    private boolean selectRevealEnabled = true;
    private boolean activitiesEnabled = true;

    public SampleWizard() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEXP_WIZ);
        this.samples = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.samples");
        this.namesPage = new ProjectNamesPage(this);
        this.lastPage = new ReviewPage(this);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEUIMessages.ShowSampleAction_title);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public IConfigurationElement[] getSamples() {
        return this.samples;
    }

    public void addPages() {
        if (this.selection == null) {
            this.addPage((IWizardPage)new SelectionPage(this));
        }
        this.addPage((IWizardPage)this.namesPage);
        this.addPage((IWizardPage)this.lastPage);
    }

    public boolean performFinish() {
        try {
            String perspId = this.selection.getAttribute("perspectiveId");
            IWorkbenchPage page = PDEPlugin.getActivePage();
            if (perspId != null && this.switchPerspective) {
                PlatformUI.getWorkbench().showPerspective(perspId, page.getWorkbenchWindow());
            }
            SampleOperation op = new SampleOperation(this.selection, this.namesPage.getProjectNames(), new ImportOverwriteQuery());
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            IFile sampleManifest = op.getSampleManifest();
            if (this.selectRevealEnabled) {
                this.selectReveal(this.getShell());
            }
            if (this.activitiesEnabled) {
                this.enableActivities();
            }
            if (this.sampleEditorNeeded && sampleManifest != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)sampleManifest, (boolean)true);
            }
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        return true;
    }

    public void selectReveal(Shell shell) {
    }

    public void enableActivities() {
        IConfigurationElement[] elements = this.selection.getChildren("activity");
        HashSet<String> activitiesToEnable = new HashSet<String>();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            if (id != null) {
                activitiesToEnable.add(id);
            }
            ++i;
        }
        HashSet<String> set = new HashSet<String>(workbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        set.addAll(activitiesToEnable);
        workbenchActivitySupport.setEnabledActivityIds(set);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String variable;
        String string = variable = data != null && data instanceof String ? data.toString() : null;
        if (variable != null) {
            int i = 0;
            while (i < this.samples.length) {
                IConfigurationElement element = this.samples[i];
                String id = element.getAttribute("id");
                if (id != null && id.equals(variable)) {
                    this.setSelection(element);
                    break;
                }
                ++i;
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public IConfigurationElement getSelection() {
        return this.selection;
    }

    public void setSelection(IConfigurationElement selection) {
        this.selection = selection;
    }

    public boolean isSampleEditorNeeded() {
        return this.sampleEditorNeeded;
    }

    public void setSampleEditorNeeded(boolean sampleEditorNeeded) {
        this.sampleEditorNeeded = sampleEditorNeeded;
    }

    public boolean isSwitchPerspective() {
        return this.switchPerspective;
    }

    public void setSwitchPerspective(boolean switchPerspective) {
        this.switchPerspective = switchPerspective;
    }

    public boolean isSelectRevealEnabled() {
        return this.selectRevealEnabled;
    }

    public void setSelectRevealEnabled(boolean selectRevealEnabled) {
        this.selectRevealEnabled = selectRevealEnabled;
    }

    public boolean getActivitiesEnabled() {
        return this.activitiesEnabled;
    }

    public void setActivitiesEnabled(boolean activitiesEnabled) {
        this.activitiesEnabled = activitiesEnabled;
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(String file) {
            int[] result = new int[]{1};
            SampleWizard.this.getShell().getDisplay().syncExec(new Runnable(this, file, result){
                final /* synthetic */ ImportOverwriteQuery this$1;
                private final /* synthetic */ String val$file;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = importOverwriteQuery;
                    this.val$file = string;
                    this.val$result = nArray;
                }

                public void run() {
                    String title = PDEUIMessages.SampleWizard_title;
                    String msg = NLS.bind((String)PDEUIMessages.SampleWizard_overwrite, (Object)this.val$file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ImportOverwriteQuery.access$1(this.this$1).getShell(), title, null, msg, 3, options, 0);
                    this.val$result[0] = dialog.open();
                }
            });
            return result[0];
        }

        static /* synthetic */ SampleWizard access$1(ImportOverwriteQuery importOverwriteQuery) {
            return importOverwriteQuery.SampleWizard.this;
        }
    }
}

