/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.ReferenceAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.SinceTagChecker;
import org.eclipse.pde.api.tools.internal.builder.TagValidator;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.IVersionRange;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;

public class BaseApiAnalyzer
implements IApiAnalyzer {
    private static final String QUALIFIER = "qualifier";
    static final String[] NO_TYPES = new String[0];
    private static boolean DEBUG = Util.DEBUG;
    private ArrayList fProblems = new ArrayList(25);
    private List fPendingDeltaInfos = new ArrayList(3);
    private BuildState fBuildState = null;
    private IApiFilterStore fFilterStore = null;
    private IJavaProject fJavaProject = null;
    private Properties fPreferences = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public void analyzeComponent(BuildState state, IApiFilterStore filterStore, Properties preferences, IApiBaseline baseline, IApiComponent component, IBuildContext context, IProgressMonitor monitor) {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_analyzing_api, (int)7);
        try {
            ResolverError[] errors;
            this.fJavaProject = this.getJavaProject(component);
            this.fFilterStore = filterStore;
            this.fPreferences = preferences;
            if (!this.ignoreUnusedProblemFilterCheck()) {
                ((ApiFilterStore)component.getFilterStore()).recordFilterUsage();
            }
            if ((errors = component.getErrors()) != null) {
                StringBuffer buffer = null;
                int i = 0;
                int max = errors.length;
                while (i < max) {
                    ResolverError error = errors[i];
                    VersionConstraint constraint = error.getUnsatisfiedConstraint();
                    if (constraint != null) {
                        String maximum;
                        VersionRange versionRange = constraint.getVersionRange();
                        String minimum = versionRange == null ? BuilderMessages.undefinedRange : versionRange.getMinimum().toString();
                        String string = maximum = versionRange == null ? BuilderMessages.undefinedRange : versionRange.getMaximum().toString();
                        if (buffer == null) {
                            buffer = new StringBuffer();
                        }
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(NLS.bind((String)BuilderMessages.reportUnsatisfiedConstraint, (Object[])new String[]{constraint.getName(), minimum, maximum}));
                    }
                    ++i;
                }
                if (buffer != null) {
                    this.createApiComponentResolutionProblem(component, String.valueOf(buffer));
                    if (baseline == null) {
                        this.checkDefaultBaselineSet();
                    }
                    return;
                }
            }
            try {
                IBuildContext bcontext = context;
                if (bcontext == null) {
                    bcontext = new BuildContext();
                }
                boolean checkfilters = false;
                if (baseline != null) {
                    IApiComponent reference = baseline.getApiComponent(component.getSymbolicName());
                    this.fBuildState = state;
                    if (this.fBuildState == null) {
                        this.fBuildState = this.getBuildState();
                    }
                    if (reference != null) {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object[])new String[]{reference.getSymbolicName(), baseline.getName()}));
                        if (bcontext.hasTypes()) {
                            String[] changedtypes = bcontext.getStructurallyChangedTypes();
                            this.checkCompatibility(changedtypes, reference, component, localMonitor);
                        } else {
                            this.checkCompatibility(reference, component, (IProgressMonitor)localMonitor.newChild(1));
                            Util.updateMonitor((IProgressMonitor)localMonitor);
                        }
                        this.fBuildState.setReexportedComponents(Util.getReexportedComponents(component));
                    } else {
                        localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_comparing_api_profiles, (Object[])new String[]{component.getSymbolicName(), baseline.getName()}));
                        this.checkCompatibility(null, component, (IProgressMonitor)localMonitor.newChild(1));
                        Util.updateMonitor((IProgressMonitor)localMonitor);
                    }
                    this.checkApiComponentVersion(reference, component);
                    Util.updateMonitor((IProgressMonitor)localMonitor);
                    checkfilters = true;
                } else {
                    this.checkDefaultBaselineSet();
                    Util.updateMonitor((IProgressMonitor)localMonitor);
                }
                this.checkApiUsage(bcontext, component, (IProgressMonitor)localMonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localMonitor);
                this.checkTagValidation(bcontext, component, (IProgressMonitor)localMonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localMonitor);
                if (checkfilters) {
                    this.checkUnusedProblemFilters(bcontext, component, (IProgressMonitor)localMonitor.newChild(1));
                }
                Util.updateMonitor((IProgressMonitor)localMonitor);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (DEBUG) {
                    System.out.println("Trapped OperationCanceledException");
                }
            }
        }
        finally {
            localMonitor.done();
        }
    }

    private void checkCompatibility(String[] changedtypes, IApiComponent reference, IApiComponent component, SubMonitor localMonitor) throws CoreException {
        int i = 0;
        while (i < changedtypes.length) {
            if (changedtypes[i] != null) {
                this.checkCompatibility(changedtypes[i], reference, component, (IProgressMonitor)localMonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localMonitor);
            }
            ++i;
        }
    }

    private void checkUnusedProblemFilters(IBuildContext context, IApiComponent reference, IProgressMonitor monitor) {
        block15: {
            if (this.ignoreUnusedProblemFilterCheck()) {
                if (DEBUG) {
                    System.out.println("Ignoring unused problem filter check");
                }
                Util.updateMonitor(monitor, 1);
                return;
            }
            try {
                try {
                    ApiFilterStore store = (ApiFilterStore)reference.getFilterStore();
                    IProject project = this.fJavaProject.getProject();
                    boolean autoremove = ApiPlugin.getDefault().getEnableState("automatically_removed_unused_problem_filters", project);
                    ArrayList toremove = null;
                    if (autoremove) {
                        toremove = new ArrayList(8);
                    }
                    Object[] filters = null;
                    if (context.hasTypes()) {
                        IResource resource = null;
                        String[] types = this.getApiUseTypes(context);
                        int i = 0;
                        while (i < types.length) {
                            if (types[i] != null && (resource = Util.getResource(project, this.fJavaProject.findType(Signatures.getPrimaryTypeName(types[i])))) != null) {
                                filters = store.getUnusedFilters(resource, types[i], null);
                                if (autoremove) {
                                    this.addToList(toremove, filters);
                                } else {
                                    this.createUnusedApiFilterProblems((IApiProblemFilter[])filters);
                                }
                            }
                            ++i;
                        }
                        if (autoremove) {
                            this.removeUnusedProblemFilters(store, toremove, monitor);
                        }
                        break block15;
                    }
                    filters = store.getUnusedFilters(null, null, null);
                    if (autoremove) {
                        this.addToList(toremove, filters);
                        this.removeUnusedProblemFilters(store, toremove, monitor);
                        break block15;
                    }
                    this.createUnusedApiFilterProblems((IApiProblemFilter[])filters);
                }
                catch (CoreException coreException) {
                    Util.updateMonitor(monitor, 1);
                }
            }
            finally {
                Util.updateMonitor(monitor, 1);
            }
        }
    }

    void addToList(List list, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                list.add(array[i]);
            }
            ++i;
        }
    }

    void removeUnusedProblemFilters(final IApiFilterStore store, final List filterlist, IProgressMonitor monitor) throws CoreException {
        if (filterlist.size() > 0) {
            IWorkspaceRunnable runner = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    store.removeFilters(filterlist.toArray(new IApiProblemFilter[filterlist.size()]));
                }
            };
            ResourcesPlugin.getWorkspace().run(runner, null, 1, monitor);
        }
    }

    private void createUnusedApiFilterProblems(IApiProblemFilter[] filters) {
        if (this.fJavaProject == null) {
            return;
        }
        IApiProblemFilter filter = null;
        IApiProblem problem = null;
        int i = 0;
        while (i < filters.length) {
            filter = filters[i];
            problem = filter.getUnderlyingProblem();
            if (problem == null) {
                return;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 0;
            int charStart = -1;
            int charEnd = 1;
            if (this.fJavaProject != null) {
                try {
                    IProject project;
                    String typeName = problem.getTypeName();
                    if (typeName != null) {
                        type = this.fJavaProject.findType(typeName.replace('$', '.'));
                    }
                    if ((resource = Util.getResource(project = this.fJavaProject.getProject(), type)) == null) {
                        return;
                    }
                    if (!Util.isManifest(resource.getProjectRelativePath()) && !type.isBinary()) {
                        ISourceRange range = type.getNameRange();
                        charStart = range.getOffset();
                        charEnd = charStart + range.getLength();
                        try {
                            IDocument document = Util.getDocument(type.getCompilationUnit());
                            lineNumber = document.getLineOfOffset(charStart);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
            String path = null;
            if (resource != null) {
                path = resource.getProjectRelativePath().toPortableString();
            }
            this.addProblem(ApiProblemFactory.newApiUsageProblem(path, problem.getTypeName(), new String[]{filter.getUnderlyingProblem().getMessage()}, new String[]{"filterhandle", "apiMarkerID"}, new Object[]{((ApiProblemFilter)filter).getHandle(), new Integer(9)}, lineNumber, charStart, charEnd, problem.getElementKind(), 10));
            ++i;
        }
    }

    private ReexportedBundleVersionInfo checkBundleVersionsOfReexportedBundles(IApiComponent reference, IApiComponent component) throws CoreException {
        IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
        int length = requiredComponents.length;
        ReexportedBundleVersionInfo info = null;
        if (length != 0) {
            int i = 0;
            while (i < length) {
                IRequiredComponentDescription description = requiredComponents[i];
                if (description.isExported()) {
                    String id = description.getId();
                    IRequiredComponentDescription[] requiredComponents2 = reference.getRequiredComponents();
                    IRequiredComponentDescription referenceDescription = null;
                    int length2 = requiredComponents2.length;
                    int j = 0;
                    while (j < length2) {
                        IRequiredComponentDescription description2 = requiredComponents2[j];
                        if (description2.getId().equals(id) && description2.isExported()) {
                            referenceDescription = description2;
                            break;
                        }
                        ++j;
                    }
                    if (referenceDescription != null) {
                        IVersionRange versionRange = description.getVersionRange();
                        IVersionRange versionRange2 = referenceDescription.getVersionRange();
                        Version currentLowerBound = new Version(versionRange.getMinimumVersion());
                        Version referenceLowerBound = new Version(versionRange2.getMinimumVersion());
                        int currentLowerMajorVersion = currentLowerBound.getMajor();
                        int referenceLowerMajorVersion = referenceLowerBound.getMajor();
                        int currentLowerMinorVersion = currentLowerBound.getMinor();
                        int referenceLowerMinorVersion = referenceLowerBound.getMinor();
                        if (currentLowerMajorVersion < referenceLowerMajorVersion || currentLowerMinorVersion < referenceLowerMinorVersion) {
                            return new ReexportedBundleVersionInfo(id, 5);
                        }
                        if (currentLowerMajorVersion > referenceLowerMajorVersion) {
                            return new ReexportedBundleVersionInfo(id, 5);
                        }
                        if (currentLowerMinorVersion > referenceLowerMinorVersion) {
                            info = new ReexportedBundleVersionInfo(id, 6);
                        }
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private CompilationUnit createAST(ITypeRoot root, int offset) {
        if (this.fJavaProject == null) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setFocalPosition(offset);
        parser.setResolveBindings(false);
        parser.setSource(root);
        Map options = this.fJavaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private BuildState getBuildState() {
        IProject project = null;
        if (this.fJavaProject != null) {
            project = this.fJavaProject.getProject();
        }
        if (project == null) {
            return new BuildState();
        }
        try {
            BuildState state = BuildState.getLastBuiltState(project);
            if (state != null) {
                return state;
            }
        }
        catch (CoreException coreException) {}
        return new BuildState();
    }

    private IApiTypeContainer getSearchScope(IApiComponent component, String[] typenames) {
        if (typenames == null) {
            return component;
        }
        if (typenames.length == 0) {
            return component;
        }
        return Factory.newTypeScope(component, this.getScopedElements(typenames));
    }

    private IReferenceTypeDescriptor[] getScopedElements(String[] typenames) {
        ArrayList<IReferenceTypeDescriptor> types = new ArrayList<IReferenceTypeDescriptor>(typenames.length);
        int i = 0;
        while (i < typenames.length) {
            if (typenames[i] != null) {
                types.add(Util.getType(typenames[i]));
            }
            ++i;
        }
        return types.toArray(new IReferenceTypeDescriptor[types.size()]);
    }

    public IApiProblem[] getProblems() {
        if (this.fProblems == null) {
            return new IApiProblem[0];
        }
        return this.fProblems.toArray(new IApiProblem[this.fProblems.size()]);
    }

    public void dispose() {
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        if (this.fPendingDeltaInfos != null) {
            this.fPendingDeltaInfos.clear();
            this.fPendingDeltaInfos = null;
        }
        if (this.fBuildState != null) {
            this.fBuildState = null;
        }
    }

    private boolean ignoreApiUsageScan() {
        if (this.fJavaProject == null) {
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        boolean ignore = true;
        ApiPlugin plugin = ApiPlugin.getDefault();
        ignore &= plugin.getSeverityLevel("ILLEGAL_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_INSTANTIATE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_REFERENCE", project) == 0;
        ignore &= plugin.getSeverityLevel("ILLEGAL_OVERRIDE", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_EXTEND", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_FIELD_DECL", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_IMPLEMENT", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_PARAM", project) == 0;
        ignore &= plugin.getSeverityLevel("LEAK_METHOD_RETURN_TYPE", project) == 0;
        return ignore &= plugin.getSeverityLevel("INVALID_REFERENCE_IN_SYSTEM_LIBRARIES", project) == 0;
    }

    private boolean reportApiBreakageWhenMajorVersionIncremented() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getEnableState("report_api_breakage_when_major_version_incremented", this.fJavaProject.getProject().getProject());
    }

    private boolean ignoreDefaultBaselineCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("missing_default_api_profile", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreSinceTagCheck(String pref) {
        if (this.fJavaProject == null) {
            return true;
        }
        IProject project = this.fJavaProject.getProject();
        ApiPlugin plugin = ApiPlugin.getDefault();
        if (pref == null) {
            boolean ignore = plugin.getSeverityLevel("malformed_since_tag", project) == 0;
            ignore &= plugin.getSeverityLevel("invalid_since_tag_version", project) == 0;
            return ignore &= plugin.getSeverityLevel("missing_since_tag", project) == 0;
        }
        return plugin.getSeverityLevel(pref, project) == 0;
    }

    private boolean ignoreComponentVersionCheck() {
        if (this.fJavaProject == null) {
            return false;
        }
        return ApiPlugin.getDefault().getSeverityLevel("incompatible_api_component_version", this.fJavaProject.getProject().getProject()) == 0;
    }

    private boolean ignoreMinorVersionCheckWithoutApiChange() {
        if (this.fJavaProject == null) {
            return true;
        }
        return !ApiPlugin.getDefault().getEnableState("incompatible_api_component_version_include_minor_without_api_change", this.fJavaProject.getProject().getProject());
    }

    private boolean ignoreMajorVersionCheckWithoutBreakingChange() {
        if (this.fJavaProject == null) {
            return true;
        }
        return !ApiPlugin.getDefault().getEnableState("incompatible_api_component_version_include_major_without_breaking_change", this.fJavaProject.getProject().getProject());
    }

    private boolean ignoreInvalidTagCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("INVALID_JAVADOC_TAG", this.fJavaProject.getProject()) == 0;
    }

    private boolean ignoreUnusedProblemFilterCheck() {
        if (this.fJavaProject == null) {
            return true;
        }
        return ApiPlugin.getDefault().getSeverityLevel("UNUSED_PROBLEM_FILTERS", this.fJavaProject.getProject()) == 0;
    }

    private void checkTagValidation(IBuildContext context, IApiComponent component, IProgressMonitor monitor) {
        if (this.ignoreInvalidTagCheck()) {
            return;
        }
        SubMonitor localMonitor = null;
        try {
            try {
                localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_validating_javadoc_tags, (int)(1 + component.getApiTypeContainers().length));
                if (context.hasTypes()) {
                    String[] typenames = context.getStructurallyChangedTypes();
                    int i = 0;
                    while (i < typenames.length) {
                        if (typenames[i] != null) {
                            localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)typenames[i]));
                            this.processType(typenames[i]);
                            Util.updateMonitor((IProgressMonitor)localMonitor);
                        }
                        ++i;
                    }
                } else {
                    try {
                        IPackageFragmentRoot[] roots = this.fJavaProject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                localMonitor.subTask(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_scanning_0, (Object)roots[i].getPath().toOSString()));
                                this.scanSource((IJavaElement)roots[i], (IProgressMonitor)localMonitor.newChild(1));
                                Util.updateMonitor((IProgressMonitor)localMonitor);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException jme) {
                        ApiPlugin.log(jme);
                    }
                }
                Util.updateMonitor((IProgressMonitor)localMonitor);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                if (localMonitor != null) {
                    localMonitor.done();
                }
            }
        }
        finally {
            if (localMonitor != null) {
                localMonitor.done();
            }
        }
    }

    private void scanSource(IJavaElement element, IProgressMonitor monitor) throws JavaModelException {
        try {
            switch (element.getElementType()) {
                case 3: 
                case 4: {
                    IParent parent = (IParent)element;
                    IJavaElement[] children = parent.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.scanSource(children[i], monitor);
                        Util.updateMonitor(monitor, 0);
                        ++i;
                    }
                    break;
                }
                case 5: {
                    ICompilationUnit unit = (ICompilationUnit)element;
                    this.processType(unit);
                    Util.updateMonitor(monitor, 0);
                }
            }
        }
        finally {
            if (monitor != null) {
                Util.updateMonitor(monitor);
                monitor.done();
            }
        }
    }

    private void processType(String typename) {
        try {
            ICompilationUnit cunit;
            IType type = this.fJavaProject.findType(typename);
            if (type != null && (cunit = type.getCompilationUnit()) != null) {
                this.processType(cunit);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void processType(ICompilationUnit cunit) {
        TagValidator tv = new TagValidator(cunit);
        CompilationUnit comp = this.createAST((ITypeRoot)cunit, 0);
        if (comp == null) {
            return;
        }
        comp.accept((ASTVisitor)tv);
        IApiProblem[] tagProblems = tv.getTagProblems();
        int i = 0;
        while (i < tagProblems.length) {
            this.addProblem(tagProblems[i]);
            ++i;
        }
    }

    private void checkApiUsage(IBuildContext context, IApiComponent component, IProgressMonitor monitor) throws CoreException {
        if (this.ignoreApiUsageScan()) {
            if (DEBUG) {
                System.out.println("Ignoring API usage scan");
            }
            return;
        }
        IApiTypeContainer scope = null;
        if (context.hasTypes()) {
            String[] typenames = this.getApiUseTypes(context);
            if (typenames.length < 1) {
                monitor.done();
                return;
            }
            scope = this.getSearchScope(component, typenames);
        } else {
            scope = this.getSearchScope(component, null);
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.checking_api_usage, (Object[])new String[]{component.getSymbolicName()}), (int)2);
        ReferenceAnalyzer analyzer = new ReferenceAnalyzer();
        try {
            try {
                long start = System.currentTimeMillis();
                IApiProblem[] illegal = analyzer.analyze(component, scope, (IProgressMonitor)localMonitor.newChild(2));
                Util.updateMonitor((IProgressMonitor)localMonitor);
                long end = System.currentTimeMillis();
                if (DEBUG) {
                    System.out.println("API usage scan: " + (end - start) + " ms\t" + illegal.length + " problems");
                }
                int i = 0;
                while (i < illegal.length) {
                    this.addProblem(illegal[i]);
                    ++i;
                }
                Util.updateMonitor((IProgressMonitor)localMonitor);
            }
            catch (CoreException ce) {
                if (DEBUG) {
                    ApiPlugin.log(ce);
                }
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    String[] getApiUseTypes(IBuildContext context) {
        if (context.hasTypes()) {
            int i;
            String[] deptypes = null;
            int size = 0;
            if (context.hasDescriptionDependents()) {
                deptypes = context.getDescriptionDependentTypes();
                size += deptypes.length;
            }
            String[] structtypes = context.getStructurallyChangedTypes();
            HashSet<String> typenames = new HashSet<String>(size + structtypes.length);
            if (deptypes != null) {
                i = 0;
                while (i < deptypes.length) {
                    if (deptypes[i] != null) {
                        typenames.add(deptypes[i]);
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < structtypes.length) {
                if (structtypes[i] != null) {
                    typenames.add(structtypes[i]);
                }
                ++i;
            }
            return typenames.toArray(new String[typenames.size()]);
        }
        return NO_TYPES;
    }

    /*
     * Unable to fully structure code
     */
    private void checkCompatibility(String typeName, IApiComponent reference, IApiComponent component, IProgressMonitor monitor) throws CoreException {
        block37: {
            block36: {
                id = component.getSymbolicName();
                if (BaseApiAnalyzer.DEBUG) {
                    System.out.println("comparing components [" + reference.getSymbolicName() + "] and [" + id + "] for type [" + typeName + "]");
                }
                classFile = null;
                try {
                    classFile = "org.eclipse.swt".equals(id) ? component.findTypeRoot(typeName) : component.findTypeRoot(typeName, id);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_checking_compat, (int)4);
                delta = null;
                provider = null;
                reexported = false;
                if (classFile == null) {
                    packageName = Signatures.getPackageName(typeName);
                    providers = component.getBaseline().resolvePackage(component, packageName);
                    index = 0;
                    while (classFile == null && index < providers.length) {
                        p = providers[index];
                        if (!p.equals(component) && (classFile = "org.eclipse.swt".equals(id2 = p.getSymbolicName()) != false ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2)) != null) {
                            components = component.getRequiredComponents();
                            i = 0;
                            while (i < components.length) {
                                description = components[i];
                                if (description.getId().equals(p.getSymbolicName()) && description.isExported()) {
                                    reexported = true;
                                    break;
                                }
                                ++i;
                            }
                            provider = p;
                        }
                        ++index;
                    }
                } else {
                    provider = component;
                }
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                if (classFile != null) ** GOTO lbl74
                referenceClassFile = null;
                try {
                    referenceClassFile = reference.findTypeRoot(typeName);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
                if (referenceClassFile == null) ** GOTO lbl72
                type = referenceClassFile.getStructure();
                if (type != null) break block36;
                localmonitor.done();
                return;
            }
            referenceApiDescription = reference.getApiDescription();
            elementDescription = referenceApiDescription.resolveAnnotations(type.getHandle());
            restrictions = 0;
            if (type.isMemberType() || type.isAnonymous() || type.isLocal()) ** GOTO lbl72
            visibility = 65535;
            if (elementDescription != null) {
                restrictions = elementDescription.getRestrictions();
                visibility = elementDescription.getVisibility();
            }
            if (!Util.isDefault(type.getModifiers()) && !Flags.isPrivate((int)type.getModifiers())) break block37;
            localmonitor.done();
            return;
        }
        try {
            block39: {
                if (VisibilityModifiers.isAPI(visibility)) {
                    deltaComponentID = Util.getDeltaComponentVersionsId(reference);
                    delta = new Delta(deltaComponentID, 2, 3, 46, restrictions, type.getModifiers(), 0, typeName, typeName, new String[]{typeName, Util.getComponentVersionsId(reference)});
                }
                {
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                    }
                }
lbl72:
                // 4 sources

                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                break block39;
lbl74:
                // 1 sources

                this.fBuildState.cleanup(typeName);
                time = System.currentTimeMillis();
                try {
                    try {
                        exporter = null;
                        if (reexported) {
                            exporter = component;
                        }
                        delta = ApiComparator.compare(classFile, reference, provider, exporter, reference.getBaseline(), provider.getBaseline(), 1, (IProgressMonitor)localmonitor.newChild(1));
                    }
                    catch (Exception e) {
                        ApiPlugin.log(e);
                        if (BaseApiAnalyzer.DEBUG) {
                            System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                        }
                        this.fPendingDeltaInfos.clear();
                        break block39;
                    }
                }
                catch (Throwable var14_23) {
                    if (BaseApiAnalyzer.DEBUG) {
                        System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                    throw var14_23;
                }
                if (BaseApiAnalyzer.DEBUG) {
                    System.out.println("Time spent for " + typeName + " : " + (System.currentTimeMillis() - time) + "ms");
                }
                this.fPendingDeltaInfos.clear();
            }
            if (delta == null) {
                return;
            }
            if (delta != ApiComparator.NO_DELTA) {
                allDeltas = Util.collectAllDeltas(delta);
                localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_processing_deltas);
                iterator = allDeltas.iterator();
                while (iterator.hasNext()) {
                    this.processDelta((IDelta)iterator.next(), reference, component);
                }
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                if (!this.fPendingDeltaInfos.isEmpty()) {
                    localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_checking_since_tags);
                    iterator = this.fPendingDeltaInfos.iterator();
                    while (iterator.hasNext()) {
                        this.checkSinceTags((Delta)iterator.next(), component);
                    }
                }
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            } else {
                Util.updateMonitor((IProgressMonitor)localmonitor, 2);
            }
        }
        catch (Throwable var19_32) {
            throw var19_32;
        }
        finally {
            localmonitor.done();
        }
    }

    private void checkCompatibility(IApiComponent reference, IApiComponent component, IProgressMonitor monitor) throws CoreException {
        long time = System.currentTimeMillis();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.BaseApiAnalyzer_checking_compat, (int)3);
        try {
            IDelta delta = null;
            if (reference == null) {
                delta = new Delta(null, 3, 1, 3, null, component.getSymbolicName(), component.getSymbolicName());
                Util.updateMonitor((IProgressMonitor)localmonitor, 5);
            } else {
                try {
                    delta = ApiComparator.compare(reference, component, 1, (IProgressMonitor)localmonitor.newChild(1));
                }
                finally {
                    if (DEBUG) {
                        System.out.println("Time spent for " + component.getSymbolicName() + " : " + (System.currentTimeMillis() - time) + "ms");
                    }
                    this.fPendingDeltaInfos.clear();
                }
            }
            if (delta == null) {
                return;
            }
            if (delta != ApiComparator.NO_DELTA) {
                List allDeltas = Util.collectAllDeltas(delta);
                if (allDeltas.size() != 0) {
                    localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_processing_deltas);
                    Iterator iterator = allDeltas.iterator();
                    while (iterator.hasNext()) {
                        this.processDelta((IDelta)iterator.next(), reference, component);
                    }
                    Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                    localmonitor.subTask(BuilderMessages.BaseApiAnalyzer_checking_since_tags);
                    if (!this.fPendingDeltaInfos.isEmpty()) {
                        iterator = this.fPendingDeltaInfos.iterator();
                        while (iterator.hasNext()) {
                            this.checkSinceTags((Delta)iterator.next(), component);
                        }
                    }
                    Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                }
            } else {
                Util.updateMonitor((IProgressMonitor)localmonitor, 2);
            }
        }
        finally {
            localmonitor.done();
        }
    }

    private void checkSinceTags(Delta delta, IApiComponent component) throws CoreException {
        if (this.ignoreSinceTagCheck(null)) {
            return;
        }
        IMember member = Util.getIMember(delta, this.fJavaProject);
        if (member == null || member.isBinary()) {
            return;
        }
        ICompilationUnit cunit = member.getCompilationUnit();
        if (cunit == null) {
            return;
        }
        try {
            if (!cunit.isConsistent()) {
                cunit.makeConsistent(null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IApiProblem problem = null;
        ISourceRange nameRange = null;
        try {
            nameRange = member.getNameRange();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            return;
        }
        if (nameRange == null) {
            return;
        }
        try {
            int offset = nameRange.getOffset();
            CompilationUnit comp = this.createAST((ITypeRoot)cunit, offset);
            if (comp == null) {
                return;
            }
            SinceTagChecker visitor = new SinceTagChecker(offset);
            comp.accept((ASTVisitor)visitor);
            String componentVersionId = delta.getComponentVersionId();
            String componentVersionString = null;
            componentVersionString = componentVersionId == null ? component.getVersion() : this.extractVersion(componentVersionId);
            try {
                String sinceVersion;
                if (visitor.hasNoComment() || visitor.isMissing()) {
                    if (this.ignoreSinceTagCheck("missing_since_tag")) {
                        if (DEBUG) {
                            System.out.println("Ignoring missing since tag problem");
                        }
                        return;
                    }
                    StringBuffer buffer = new StringBuffer();
                    Version componentVersion = new Version(componentVersionString);
                    buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                    problem = this.createSinceTagProblem(3, new String[]{Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                } else if (visitor.hasJavadocComment() && (sinceVersion = visitor.getSinceVersion()) != null) {
                    SinceTagVersion tagVersion = new SinceTagVersion(sinceVersion);
                    String postfixString = tagVersion.postfixString();
                    if (tagVersion.getVersion() == null || Util.getFragmentNumber(tagVersion.getVersionString()) > 2) {
                        if (this.ignoreSinceTagCheck("malformed_since_tag")) {
                            if (DEBUG) {
                                System.out.println("Ignoring malformed since tag problem");
                            }
                            return;
                        }
                        StringBuffer buffer = new StringBuffer();
                        if (tagVersion.prefixString() != null) {
                            buffer.append(tagVersion.prefixString());
                        }
                        Version componentVersion = new Version(componentVersionString);
                        buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        if (postfixString != null) {
                            buffer.append(postfixString);
                        }
                        problem = this.createSinceTagProblem(2, new String[]{sinceVersion, Util.getDeltaArgumentString(delta)}, delta, member, String.valueOf(buffer));
                    } else {
                        if (this.ignoreSinceTagCheck("invalid_since_tag_version")) {
                            if (DEBUG) {
                                System.out.println("Ignoring invalid tag version problem");
                            }
                            return;
                        }
                        StringBuffer accurateVersionBuffer = new StringBuffer();
                        Version componentVersion = new Version(componentVersionString);
                        accurateVersionBuffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
                        String accurateVersion = String.valueOf(accurateVersionBuffer);
                        if (Util.isDifferentVersion(sinceVersion, accurateVersion)) {
                            StringBuffer buffer = new StringBuffer();
                            if (tagVersion.prefixString() != null) {
                                buffer.append(tagVersion.prefixString());
                            }
                            Version version = new Version(accurateVersion);
                            buffer.append(version.getMajor()).append('.').append(version.getMinor());
                            if (postfixString != null) {
                                buffer.append(postfixString);
                            }
                            String accurateSinceTagValue = String.valueOf(buffer);
                            problem = this.createSinceTagProblem(1, new String[]{sinceVersion, accurateSinceTagValue, Util.getDeltaArgumentString(delta)}, delta, member, accurateSinceTagValue);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ApiPlugin.log(e);
            }
        }
        catch (RuntimeException e) {
            ApiPlugin.log(e);
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private String extractVersion(String componentVersionId) {
        int indexOfOpen = componentVersionId.lastIndexOf(40);
        return componentVersionId.substring(indexOfOpen + 1, componentVersionId.length() - 1);
    }

    private IApiProblem createSinceTagProblem(int kind, String[] messageargs, Delta info, IMember member, String version) {
        IResource resource;
        IType declaringType;
        block9: {
            try {
                declaringType = null;
                declaringType = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                resource = Util.getResource(this.fJavaProject.getProject(), declaringType);
                if (resource != null) break block9;
                return null;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                return null;
            }
        }
        int lineNumber = 1;
        int charStart = 0;
        int charEnd = 1;
        String qtn = null;
        qtn = member instanceof IType ? ((IType)member).getFullyQualifiedName() : declaringType.getFullyQualifiedName();
        String[] messageArguments = null;
        if (!Util.isManifest(resource.getProjectRelativePath())) {
            messageArguments = messageargs;
            ICompilationUnit unit = member.getCompilationUnit();
            ISourceRange range = member.getNameRange();
            charStart = range.getOffset();
            charEnd = charStart + range.getLength();
            try {
                IDocument document = Util.getDocument(unit);
                lineNumber = document.getLineOfOffset(charStart);
            }
            catch (BadLocationException e) {
                ApiPlugin.log(e);
            }
        } else if (!(member instanceof IType)) {
            int length = messageargs.length;
            messageArguments = new String[length];
            System.arraycopy(messageargs, 0, messageArguments, 0, length);
            StringBuffer buffer = new StringBuffer();
            buffer.append(qtn).append('.').append(messageargs[length - 1]);
            messageArguments[length - 1] = String.valueOf(buffer);
        } else {
            messageArguments = messageargs;
        }
        return ApiProblemFactory.newApiSinceTagProblem(resource.getProjectRelativePath().toPortableString(), qtn, messageArguments, new String[]{"version", "apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{version, new Integer(5), member.getHandleIdentifier()}, lineNumber, charStart, charEnd, info.getElementType(), kind);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createCompatibilityProblem(IDelta delta, IApiComponent reference, IApiComponent component) {
        try {
            Version referenceVersion = new Version(reference.getVersion());
            Version componentVersion = new Version(component.getVersion());
            if (referenceVersion.getMajor() < componentVersion.getMajor() && !this.reportApiBreakageWhenMajorVersionIncremented()) {
                this.fBuildState.addBreakingChange(delta);
                return null;
            }
            IResource resource = null;
            IType type = null;
            int lineNumber = 0;
            int charStart = -1;
            int charEnd = 1;
            IMember member = null;
            if (this.fJavaProject != null) {
                try {
                    type = this.fJavaProject.findType(delta.getTypeName().replace('$', '.'));
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                IProject project = this.fJavaProject.getProject();
                resource = Util.getResource(project, type);
                if (resource == null) {
                    return null;
                }
                if (!Util.isManifest(resource.getProjectRelativePath())) {
                    member = Util.getIMember(delta, this.fJavaProject);
                }
                if (member != null && !member.isBinary() && member.exists()) {
                    ISourceRange range = member.getNameRange();
                    charStart = range.getOffset();
                    charEnd = charStart + range.getLength();
                    try {
                        IDocument document = Util.getDocument(member.getCompilationUnit());
                        lineNumber = document.getLineOfOffset(charStart);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            String path = null;
            if (resource != null) {
                path = resource.getProjectRelativePath().toPortableString();
            }
            return ApiProblemFactory.newApiProblem(path, delta.getTypeName(), delta.getArguments(), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{member == null ? null : member.getHandleIdentifier(), new Integer(2)}, lineNumber, charStart, charEnd, 0x10000000, delta.getElementType(), delta.getKind(), delta.getFlags());
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private void createApiComponentResolutionProblem(IApiComponent component, String message) throws CoreException {
        IApiProblem problem = ApiProblemFactory.newApiComponentResolutionProblem(Path.EMPTY.toString(), new String[]{component.getSymbolicName(), message}, new String[]{"apiMarkerID"}, new Object[]{new Integer(8)}, 7, 1);
        this.addProblem(problem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDelta(IDelta delta, IApiComponent reference, IApiComponent component) {
        int flags = delta.getFlags();
        int kind = delta.getKind();
        int modifiers = delta.getNewModifiers();
        if (DeltaProcessor.isCompatible(delta)) {
            String typeName;
            if (RestrictionModifiers.isReferenceRestriction(delta.getRestrictions())) return;
            if (!Util.isVisible(modifiers)) return;
            if (Flags.isProtected((int)modifiers) && (typeName = delta.getTypeName()) != null) {
                IApiTypeRoot typeRoot = null;
                IApiMember type = null;
                try {
                    String id = component.getSymbolicName();
                    typeRoot = "org.eclipse.swt".equals(id) ? component.findTypeRoot(typeName) : component.findTypeRoot(typeName, id);
                    if (typeRoot == null) {
                        String packageName = Signatures.getPackageName(typeName);
                        IApiComponent[] providers = component.getBaseline().resolvePackage(component, packageName);
                        int index = 0;
                        while (typeRoot == null && index < providers.length) {
                            IApiComponent p = providers[index];
                            if (!p.equals(component)) {
                                String id2 = p.getSymbolicName();
                                typeRoot = "org.eclipse.swt".equals(id2) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2);
                            }
                            ++index;
                        }
                    }
                    if (typeRoot == null) {
                        return;
                    }
                    type = typeRoot.getStructure();
                }
                catch (CoreException coreException) {}
                if (type == null) return;
                if (Flags.isFinal((int)type.getModifiers())) {
                    return;
                }
            }
            switch (kind) {
                case 1: {
                    String deltaDetails;
                    switch (flags) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 46: 
                        case 48: {
                            if (DEBUG) {
                                deltaDetails = "Delta : " + Util.getDetail(delta);
                                System.out.println(String.valueOf(deltaDetails) + " is compatible");
                            }
                            this.fBuildState.addCompatibleChange(delta);
                            this.fPendingDeltaInfos.add(delta);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    String deltaDetails;
                    if (flags != 22) return;
                    if (DEBUG) {
                        deltaDetails = "Delta : " + Util.getDetail(delta);
                        System.out.println(String.valueOf(deltaDetails) + " is compatible");
                    }
                    this.fBuildState.addCompatibleChange(delta);
                    this.fPendingDeltaInfos.add(delta);
                }
            }
            return;
        }
        switch (kind) {
            case 1: {
                switch (flags) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 48: {
                        if (!Util.isVisible(modifiers)) break;
                        if (DEBUG) {
                            String deltaDetails = "Delta : " + Util.getDetail(delta);
                            System.err.println(String.valueOf(deltaDetails) + " is not compatible");
                        }
                        this.fPendingDeltaInfos.add(delta);
                    }
                }
                break;
            }
        }
        IApiProblem problem = this.createCompatibilityProblem(delta, reference, component);
        if (!this.addProblem(problem)) return;
        this.fBuildState.addBreakingChange(delta);
    }

    private void checkApiComponentVersion(IApiComponent reference, IApiComponent component) throws CoreException {
        IApiProblem problem;
        block42: {
            ReexportedBundleVersionInfo info;
            Version newversion;
            Version compversion;
            Version refversion;
            String compversionval;
            block43: {
                String refversionval;
                block41: {
                    IDelta[] breakingChanges;
                    if (this.ignoreComponentVersionCheck() || reference == null || component == null) {
                        if (DEBUG) {
                            System.out.println("Ignoring component version check");
                        }
                        return;
                    }
                    problem = null;
                    refversionval = reference.getVersion();
                    compversionval = component.getVersion();
                    refversion = new Version(refversionval);
                    compversion = new Version(compversionval);
                    newversion = null;
                    if (DEBUG) {
                        System.out.println("reference version of " + reference.getSymbolicName() + " : " + refversion);
                        System.out.println("component version of " + component.getSymbolicName() + " : " + compversion);
                    }
                    if ((breakingChanges = this.fBuildState.getBreakingChanges()).length == 0) break block41;
                    if (compversion.getMajor() <= refversion.getMajor()) {
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(1, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(breakingChanges));
                    }
                    break block42;
                }
                IDelta[] compatibleChanges = this.fBuildState.getCompatibleChanges();
                if (compatibleChanges.length != 0) {
                    if (compversion.getMajor() != refversion.getMajor()) {
                        if (!this.ignoreMajorVersionCheckWithoutBreakingChange()) {
                            newversion = new Version(refversion.getMajor(), refversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                            problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                        }
                    } else if (compversion.getMinor() <= refversion.getMinor()) {
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(2, new String[]{compversionval, refversionval}, String.valueOf(newversion), this.collectDetails(compatibleChanges));
                    }
                } else if (compversion.getMajor() != refversion.getMajor()) {
                    if (!this.ignoreMajorVersionCheckWithoutBreakingChange()) {
                        newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(3, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                    }
                } else if (compversion.getMinor() > refversion.getMinor() && !this.ignoreMinorVersionCheckWithoutApiChange()) {
                    newversion = new Version(refversion.getMajor(), refversion.getMinor(), refversion.getMicro(), refversion.getQualifier() != null ? QUALIFIER : null);
                    problem = this.createVersionProblem(4, new String[]{compversionval, refversionval}, String.valueOf(newversion), "");
                }
                info = null;
                if (problem == null) break block43;
                block0 : switch (problem.getKind()) {
                    case 3: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    problem = null;
                                    break block0;
                                }
                                case 6: {
                                    newversion = new Version(refversion.getMajor(), refversion.getMinor() + 1, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(5, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                }
                            }
                            break;
                        }
                        break block42;
                    }
                    case 2: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info != null) {
                            switch (info.kind) {
                                case 5: {
                                    newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                    problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                }
                            }
                            break;
                        }
                        break block42;
                    }
                    case 4: {
                        info = this.checkBundleVersionsOfReexportedBundles(reference, component);
                        if (info == null) break block42;
                        switch (info.kind) {
                            case 5: {
                                newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                                problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                                break block0;
                            }
                            case 6: {
                                problem = null;
                            }
                        }
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block42;
            }
            info = this.checkBundleVersionsOfReexportedBundles(reference, component);
            if (info != null) {
                switch (info.kind) {
                    case 5: {
                        if (compversion.getMajor() > refversion.getMajor()) break;
                        newversion = new Version(compversion.getMajor() + 1, 0, 0, compversion.getQualifier() != null ? QUALIFIER : null);
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                        break;
                    }
                    case 6: {
                        if (compversion.getMinor() > refversion.getMinor()) break;
                        newversion = new Version(compversion.getMajor(), compversion.getMinor() + 1, 0, compversion.getQualifier());
                        problem = this.createVersionProblem(info.kind, new String[]{compversionval, info.componentID}, String.valueOf(newversion), "");
                    }
                }
            }
        }
        if (problem != null) {
            this.addProblem(problem);
        }
    }

    private String collectDetails(IDelta[] deltas) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        int max = Math.min(20, deltas.length);
        int i = 0;
        while (i < max) {
            printWriter.print("- ");
            printWriter.println(deltas[i].getMessage());
            if (i == max - 1 && max < deltas.length) {
                printWriter.println(NLS.bind((String)BuilderMessages.BaseApiAnalyzer_more_version_problems, (Object)new Integer(deltas.length - max)));
            }
            ++i;
        }
        printWriter.flush();
        printWriter.close();
        return String.valueOf(writer.getBuffer());
    }

    private IApiProblem createVersionProblem(int kind, String[] messageargs, String version, String description) {
        int charEnd;
        int charStart;
        int lineNumber;
        String path;
        block35: {
            char[] contents;
            block34: {
                IResource manifestFile = null;
                path = "META-INF/MANIFEST.MF";
                if (this.fJavaProject != null) {
                    manifestFile = Util.getManifestFile(this.fJavaProject.getProject());
                }
                lineNumber = -1;
                charStart = 0;
                charEnd = 1;
                contents = null;
                if (manifestFile != null && manifestFile.getType() == 1) {
                    path = manifestFile.getProjectRelativePath().toPortableString();
                    IFile file = (IFile)manifestFile;
                    InputStream inputStream = null;
                    BufferedReader reader = null;
                    try {
                        inputStream = file.getContents(true);
                        contents = Util.getInputStreamAsCharArray(inputStream, -1, "UTF-8");
                        reader = new LineNumberReader(new BufferedReader(new StringReader(new String(contents))));
                        int lineCounter = 0;
                        String line = null;
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            ++lineCounter;
                            if (!line.startsWith("Bundle-Version")) continue;
                            lineNumber = lineCounter;
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException) {}
                        break block34;
                    }
                    catch (IOException iOException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            throw throwable;
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            break block34;
                        }
                        catch (IOException iOException3) {}
                        break block34;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (lineNumber != -1 && contents != null) {
                int index = CharOperation.indexOf((char[])"Bundle-Version".toCharArray(), (char[])contents, (boolean)true);
                int i = index + "Bundle-Version".length() + 1;
                int max = contents.length;
                while (i < max) {
                    char currentCharacter = contents[i];
                    if (!CharOperation.isWhitespace((char)currentCharacter)) {
                        charStart = i;
                        break;
                    }
                    ++i;
                }
                i = charStart + 1;
                max = contents.length;
                while (i < max) {
                    switch (contents[i]) {
                        case '\n': 
                        case '\r': {
                            charEnd = i;
                            break block35;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
            } else {
                lineNumber = 1;
            }
        }
        return ApiProblemFactory.newApiVersionNumberProblem(path, null, messageargs, new String[]{"version", "apiMarkerID", "description"}, new Object[]{version, new Integer(4), description}, lineNumber, charStart, charEnd, 7, kind);
    }

    private void checkDefaultBaselineSet() {
        if (this.ignoreDefaultBaselineCheck()) {
            if (DEBUG) {
                System.out.println("Ignoring check for default API baseline");
            }
            return;
        }
        if (DEBUG) {
            System.out.println("Checking if the default api baseline is set");
        }
        IApiProblem problem = ApiProblemFactory.newApiBaselineProblem(Path.EMPTY.toString(), new String[]{"apiMarkerID"}, new Object[]{new Integer(1)}, 7, 1);
        this.addProblem(problem);
    }

    private IJavaProject getJavaProject(IApiComponent component) {
        if (component instanceof ProjectComponent) {
            ProjectComponent pp = (ProjectComponent)component;
            return pp.getJavaProject();
        }
        return null;
    }

    private boolean addProblem(IApiProblem problem) {
        if (problem == null || this.isProblemFiltered(problem)) {
            return false;
        }
        return this.fProblems.add(problem);
    }

    private boolean isProblemFiltered(IApiProblem problem) {
        if (this.fJavaProject == null) {
            String key;
            boolean filtered;
            if (this.fFilterStore != null && (filtered = this.fFilterStore.isFiltered(problem))) {
                return true;
            }
            if (this.fPreferences != null && (key = ApiProblemFactory.getProblemSeverityId(problem)) != null) {
                String value = this.fPreferences.getProperty(key, null);
                return "Ignore".equals(value);
            }
            return false;
        }
        IProject project = this.fJavaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), project) == 0) {
            return true;
        }
        ApiBaselineManager manager = ApiBaselineManager.getManager();
        IApiBaseline baseline = manager.getWorkspaceBaseline();
        if (baseline == null) {
            return false;
        }
        IApiComponent component = baseline.getApiComponent(project);
        if (component != null) {
            try {
                IApiFilterStore filterStore = component.getFilterStore();
                if (filterStore != null) {
                    return filterStore.isFiltered(problem);
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private static class ReexportedBundleVersionInfo {
        String componentID;
        int kind;

        ReexportedBundleVersionInfo(String componentID, int kind) {
            this.componentID = componentID;
            this.kind = kind;
        }
    }
}

