/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodsSourcePositionComparator;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private String[] fCreatedImports;
    private final List fCreatedMethods = new ArrayList();
    private final boolean fImports;
    private final int fInsertPos;
    private final IMethodBinding[] fMethodsToImplement;
    private final boolean fSave;
    private boolean fDoCreateComments;
    private final ITypeBinding fType;
    private final CompilationUnit fASTRoot;

    public AddUnimplementedMethodsOperation(CompilationUnit astRoot, ITypeBinding type, IMethodBinding[] methodsToImplement, int insertPos, boolean imports, boolean apply, boolean save) {
        if (astRoot == null || !(astRoot.getJavaElement() instanceof ICompilationUnit)) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a ICompilationUnit");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        ASTNode node = astRoot.findDeclaringNode((IBinding)type);
        if (!(node instanceof AnonymousClassDeclaration) && !(node instanceof AbstractTypeDeclaration)) {
            throw new IllegalArgumentException("type has to map to a type declaration in the AST");
        }
        this.fType = type;
        this.fInsertPos = insertPos;
        this.fASTRoot = astRoot;
        this.fMethodsToImplement = methodsToImplement;
        this.fSave = save;
        this.fApply = apply;
        this.fImports = imports;
        this.fDoCreateComments = StubUtility.doAddComments(astRoot.getJavaElement().getJavaProject());
    }

    public void setCreateComments(boolean createComments) {
        this.fDoCreateComments = createComments;
    }

    public final String[] getCreatedImports() {
        if (this.fCreatedImports != null) {
            return this.fCreatedImports;
        }
        return new String[0];
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(keys);
        return keys;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            AbstractTypeDeclaration firstTypeDecl;
            monitor.beginTask("", 2);
            monitor.setTaskName(CodeGenerationMessages.AddUnimplementedMethodsOperation_description);
            this.fCreatedMethods.clear();
            ICompilationUnit cu = (ICompilationUnit)this.fASTRoot.getJavaElement();
            AST ast = this.fASTRoot.getAST();
            ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding currTypeBinding = this.fType;
            ListRewrite memberRewriter = null;
            ASTNode node = this.fASTRoot.findDeclaringNode((IBinding)currTypeBinding);
            if (node instanceof AnonymousClassDeclaration) {
                memberRewriter = astRewrite.getListRewrite(node, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else if (node instanceof AbstractTypeDeclaration) {
                ChildListPropertyDescriptor property = ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
                memberRewriter = astRewrite.getListRewrite(node, property);
            } else {
                throw new IllegalArgumentException();
            }
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
            settings.createComments = this.fDoCreateComments;
            ASTNode insertion = this.getNodeToInsertBefore(memberRewriter);
            IMethodBinding[] methodsToImplement = this.fMethodsToImplement;
            if (methodsToImplement == null) {
                methodsToImplement = StubUtility2.getUnimplementedMethods(currTypeBinding);
            }
            Arrays.sort(methodsToImplement, new MethodsSourcePositionComparator(this.fType));
            ContextSensitiveImportRewriteContext context = null;
            int insertionPosition = this.fInsertPos;
            if (insertionPosition == -1 && this.fASTRoot.types().size() > 0 && (insertionPosition = (firstTypeDecl = (AbstractTypeDeclaration)this.fASTRoot.types().get(0)).getStartPosition()) != -1) {
                context = new ContextSensitiveImportRewriteContext(this.fASTRoot, insertionPosition, importRewrite);
            }
            int i = 0;
            while (i < methodsToImplement.length) {
                IMethodBinding curr = methodsToImplement[i];
                MethodDeclaration stub = StubUtility2.createImplementationStub(cu, astRewrite, importRewrite, context, curr, currTypeBinding.getName(), settings, currTypeBinding.isInterface());
                if (stub != null) {
                    this.fCreatedMethods.add(curr.getKey());
                    if (insertion != null) {
                        memberRewriter.insertBefore((ASTNode)stub, insertion, null);
                    } else {
                        memberRewriter.insertLast((ASTNode)stub, null);
                    }
                }
                ++i;
            }
            MultiTextEdit edit = new MultiTextEdit();
            TextEdit importEdits = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fCreatedImports = importRewrite.getCreatedImports();
            if (this.fImports) {
                edit.addChild(importEdits);
            }
            edit.addChild(astRewrite.rewriteAST());
            if (this.fApply) {
                JavaModelUtil.applyEdit(cu, (TextEdit)edit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private ASTNode getNodeToInsertBefore(ListRewrite rewriter) {
        if (this.fInsertPos != -1) {
            List members = rewriter.getOriginalList();
            int i = 0;
            while (i < members.size()) {
                ASTNode curr = (ASTNode)members.get(i);
                if (curr.getStartPosition() >= this.fInsertPos) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }
}

