/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.security.BasicPermission;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;

public class PermissionChecker {
    private BundleContext context;
    private boolean checkPermissions = false;
    private ResolverImpl resolver;

    public PermissionChecker(BundleContext context, boolean checkPermissions, ResolverImpl resolver) {
        this.context = context;
        this.checkPermissions = checkPermissions && context != null;
        this.resolver = resolver;
    }

    public boolean checkPermission(VersionConstraint vc, BaseDescription bd) {
        if (!this.checkPermissions) {
            return true;
        }
        boolean success = false;
        BasicPermission producerPermission = null;
        BasicPermission consumerPermission = null;
        Bundle producer = null;
        Bundle consumer = null;
        int errorType = 0;
        if (vc instanceof ImportPackageSpecification) {
            errorType = 128;
            producer = this.context.getBundle(((ExportPackageDescription)bd).getExporter().getBundleId());
            producerPermission = new PackagePermission(bd.getName(), "exportonly");
            consumerPermission = producer != null ? new PackagePermission(vc.getName(), producer, "import") : new PackagePermission(vc.getName(), "import");
        } else {
            boolean requireBundle = vc instanceof BundleSpecification;
            errorType = requireBundle ? 512 : 4096;
            producerPermission = new BundlePermission(bd.getName(), requireBundle ? "provide" : "host");
            consumerPermission = new BundlePermission(vc.getName(), requireBundle ? "require" : "fragment");
            producer = this.context.getBundle(((BundleDescription)bd).getBundleId());
        }
        consumer = this.context.getBundle(vc.getBundle().getBundleId());
        if (producer != null && (producer.getState() & 1) == 0 && !(success = producer.hasPermission(producerPermission))) {
            switch (errorType) {
                case 128: {
                    errorType = 256;
                    break;
                }
                case 512: 
                case 4096: {
                    errorType = errorType == 512 ? 1024 : 2048;
                }
            }
            this.resolver.getState().addResolverError(vc.getBundle(), errorType, ((Object)producerPermission).toString(), vc);
        }
        if (success && consumer != null && (consumer.getState() & 1) == 0 && !(success = consumer.hasPermission(consumerPermission))) {
            this.resolver.getState().addResolverError(vc.getBundle(), errorType, ((Object)consumerPermission).toString(), vc);
        }
        return success;
    }

    boolean checkPackagePermission(ExportPackageDescription export) {
        if (!this.checkPermissions) {
            return true;
        }
        Bundle bundle = this.context.getBundle(export.getExporter().getBundleId());
        return bundle == null ? false : bundle.hasPermission(new PackagePermission(export.getName(), "exportonly"));
    }
}

