/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class Rpm
extends Task {
    private static final String PATH1 = "PATH=";
    private static final String PATH2 = "Path=";
    private static final String PATH3 = "path=";
    private static final int PATH_LEN = "PATH=".length();
    private String specFile;
    private File topDir;
    private String command = "-bb";
    private String rpmBuildCommand = null;
    private boolean cleanBuildDir = false;
    private boolean removeSpec = false;
    private boolean removeSource = false;
    private File output;
    private File error;
    private boolean failOnError = false;
    private boolean quiet = false;

    public void execute() throws BuildException {
        Commandline toExecute = new Commandline();
        toExecute.setExecutable(this.rpmBuildCommand == null ? this.guessRpmBuildCommand() : this.rpmBuildCommand);
        if (this.topDir != null) {
            toExecute.createArgument().setValue("--define");
            toExecute.createArgument().setValue("_topdir" + this.topDir);
        }
        toExecute.createArgument().setLine(this.command);
        if (this.cleanBuildDir) {
            toExecute.createArgument().setValue("--clean");
        }
        if (this.removeSpec) {
            toExecute.createArgument().setValue("--rmspec");
        }
        if (this.removeSource) {
            toExecute.createArgument().setValue("--rmsource");
        }
        toExecute.createArgument().setValue("SPECS/" + this.specFile);
        LogStreamHandler streamhandler = null;
        Object outputstream = null;
        Object errorstream = null;
        if (this.error == null && this.output == null) {
            streamhandler = !this.quiet ? new LogStreamHandler((Task)this, 2, 1) : new LogStreamHandler((Task)this, 4, 4);
        } else {
            BufferedOutputStream bos;
            if (this.output != null) {
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(this.output));
                    outputstream = new PrintStream(bos);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, this.getLocation());
                }
            } else {
                outputstream = !this.quiet ? new LogOutputStream((Task)this, 2) : new LogOutputStream((Task)this, 4);
            }
            if (this.error != null) {
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(this.error));
                    errorstream = new PrintStream(bos);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, this.getLocation());
                }
            } else {
                errorstream = !this.quiet ? new LogOutputStream((Task)this, 1) : new LogOutputStream((Task)this, 4);
            }
            streamhandler = new PumpStreamHandler((OutputStream)outputstream, (OutputStream)errorstream);
        }
        Execute exe = this.getExecute(toExecute, (ExecuteStreamHandler)streamhandler);
        try {
            this.log("Building the RPM based on the " + this.specFile + " file");
            int returncode = exe.execute();
            if (Execute.isFailure((int)returncode)) {
                String msg = "'" + toExecute.getExecutable() + "' failed with exit code " + returncode;
                if (this.failOnError) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            FileUtils.close((OutputStream)outputstream);
            FileUtils.close((OutputStream)errorstream);
        }
    }

    public void setTopDir(File td) {
        this.topDir = td;
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setSpecFile(String sf) {
        if (sf == null || sf.trim().length() == 0) {
            throw new BuildException("You must specify a spec file", this.getLocation());
        }
        this.specFile = sf;
    }

    public void setCleanBuildDir(boolean cbd) {
        this.cleanBuildDir = cbd;
    }

    public void setRemoveSpec(boolean rs) {
        this.removeSpec = rs;
    }

    public void setRemoveSource(boolean rs) {
        this.removeSource = rs;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setRpmBuildCommand(String c) {
        this.rpmBuildCommand = c;
    }

    public void setFailOnError(boolean value) {
        this.failOnError = value;
    }

    public void setQuiet(boolean value) {
        this.quiet = value;
    }

    protected String guessRpmBuildCommand() {
        Vector env = Execute.getProcEnvironment();
        String path = null;
        Enumeration e = env.elements();
        while (e.hasMoreElements()) {
            String var = (String)e.nextElement();
            if (!var.startsWith(PATH1) && !var.startsWith(PATH2) && !var.startsWith(PATH3)) continue;
            path = var.substring(PATH_LEN);
            break;
        }
        if (path != null) {
            Path p = new Path(this.getProject(), path);
            String[] pElements = p.list();
            for (int i = 0; i < pElements.length; ++i) {
                File f = new File(pElements[i], "rpmbuild" + (Os.isFamily((String)"dos") ? ".exe" : ""));
                if (!f.canRead()) continue;
                return f.getAbsolutePath();
            }
        }
        return "rpm";
    }

    protected Execute getExecute(Commandline toExecute, ExecuteStreamHandler streamhandler) {
        Execute exe = new Execute(streamhandler, null);
        exe.setAntRun(this.getProject());
        if (this.topDir == null) {
            this.topDir = this.getProject().getBaseDir();
        }
        exe.setWorkingDirectory(this.topDir);
        exe.setCommandline(toExecute.getCommandline());
        return exe;
    }
}

