/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.IncrementalApiBuilder;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ApiAnalysisBuilder
extends IncrementalProjectBuilder {
    static boolean DEBUG = Util.DEBUG;
    static final IPath SETTINGS_PATH = new Path(".settings");
    static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    static final IPath FILTER_PATH = SETTINGS_PATH.append(".api_filters");
    static final IProject[] NO_PROJECTS = new IProject[0];
    static final String SOURCE = "Api Tooling";
    private IProject currentproject = null;
    private IApiAnalyzer analyzer = null;
    HashMap output_locs = new HashMap();
    HashMap src_locs = new HashMap();
    private BuildState buildstate = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    void cleanupMarkers(IResource resource) {
        this.cleanUnusedFilterMarkers(resource);
        this.cleanupUsageMarkers(resource);
        this.cleanupCompatibilityMarkers(resource);
        this.cleanupUnsupportedTagMarkers(resource);
        this.cleanupFatalMarkers(resource);
    }

    void cleanupUnsupportedTagMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                if (DEBUG) {
                    System.out.println("cleaning unsupported tag problems");
                }
                resource.deleteMarkers("org.eclipse.pde.api.tools.unsupported_tags", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupCompatibilityMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.compatibility", false, 2);
                resource.deleteMarkers("org.eclipse.pde.api.tools.marker.sincetags", false, 2);
                if (resource.getType() == 4) {
                    resource.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 2);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_profile", true, 0);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_component_resolution", true, 0);
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupUsageMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.api_usage", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupFatalMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.fatal_problem", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanUnusedFilterMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.unused_filters", false, 2);
            }
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce.getStatus());
        }
    }

    /*
     * Loose catch block
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        block65: {
            IApiBaseline baseline;
            SubMonitor localMonitor;
            block64: {
                Throwable throwable2222;
                block66: {
                    this.currentproject = this.getProject();
                    if (this.shouldAbort(this.currentproject)) {
                        return NO_PROJECTS;
                    }
                    BuildStamps.incBuildStamp(this.currentproject);
                    if (DEBUG) {
                        System.out.println("\nApiAnalysis builder - Starting build of " + this.currentproject.getName() + " @ " + new Date(System.currentTimeMillis()));
                    }
                    localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_builder, (int)8);
                    IApiBaseline wbaseline = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline();
                    if (wbaseline == null) {
                        if (DEBUG) {
                            System.err.println("Could not retrieve a workspace baseline");
                        }
                        return NO_PROJECTS;
                    }
                    projects = this.getRequiredProjects(true);
                    baseline = ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline();
                    try {
                        switch (kind) {
                            case 6: {
                                if (DEBUG) {
                                    System.out.println("Performing full build as requested by user");
                                }
                                this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                break;
                            }
                            case 9: 
                            case 10: {
                                this.buildstate = BuildState.getLastBuiltState(this.currentproject);
                                if (this.buildstate == null) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                    break;
                                }
                                if (this.worthDoingFullBuild(projects)) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                    break;
                                }
                                IResourceDelta[] deltas = this.getDeltas(projects);
                                if (deltas.length < 1) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                    break;
                                }
                                IResourceDelta manifest = null;
                                IResourceDelta filters = null;
                                boolean filterbuild = false;
                                int i = 0;
                                while (i < deltas.length) {
                                    manifest = deltas[i].findMember(MANIFEST_PATH);
                                    if (manifest != null) break;
                                    filters = deltas[i].findMember(FILTER_PATH);
                                    if (filters != null) {
                                        switch (filters.getKind()) {
                                            case 1: 
                                            case 2: {
                                                filterbuild = true;
                                                break;
                                            }
                                            case 4: {
                                                boolean bl = filterbuild = (filters.getFlags() & 0x40000) > 0;
                                            }
                                        }
                                        if (filterbuild) break;
                                    }
                                    ++i;
                                }
                                if (manifest != null || filterbuild) {
                                    if (DEBUG) {
                                        System.out.println("Performing full build since MANIFEST.MF or .api_filters was modified");
                                    }
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                    break;
                                }
                                State state = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(this.currentproject, (IProgressMonitor)localMonitor.newChild(1));
                                if (state == null) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)localMonitor.newChild(1));
                                    break;
                                }
                                BuildState.setLastBuiltState(this.currentproject, null);
                                IncrementalApiBuilder builder = new IncrementalApiBuilder(this);
                                builder.build(baseline, wbaseline, deltas, state, this.buildstate, (IProgressMonitor)localMonitor.newChild(1));
                            }
                        }
                        Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                        break block64;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        if (DEBUG) {
                            System.out.println("Trapped OperationCanceledException");
                        }
                        try {
                            Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                            if (this.analyzer != null) {
                                this.analyzer.dispose();
                                this.analyzer = null;
                            }
                            if (projects.length < 1 && baseline != null) {
                                baseline.close();
                            }
                            Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                            if (this.buildstate != null) {
                                int i = 0;
                                int max = projects.length;
                                while (i < max) {
                                    IProject project = projects[i];
                                    if (Util.isApiProject(project)) {
                                        this.buildstate.addApiToolingDependentProject(project.getName());
                                    }
                                    ++i;
                                }
                                this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                this.buildstate = null;
                                Util.updateMonitor(monitor, 0);
                            }
                            if (localMonitor != null) {
                                localMonitor.done();
                            }
                            break block65;
                        }
                        catch (OperationCanceledException operationCanceledException2) {
                            if (DEBUG) {
                                System.out.println("Trapped OperationCanceledException");
                            }
                            break block65;
                        }
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status == null || status.getCode() != 123) {
                            throw e;
                        }
                        ApiPlugin.log(e);
                        try {
                            Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                            if (this.analyzer != null) {
                                this.analyzer.dispose();
                                this.analyzer = null;
                            }
                            if (projects.length < 1 && baseline != null) {
                                baseline.close();
                            }
                            Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                            if (this.buildstate != null) {
                                int i = 0;
                                int max = projects.length;
                                while (i < max) {
                                    IProject project = projects[i];
                                    if (Util.isApiProject(project)) {
                                        this.buildstate.addApiToolingDependentProject(project.getName());
                                    }
                                    ++i;
                                }
                                this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                this.buildstate = null;
                                Util.updateMonitor(monitor, 0);
                            }
                            if (localMonitor != null) {
                                localMonitor.done();
                            }
                            break block65;
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            if (DEBUG) {
                                System.out.println("Trapped OperationCanceledException");
                            }
                            break block65;
                        }
                        catch (Throwable throwable2222) {
                            try {
                                Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                                if (this.analyzer != null) {
                                    this.analyzer.dispose();
                                    this.analyzer = null;
                                }
                                if (projects.length < 1 && baseline != null) {
                                    baseline.close();
                                }
                                Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                                if (this.buildstate != null) {
                                    int i = 0;
                                    int max = projects.length;
                                    while (i < max) {
                                        IProject project = projects[i];
                                        if (Util.isApiProject(project)) {
                                            this.buildstate.addApiToolingDependentProject(project.getName());
                                        }
                                        ++i;
                                    }
                                    this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                    BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                    this.buildstate = null;
                                    Util.updateMonitor(monitor, 0);
                                }
                                if (localMonitor != null) {
                                    localMonitor.done();
                                }
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                if (!DEBUG) break block66;
                                System.out.println("Trapped OperationCanceledException");
                            }
                        }
                    }
                }
                throw throwable2222;
            }
            try {
                Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                if (this.analyzer != null) {
                    this.analyzer.dispose();
                    this.analyzer = null;
                }
                if (projects.length < 1 && baseline != null) {
                    baseline.close();
                }
                Util.updateMonitor((IProgressMonitor)localMonitor, 0);
                if (this.buildstate != null) {
                    int i = 0;
                    int max = projects.length;
                    while (i < max) {
                        IProject project = projects[i];
                        if (Util.isApiProject(project)) {
                            this.buildstate.addApiToolingDependentProject(project.getName());
                        }
                        ++i;
                    }
                    this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                    BuildState.saveBuiltState(this.currentproject, this.buildstate);
                    this.buildstate = null;
                    Util.updateMonitor(monitor, 0);
                }
                if (localMonitor != null) {
                    localMonitor.done();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!DEBUG) break block65;
                System.out.println("Trapped OperationCanceledException");
            }
        }
        if (DEBUG) {
            System.out.println("Finished build of " + this.currentproject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        return projects;
    }

    boolean shouldAbort(IProject project) throws CoreException {
        return !project.isAccessible() || !project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") || this.hasBeenBuilt(project) || this.hasFatalProblems(project);
    }

    boolean hasFatalProblems(IProject project) throws CoreException {
        IMarker[] problems = project.findMarkers("org.eclipse.jdt.core.problem", true, 0);
        if (problems.length > 0) {
            this.cleanupMarkers((IResource)project);
            IApiProblem problem = ApiProblemFactory.newFatalProblem(Path.EMPTY.toString(), new String[]{project.getName()}, 1);
            this.createMarkerForProblem(0x70000000, "org.eclipse.pde.api.tools.fatal_problem", problem);
            return true;
        }
        this.cleanupFatalMarkers((IResource)project);
        return false;
    }

    boolean worthDoingFullBuild(IProject[] projects) {
        Set apiToolingDependentProjects = this.buildstate.getApiToolingDependentProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject currentProject = projects[i];
            if (Util.isApiProject(currentProject)) {
                if (!apiToolingDependentProjects.contains(currentProject.getName())) {
                    return true;
                }
            } else if (apiToolingDependentProjects.contains(currentProject.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void buildAll(IApiBaseline baseline, IApiBaseline wbaseline, IProgressMonitor monitor) throws CoreException {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)4);
        try {
            BuildState.setLastBuiltState(this.currentproject, null);
            this.buildstate = new BuildState();
            localMonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_initializing_analyzer, (Object)this.currentproject.getName()));
            this.cleanupMarkers((IResource)this.currentproject);
            IPluginModelBase currentModel = this.getCurrentModel();
            if (currentModel != null) {
                localMonitor.subTask(BuilderMessages.building_workspace_profile);
                Util.updateMonitor((IProgressMonitor)localMonitor, 1);
                String id = currentModel.getBundleDescription().getSymbolicName();
                IApiComponent apiComponent = wbaseline.getApiComponent(id);
                if (apiComponent != null) {
                    this.getAnalyzer().analyzeComponent(this.buildstate, null, null, baseline, apiComponent, new BuildContext(), (IProgressMonitor)localMonitor.newChild(1));
                    Util.updateMonitor((IProgressMonitor)localMonitor, 1);
                    this.createMarkers();
                    Util.updateMonitor((IProgressMonitor)localMonitor, 1);
                }
            }
        }
        finally {
            if (localMonitor != null) {
                localMonitor.done();
            }
        }
    }

    protected void createMarkers() {
        try {
            IResource manifest = Util.getManifestFile(this.currentproject);
            if (manifest != null) {
                manifest.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 0);
            }
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.api_component_resolution", false, 0);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        IApiProblem[] problems = this.getAnalyzer().getProblems();
        String type = null;
        int i = 0;
        while (i < problems.length) {
            int category = problems[i].getCategory();
            type = this.getProblemTypeFromCategory(category, problems[i].getKind());
            if (type != null) {
                if (DEBUG) {
                    System.out.println("creating marker for: " + problems[i].toString());
                }
                this.createMarkerForProblem(category, type, problems[i]);
            }
            ++i;
        }
    }

    String getProblemTypeFromCategory(int category, int kind) {
        switch (category) {
            case 0x60000000: {
                return "org.eclipse.pde.api.tools.api_component_resolution";
            }
            case 0x50000000: {
                return "org.eclipse.pde.api.tools.api_profile";
            }
            case 0x10000000: {
                return "org.eclipse.pde.api.tools.compatibility";
            }
            case 0x40000000: {
                return "org.eclipse.pde.api.tools.marker.sincetags";
            }
            case 0x20000000: {
                if (kind == 7) {
                    return "org.eclipse.pde.api.tools.unsupported_tags";
                }
                if (kind == 10) {
                    return "org.eclipse.pde.api.tools.unused_filters";
                }
                return "org.eclipse.pde.api.tools.api_usage";
            }
            case 0x30000000: {
                return "org.eclipse.pde.api.tools.version_numbering";
            }
        }
        return null;
    }

    void createMarkerForProblem(int category, String type, IApiProblem problem) {
        IResource resource = this.resolveResource(problem);
        if (resource == null) {
            return;
        }
        try {
            String typeName;
            IMarker marker = resource.createMarker(type);
            int line = problem.getLineNumber();
            switch (category) {
                case 0x30000000: 
                case 0x50000000: 
                case 0x60000000: {
                    break;
                }
                default: {
                    ++line;
                }
            }
            marker.setAttributes(new String[]{"message", "severity", "lineNumber", "charStart", "charEnd", "sourceId", "problemid"}, new Object[]{problem.getMessage(), new Integer(ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), this.currentproject)), new Integer(line), new Integer(problem.getCharStart()), new Integer(problem.getCharEnd()), SOURCE, new Integer(problem.getId())});
            String[] args = problem.getMessageArguments();
            if (args.length > 0) {
                marker.setAttribute("messagearguments", (Object)this.createArgAttribute(args));
            }
            if ((typeName = problem.getTypeName()) != null) {
                marker.setAttribute("problemTypeName", (Object)typeName);
            }
            if (problem.getExtraMarkerAttributeIds().length > 0) {
                marker.setAttributes(problem.getExtraMarkerAttributeIds(), problem.getExtraMarkerAttributeValues());
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    IResource resolveResource(IApiProblem problem) {
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return null;
        }
        IResource resource = this.currentproject.findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            IJavaProject jp = JavaCore.create((IProject)this.currentproject);
            try {
                IType type = jp.findType(problem.getTypeName());
                if (type != null) {
                    return type.getResource();
                }
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }
        if (!resource.isAccessible()) {
            return null;
        }
        return resource;
    }

    String createArgAttribute(String[] args) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            buff.append(args[i]);
            if (i < args.length - 1) {
                buff.append("#");
            }
            ++i;
        }
        return buff.toString();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentproject = this.getProject();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.CleaningAPIDescription, (Object[])new String[]{this.currentproject.getName()}), (int)2);
        try {
            this.cleanupUsageMarkers((IResource)this.currentproject);
            this.cleanupCompatibilityMarkers((IResource)this.currentproject);
            this.cleanupUnsupportedTagMarkers((IResource)this.currentproject);
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.unused_filters", false, 2);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            this.cleanupApiDescription(this.currentproject);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
        }
        finally {
            BuildState.setLastBuiltState(this.currentproject, null);
            localmonitor.done();
        }
    }

    void cleanupApiDescription(IProject project) {
        if (project != null && project.exists()) {
            ApiDescriptionManager.getManager().clean(JavaCore.create((IProject)project), true, false);
        }
    }

    IPluginModelBase getCurrentModel() {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        IPath location = this.currentproject.getLocation();
        IPluginModelBase currentModel = null;
        BundleDescription desc = null;
        int i = 0;
        int max = workspaceModels.length;
        while (i < max) {
            desc = workspaceModels[i].getBundleDescription();
            if (desc != null) {
                Path path = new Path(desc.getLocation());
                if (path.equals((Object)location)) {
                    currentModel = workspaceModels[i];
                    break;
                }
            } else if (DEBUG) {
                System.out.println("Tried to look up bundle description for: " + workspaceModels[i].toString());
            }
            ++i;
        }
        return currentModel;
    }

    IResourceDelta[] getDeltas(IProject[] projects) {
        if (DEBUG) {
            System.out.println("Searching for deltas for build of project: " + this.currentproject.getName());
        }
        ArrayList<IResourceDelta> deltas = new ArrayList<IResourceDelta>();
        IResourceDelta delta = this.getDelta(this.currentproject);
        if (delta != null) {
            if (DEBUG) {
                System.out.println("Found a delta: " + delta);
            }
            deltas.add(delta);
        }
        int i = 0;
        while (i < projects.length) {
            delta = this.getDelta(projects[i]);
            if (delta != null) {
                if (DEBUG) {
                    System.out.println("Found a delta: " + delta);
                }
                deltas.add(delta);
            }
            ++i;
        }
        return deltas.toArray(new IResourceDelta[deltas.size()]);
    }

    protected synchronized IApiAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new BaseApiAnalyzer();
        }
        return this.analyzer;
    }

    IProject[] getRequiredProjects(boolean includebinaries) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (this.currentproject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.currentproject);
            HashSet<IPath> blocations = new HashSet<IPath>();
            blocations.add(javaProject.getOutputLocation());
            this.output_locs.put(this.currentproject, blocations);
            HashSet<IPath> slocations = new HashSet<IPath>();
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isArchive()) {
                    slocations.add(roots[i].getPath());
                }
                ++i;
            }
            this.src_locs.put(this.currentproject, slocations);
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i2 = 0;
            int l = entries.length;
            while (i2 < l) {
                IClasspathEntry entry = entries[i2];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!this.isOptional(entry) || p.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includebinaries || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                        break;
                    }
                    case 3: {
                        IPath entrypath = entry.getOutputLocation();
                        if (entrypath == null) break;
                        blocations.add(entrypath);
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                    javaProject = JavaCore.create((IProject)p);
                    HashSet<IPath> bins = new HashSet<IPath>();
                    HashSet<IPath> srcs = new HashSet<IPath>();
                    if (javaProject.exists()) {
                        bins.add(javaProject.getOutputLocation());
                        IClasspathEntry[] source = javaProject.getRawClasspath();
                        IPath entrypath = null;
                        int j = 0;
                        while (j < source.length) {
                            if (source[j].getEntryKind() == 3) {
                                srcs.add(source[j].getPath());
                                entrypath = source[j].getOutputLocation();
                                if (entrypath != null) {
                                    bins.add(entrypath);
                                }
                            }
                            ++j;
                        }
                        this.output_locs.put(p, bins);
                        this.src_locs.put(p, srcs);
                    }
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    HashSet getProjectOutputPaths(IProject project) {
        return (HashSet)this.output_locs.get(project);
    }

    boolean isOptional(IClasspathEntry entry) {
        IClasspathAttribute[] attribs = entry.getExtraAttributes();
        int i = 0;
        int length = attribs.length;
        while (i < length) {
            IClasspathAttribute attribute = attribs[i];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_builder_for_project, (Object)this.currentproject.getName());
    }
}

