/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.eclipse.ecf.internal.ssl.ECFCertificateException;
import org.eclipse.ecf.internal.ssl.ECFSSLSocketFactory;
import org.eclipse.osgi.service.security.TrustEngine;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFTrustManager
implements X509TrustManager,
BundleActivator {
    private static volatile BundleContext context;
    private volatile ServiceTracker trustEngineTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.verify(certs, authType);
        TrustEngine[] engines = this.getTrustEngines();
        Certificate foundCert = null;
        int i = 0;
        while (i < engines.length) {
            try {
                foundCert = engines[i].findTrustAnchor((Certificate[])certs);
                if (foundCert != null) {
                    return;
                }
            }
            catch (IOException e) {
                ECFCertificateException ce = new ECFCertificateException("Error occurs when finding trust anchor in the cert chain", certs, authType);
                ce.initCause(ce);
                throw ce;
            }
            ++i;
        }
        if (foundCert == null) {
            throw new ECFCertificateException("Valid cert chain, but no trust certificate found!", certs, authType);
        }
    }

    private void verify(X509Certificate[] certs, String authType) throws CertificateException {
        int len = certs.length;
        int i = 0;
        while (i < len) {
            X509Certificate currentX509Cert = certs[i];
            try {
                if (i == len - 1) {
                    if (currentX509Cert.getSubjectDN().equals(currentX509Cert.getIssuerDN())) {
                        currentX509Cert.verify(currentX509Cert.getPublicKey());
                    }
                } else {
                    X509Certificate nextX509Cert = certs[i + 1];
                    currentX509Cert.verify(nextX509Cert.getPublicKey());
                }
            }
            catch (Exception e) {
                ECFCertificateException ce = new ECFCertificateException("Certificate chain is not valid", certs, authType);
                ce.initCause(e);
                throw ce;
            }
            ++i;
        }
    }

    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    public void start(BundleContext context1) throws Exception {
        context = context1;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.net.ssl.SSLSocketFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context1.registerService(clazz.getName(), (Object)new ECFSSLSocketFactory(), null);
    }

    public void stop(BundleContext context1) throws Exception {
        if (this.trustEngineTracker != null) {
            this.trustEngineTracker.close();
            this.trustEngineTracker = null;
        }
        context = null;
    }

    private TrustEngine[] getTrustEngines() {
        if (this.trustEngineTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.trustEngineTracker = new ServiceTracker(context, clazz.getName(), null);
            this.trustEngineTracker.open();
        }
        Object[] objs = this.trustEngineTracker.getServices();
        TrustEngine[] result = new TrustEngine[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }
}

