/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class ConstantScoreQuery
extends Query {
    protected final Filter filter;

    public ConstantScoreQuery(Filter filter) {
        this.filter = filter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    protected Weight createWeight(Searcher searcher) {
        return new ConstantWeight(searcher);
    }

    public String toString(String field) {
        return "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantScoreQuery)) {
            return false;
        }
        ConstantScoreQuery other = (ConstantScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode() + Float.floatToIntBits(this.getBoost());
    }

    protected class ConstantScorer
    extends Scorer {
        final BitSet bits;
        final float theScore;
        int doc;

        public ConstantScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.theScore = w.getValue();
            this.bits = ConstantScoreQuery.this.filter.bits(reader);
        }

        public boolean next() throws IOException {
            this.doc = this.bits.nextSetBit(this.doc + 1);
            return this.doc >= 0;
        }

        public int doc() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public boolean skipTo(int target) throws IOException {
            this.doc = this.bits.nextSetBit(target);
            return this.doc >= 0;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class ConstantWeight
    implements Weight {
        private Searcher searcher;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ConstantScoreQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = ConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new ConstantScorer(ConstantScoreQuery.this.getSimilarity(this.searcher), reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ConstantScorer cs = (ConstantScorer)this.scorer(reader);
            boolean exists = cs.bits.get(doc);
            Explanation result = new Explanation();
            if (exists) {
                result.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + "), product of:");
                result.setValue(this.queryWeight);
                result.addDetail(new Explanation(ConstantScoreQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription("ConstantScoreQuery(" + ConstantScoreQuery.this.filter + ") doesn't match id " + doc);
                result.setValue(0.0f);
            }
            return result;
        }
    }
}

