/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.RootElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryElement
extends RootElement
implements IRepositoryElement<IInstallableUnit> {
    URI location;
    boolean isEnabled;
    String name;

    public MetadataRepositoryElement(Object parent, URI location, boolean isEnabled) {
        this(parent, null, ProvisioningUI.getDefaultUI(), location, isEnabled);
    }

    public MetadataRepositoryElement(IUViewQueryContext queryContext, ProvisioningUI ui, URI location, boolean isEnabled) {
        this(null, queryContext, ui, location, isEnabled);
    }

    private MetadataRepositoryElement(Object parent, IUViewQueryContext queryContext, ProvisioningUI ui, URI location, boolean isEnabled) {
        super(parent, queryContext, ui);
        this.location = location;
        this.isEnabled = isEnabled;
    }

    @Override
    public Object getAdapter(Class adapter) {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("org.eclipse.equinox.p2.repository.metadata.IMetadataRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (adapter == clazz2) {
            return this.getQueryable();
        }
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.repository.IRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (adapter == clazz) {
            return this.getQueryable();
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            this.getMetadataRepository((IProgressMonitor)sub.newChild(100));
            return super.fetchChildren(o, (IProgressMonitor)sub.newChild(100));
        }
        catch (ProvisionException e) {
            this.getProvisioningUI().getRepositoryTracker().reportLoadFailure(this.location, e);
            return new Object[]{new EmptyElementExplanation(this, 4, e.getLocalizedMessage(), "")};
        }
    }

    @Override
    protected String getImageId(Object obj) {
        return "obj/metadata_repo_obj.gif";
    }

    @Override
    protected int getDefaultQueryType() {
        return 4;
    }

    @Override
    public String getLabel(Object o) {
        String n = this.getName();
        if (n != null && n.length() > 0) {
            return n;
        }
        return URIUtil.toUnencodedString((URI)this.getLocation());
    }

    @Override
    public IQueryable<?> getQueryable() {
        if (this.queryable == null) {
            this.queryable = this.getRepository((IProgressMonitor)new NullProgressMonitor());
        }
        return this.queryable;
    }

    public IMetadataRepository getRepository(IProgressMonitor monitor) {
        try {
            return this.getMetadataRepository(monitor);
        }
        catch (ProvisionException e) {
            this.getProvisioningUI().getRepositoryTracker().reportLoadFailure(this.location, e);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return null;
    }

    private IMetadataRepository getMetadataRepository(IProgressMonitor monitor) throws ProvisionException {
        if (this.queryable == null) {
            this.queryable = this.getProvisioningUI().loadMetadataRepository(this.location, false, monitor);
        }
        return (IMetadataRepository)this.queryable;
    }

    @Override
    public boolean knowsQueryable() {
        return this.location != null;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getMetadataRepositoryManager().getRepositoryProperty(this.location, "p2.nickname");
            if (this.name == null) {
                this.name = this.getMetadataRepositoryManager().getRepositoryProperty(this.location, "name");
            }
            if (this.name == null) {
                this.name = "";
            }
        }
        return this.name;
    }

    public void setNickname(String name) {
        this.name = name;
    }

    public void setLocation(URI location) {
        this.location = location;
        this.setQueryable(null);
    }

    @Override
    public String getDescription() {
        if (this.getProvisioningUI().getRepositoryTracker().hasNotFoundStatusBeenReported(this.location)) {
            return ProvUIMessages.RepositoryElement_NotFound;
        }
        String description = this.getMetadataRepositoryManager().getRepositoryProperty(this.location, "description");
        if (description == null) {
            return "";
        }
        return description;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean hasQueryable() {
        if (this.queryable != null) {
            return true;
        }
        if (this.location == null) {
            return false;
        }
        IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
        if (manager == null || !(manager instanceof MetadataRepositoryManager)) {
            return false;
        }
        IMetadataRepository repo = ((MetadataRepositoryManager)manager).getRepository(this.location);
        if (repo == null) {
            return false;
        }
        this.queryable = repo;
        return true;
    }

    @Override
    public Policy getPolicy() {
        Object parent = this.getParent(this);
        if (parent == null) {
            return super.getPolicy();
        }
        if (parent instanceof QueriedElement) {
            return ((QueriedElement)parent).getPolicy();
        }
        return ProvisioningUI.getDefaultUI().getPolicy();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Metadata Repository Element - ");
        result.append(URIUtil.toUnencodedString((URI)this.location));
        if (this.hasQueryable()) {
            result.append(" (loaded)");
        } else {
            result.append(" (not loaded)");
        }
        return result.toString();
    }

    IMetadataRepositoryManager getMetadataRepositoryManager() {
        return ProvUI.getMetadataRepositoryManager(this.getProvisioningUI().getSession());
    }
}

