/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FilterDropDownMenuCreator
implements IMenuCreator {
    private Menu fCreatedMenu = null;

    private IPreferenceStore getDebugPrefStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.fCreatedMenu = null;
    }

    public Menu getMenu(Control parent) {
        if (this.fCreatedMenu != null) {
            this.fCreatedMenu.dispose();
        }
        this.fCreatedMenu = new Menu(parent);
        new FilterAction(this.fCreatedMenu, this.getDebugPrefStore(), LaunchConfigurationsMessages.FilterDropDownMenuCreator_0, "org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED");
        new FilterAction(this.fCreatedMenu, this.getDebugPrefStore(), LaunchConfigurationsMessages.FilterDropDownMenuCreator_1, "org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED");
        new FilterAction(this.fCreatedMenu, this.getDebugPrefStore(), LaunchConfigurationsMessages.FilterDropDownMenuCreator_2, "org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES");
        new FilterAction(this.fCreatedMenu, this.getDebugPrefStore(), LaunchConfigurationsMessages.FilterDropDownMenuCreator_4, "org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS");
        new MenuItem(this.fCreatedMenu, 2);
        Action action = new Action(LaunchConfigurationsMessages.FilterDropDownMenuCreator_3){

            public void run() {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.LaunchConfigurations");
            }
        };
        new ActionContributionItem((IAction)action).fill(this.fCreatedMenu, -1);
        return this.fCreatedMenu;
    }

    public Menu getMenu(Menu parent) {
        return this.fCreatedMenu;
    }

    class FilterAction
    extends Action {
        private IPreferenceStore fStore = null;
        private String fKey = null;

        public FilterAction(Menu menu, IPreferenceStore store, String name, String key) {
            super(name, 2);
            this.fStore = store;
            this.fKey = key;
            this.setChecked(this.fStore.getBoolean(this.fKey));
            this.fillIntoMenu(menu, (IAction)this);
        }

        public FilterAction(Menu menu, String name, IMenuCreator creator) {
            super(name, 4);
            this.setMenuCreator(creator);
            this.fillIntoMenu(menu, (IAction)this);
        }

        private void fillIntoMenu(Menu menu, IAction action) {
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
        }

        public void run() {
            if (this.fStore != null) {
                this.fStore.setValue(this.fKey, this.isChecked());
            }
        }
    }
}

