/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";

    private Bindings() {
    }

    public static boolean equals(IBinding b1, IBinding b2) {
        return b1.isEqualTo(b2);
    }

    public static boolean equalDeclarations(IBinding b1, IBinding b2) {
        if (b1.getKind() != b2.getKind()) {
            return false;
        }
        return Bindings.getDeclaration(b1).isEqualTo(Bindings.getDeclaration(b2));
    }

    public static boolean equals(IBinding[] b1, IBinding[] b2) {
        Assert.isNotNull((Object)b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (!Bindings.equals(b1[i], b2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(IBinding binding) {
        Assert.isNotNull((Object)binding);
        String key = binding.getKey();
        if (key == null) {
            return binding.hashCode();
        }
        return key.hashCode();
    }

    public static String asString(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            return Bindings.asString((IMethodBinding)binding);
        }
        if (binding instanceof ITypeBinding) {
            return ((ITypeBinding)binding).getQualifiedName();
        }
        if (binding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)binding);
        }
        return binding.toString();
    }

    private static String asString(IVariableBinding variableBinding) {
        if (!variableBinding.isField()) {
            return variableBinding.toString();
        }
        if (variableBinding.getDeclaringClass() == null) {
            Assert.isTrue((boolean)variableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(variableBinding.getDeclaringClass().getName());
        result.append(':');
        result.append(variableBinding.getName());
        return result.toString();
    }

    private static String asString(IMethodBinding method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getName());
        result.append(':');
        result.append(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append((String)result.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding type) {
        String name = type.getQualifiedName();
        int index = name.indexOf(60);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String getImportName(IBinding binding) {
        ITypeBinding declaring = null;
        switch (binding.getKind()) {
            case 2: {
                return Bindings.getRawQualifiedName((ITypeBinding)binding);
            }
            case 1: {
                return String.valueOf(binding.getName()) + ".*";
            }
            case 4: {
                declaring = ((IMethodBinding)binding).getDeclaringClass();
                break;
            }
            case 3: {
                declaring = ((IVariableBinding)binding).getDeclaringClass();
                if (declaring != null) break;
                return binding.getName();
            }
            default: {
                return binding.getName();
            }
        }
        return JavaModelUtil.concatenateName(Bindings.getRawQualifiedName(declaring), binding.getName());
    }

    private static void createName(ITypeBinding type, boolean includePackage, List list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String[] getNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        return result.toArray(new String[result.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, true, result);
        return result.toArray(new String[result.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getDeclaringClass();
        while (parent != null) {
            type = parent;
            parent = type.getDeclaringClass();
        }
        return type;
    }

    public static boolean isRuntimeException(ITypeBinding thrownException) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(thrownException, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding type, String fieldName) {
        if (type.isPrimitive()) {
            return null;
        }
        IVariableBinding[] fields = type.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            IVariableBinding field = fields[i];
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding type, String fieldName) {
        IVariableBinding field = Bindings.findFieldInType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (field = Bindings.findFieldInHierarchy(superClass, fieldName)) != null) {
            return field;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            field = Bindings.findFieldInHierarchy(interfaces[i], fieldName);
            if (field != null) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding type, String methodName, String[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding type, String methodName, String[] parameters) {
        IMethodBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findMethodInHierarchy(interfaces[i], methodName, parameters);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInType(ITypeBinding type, IMethodBinding method) {
        IMethodBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Bindings.isSubsignature(method, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding type, IMethodBinding binding) {
        IMethodBinding method = Bindings.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findOverriddenMethodInHierarchy(superClass, binding)) != null) {
            return method;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            method = Bindings.findOverriddenMethodInHierarchy(interfaces[i], binding);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethod(IMethodBinding overriding, boolean testVisibility) {
        IMethodBinding res;
        int modifiers = overriding.getModifiers();
        if (Modifier.isPrivate((int)modifiers) || Modifier.isStatic((int)modifiers) || overriding.isConstructor()) {
            return null;
        }
        ITypeBinding type = overriding.getDeclaringClass();
        if (!(type.getSuperclass() == null || (res = Bindings.findOverriddenMethodInHierarchy(type.getSuperclass(), overriding)) == null || Modifier.isPrivate((int)res.getModifiers()) || testVisibility && !Bindings.isVisibleInHierarchy(res, overriding.getDeclaringClass().getPackage()))) {
            return res;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            IMethodBinding res2 = Bindings.findOverriddenMethodInHierarchy(interfaces[i], overriding);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        ITypeBinding declaringType = member.getDeclaringClass();
        if (Modifier.isPublic((int)otherflags) || Modifier.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)otherflags)) {
            return false;
        }
        return declaringType != null && pack == declaringType.getPackage();
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding type) {
        HashSet result = new HashSet();
        Bindings.collectSuperTypes(type, result);
        result.remove(type);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private static void collectSuperTypes(ITypeBinding curr, Set collection) {
        if (collection.add(curr)) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                Bindings.collectSuperTypes(interfaces[i], collection);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                Bindings.collectSuperTypes(superClass, collection);
            }
        }
    }

    public static boolean visitHierarchy(ITypeBinding type, TypeBindingVisitor visitor) {
        boolean result = Bindings.visitSuperclasses(type, visitor);
        if (result) {
            result = Bindings.visitInterfaces(type, visitor);
        }
        return result;
    }

    public static boolean visitInterfaces(ITypeBinding type, TypeBindingVisitor visitor) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!visitor.visit(interfaces[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean visitSuperclasses(ITypeBinding type, TypeBindingVisitor visitor) {
        while ((type = type.getSuperclass()) != null) {
            if (visitor.visit(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, ITypeBinding[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!Bindings.equals((IBinding)methodParameters[i].getErasure(), (IBinding)parameters[i].getErasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSubsignature(IMethodBinding overriding, IMethodBinding overridden) {
        ITypeBinding[] m2TypeParams;
        ITypeBinding[] m2Params;
        if (!overriding.getName().equals(overridden.getName())) {
            return false;
        }
        ITypeBinding[] m1Params = overriding.getParameterTypes();
        if (m1Params.length != (m2Params = overridden.getParameterTypes()).length) {
            return false;
        }
        ITypeBinding[] m1TypeParams = overriding.getTypeParameters();
        if (m1TypeParams.length != (m2TypeParams = overridden.getTypeParameters()).length && m1TypeParams.length != 0) {
            return false;
        }
        if (m2TypeParams.length != 0) {
            int i = 0;
            while (i < m1TypeParams.length) {
                Set m2Bounds;
                Set m1Bounds = Bindings.getTypeBoundsForSubsignature(m1TypeParams[i]);
                if (!m1Bounds.equals(m2Bounds = Bindings.getTypeBoundsForSubsignature(m2TypeParams[i]))) {
                    return false;
                }
                ++i;
            }
            if (Bindings.equals((IBinding[])m2Params, (IBinding[])m1Params)) {
                return true;
            }
            i = 0;
            while (i < m1Params.length) {
                ITypeBinding m1Param = m1Params[i];
                if (Bindings.containsTypeVariables(m1Param)) {
                    m1Param = m1Param.getErasure();
                } else if (m1Param.isRawType()) {
                    m1Param = m1Param.getTypeDeclaration();
                }
                if (!Bindings.equals((IBinding)m1Param, (IBinding)m2Params[i].getErasure())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (Bindings.equals((IBinding[])m1Params, (IBinding[])m2Params)) {
            return true;
        }
        int i = 0;
        while (i < m1Params.length) {
            ITypeBinding m1Param = m1Params[i];
            if (m1Param.isRawType()) {
                m1Param = m1Param.getTypeDeclaration();
            }
            if (!Bindings.equals((IBinding)m1Param, (IBinding)m2Params[i].getErasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean containsTypeVariables(ITypeBinding type) {
        if (type.isTypeVariable()) {
            return true;
        }
        if (type.isArray()) {
            return Bindings.containsTypeVariables(type.getElementType());
        }
        if (type.isCapture()) {
            return Bindings.containsTypeVariables(type.getWildcard());
        }
        if (type.isParameterizedType()) {
            return Bindings.containsTypeVariables(type.getTypeArguments());
        }
        if (type.isTypeVariable()) {
            return Bindings.containsTypeVariables(type.getTypeBounds());
        }
        if (type.isWildcardType() && type.getBound() != null) {
            return Bindings.containsTypeVariables(type.getBound());
        }
        return false;
    }

    private static boolean containsTypeVariables(ITypeBinding[] types) {
        int i = 0;
        while (i < types.length) {
            if (Bindings.containsTypeVariables(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Set getTypeBoundsForSubsignature(ITypeBinding typeParameter) {
        ITypeBinding[] typeBounds = typeParameter.getTypeBounds();
        int count = typeBounds.length;
        if (count == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>(typeBounds.length);
        int i = 0;
        while (i < typeBounds.length) {
            ITypeBinding bound = typeBounds[i];
            if (!"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                if (Bindings.containsTypeVariables(bound)) {
                    result.add(bound.getErasure());
                } else if (bound.isRawType()) {
                    result.add(bound.getTypeDeclaration());
                } else {
                    result.add(bound);
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isEqualMethod(IMethodBinding method, String methodName, String[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            String second;
            String first = parameters[i];
            int index = first.indexOf(60);
            if (index > 0) {
                first = first.substring(0, index);
            }
            if ((index = (second = methodParameters[i].getErasure().getQualifiedName()).indexOf(60)) > 0) {
                second = second.substring(0, index);
            }
            if (!first.equals(second)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        ITypeBinding[] superInterfaces = hierarchyType.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            ITypeBinding res2 = Bindings.findTypeInHierarchy(superInterfaces[i], fullyQualifiedTypeName);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding getAssignedVariable(Assignment assignment) {
        Expression leftHand = assignment.getLeftHandSide();
        switch (leftHand.getNodeType()) {
            case 42: {
                return (IVariableBinding)((SimpleName)leftHand).resolveBinding();
            }
            case 40: {
                return (IVariableBinding)((QualifiedName)leftHand).getName().resolveBinding();
            }
            case 22: {
                return ((FieldAccess)leftHand).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)leftHand).resolveFieldBinding();
            }
        }
        return null;
    }

    public static boolean isSuperType(ITypeBinding possibleSuperType, ITypeBinding type) {
        if (type.isArray() || type.isPrimitive()) {
            return false;
        }
        if (Bindings.equals((IBinding)type, (IBinding)possibleSuperType)) {
            return true;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && Bindings.isSuperType(possibleSuperType, superClass)) {
            return true;
        }
        if (possibleSuperType.isInterface()) {
            ITypeBinding[] superInterfaces = type.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                if (Bindings.isSuperType(possibleSuperType, superInterfaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static ICompilationUnit findCompilationUnit(ITypeBinding typeBinding, IJavaProject project) throws JavaModelException {
        IJavaElement type = typeBinding.getJavaElement();
        if (type instanceof IType) {
            return ((IType)type).getCompilationUnit();
        }
        return null;
    }

    public static IMethod findMethod(IMethodBinding method, IType type) throws JavaModelException {
        method = method.getMethodDeclaration();
        IMethod[] candidates = type.getMethods();
        int i = 0;
        while (i < candidates.length) {
            IMethod candidate = candidates[i];
            if (candidate.getElementName().equals(method.getName()) && Bindings.sameParameters(method, candidate)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private static boolean sameParameters(IMethodBinding method, IMethod candidate) throws JavaModelException {
        String[] candidateParameters;
        ITypeBinding[] methodParamters = method.getParameterTypes();
        if (methodParamters.length != (candidateParameters = candidate.getParameterTypes()).length) {
            return false;
        }
        IType scope = candidate.getDeclaringType();
        int i = 0;
        while (i < methodParamters.length) {
            ITypeBinding methodParameter = methodParamters[i];
            String candidateParameter = candidateParameters[i];
            if (!Bindings.sameParameter(methodParameter, candidateParameter, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding type, String candidate, IType scope) throws JavaModelException {
        if (type.getDimensions() != Signature.getArrayCount((String)candidate)) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (Signature.getTypeSignatureKind((String)(candidate = Signature.getElementType((String)candidate))) == 2 != type.isPrimitive()) {
            return false;
        }
        if (type.isPrimitive() || type.isTypeVariable()) {
            return type.getName().equals(Signature.toString((String)candidate));
        }
        candidate = Signature.getTypeErasure((String)candidate);
        type = type.getErasure();
        if (candidate.charAt(Signature.getArrayCount((String)candidate)) == 'L') {
            return Signature.toString((String)candidate).equals(Bindings.getFullyQualifiedName(type));
        }
        String[][] qualifiedCandidates = scope.resolveType(Signature.toString((String)candidate));
        if (qualifiedCandidates == null || qualifiedCandidates.length == 0) {
            return false;
        }
        String packageName = type.getPackage().isUnnamed() ? "" : type.getPackage().getName();
        String typeName = Bindings.getTypeQualifiedName(type);
        int i = 0;
        while (i < qualifiedCandidates.length) {
            String[] qualifiedCandidate = qualifiedCandidates[i];
            if (qualifiedCandidate[0].equals(packageName) && qualifiedCandidate[1].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !Bindings.isVoidType(binding)) {
            if (binding.isAnonymous()) {
                ITypeBinding[] baseBindings = binding.getInterfaces();
                if (baseBindings.length > 0) {
                    return baseBindings[0];
                }
                return binding.getSuperclass();
            }
            if (binding.isCapture()) {
                return binding.getWildcard();
            }
            return binding;
        }
        return null;
    }

    public static boolean isVoidType(ITypeBinding binding) {
        return "void".equals(binding.getName());
    }

    public static ITypeBinding normalizeForDeclarationUse(ITypeBinding binding, AST ast) {
        if (binding.isNullType()) {
            return ast.resolveWellKnownType("java.lang.Object");
        }
        if (binding.isPrimitive()) {
            return binding;
        }
        if ((binding = Bindings.normalizeTypeBinding(binding)) == null || !binding.isWildcardType()) {
            return binding;
        }
        if (binding.isUpperbound()) {
            return binding.getBound();
        }
        return ast.resolveWellKnownType("java.lang.Object");
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static ITypeBinding getBindingOfParentTypeContext(ASTNode node) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)node;
                if (lastLocation == decl.getBodyDeclarationsProperty()) {
                    return decl.resolveBinding();
                }
                if (decl instanceof EnumDeclaration && lastLocation == EnumDeclaration.ENUM_CONSTANTS_PROPERTY) {
                    return decl.resolveBinding();
                }
            } else if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return null;
    }

    public static String getRawName(ITypeBinding binding) {
        int idx;
        String name = binding.getName();
        if ((binding.isParameterizedType() || binding.isGenericType()) && (idx = name.indexOf(60)) != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public static String getRawQualifiedName(ITypeBinding binding) {
        if (binding.isAnonymous() || binding.isLocal()) {
            return "";
        }
        if (binding.isPrimitive() || binding.isNullType() || binding.isTypeVariable()) {
            return binding.getName();
        }
        if (binding.isArray()) {
            String elementTypeQualifiedName = Bindings.getRawQualifiedName(binding.getElementType());
            if (elementTypeQualifiedName.length() != 0) {
                StringBuffer stringBuffer = new StringBuffer(elementTypeQualifiedName);
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            return "";
        }
        if (binding.isMember()) {
            String outerName = Bindings.getRawQualifiedName(binding.getDeclaringClass());
            if (outerName.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(outerName);
                buffer.append('.');
                buffer.append(Bindings.getRawName(binding));
                return buffer.toString();
            }
            return "";
        }
        if (binding.isTopLevel()) {
            IPackageBinding packageBinding = binding.getPackage();
            StringBuffer buffer = new StringBuffer();
            if (packageBinding != null && packageBinding.getName().length() > 0) {
                buffer.append(packageBinding.getName()).append('.');
            }
            buffer.append(Bindings.getRawName(binding));
            return buffer.toString();
        }
        return "";
    }

    public static boolean isDeclarationBinding(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration() == binding;
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration() == binding;
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration() == binding;
            }
        }
        return true;
    }

    public static IBinding getDeclaration(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
        }
        return binding;
    }

    public static boolean containsSignatureEquivalentConstructor(IMethodBinding[] candidates, IMethodBinding overridable) {
        int index = 0;
        while (index < candidates.length) {
            if (Bindings.isSignatureEquivalentConstructor(candidates[index], overridable)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static boolean isSignatureEquivalentConstructor(IMethodBinding overridden, IMethodBinding overridable) {
        if (!overridden.isConstructor() || !overridable.isConstructor()) {
            return false;
        }
        if (overridden.isDefaultConstructor()) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    public static boolean areOverriddenMethods(IMethodBinding overridden, IMethodBinding overridable) {
        if (!overridden.getName().equals(overridable.getName())) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    private static boolean areSubTypeCompatible(IMethodBinding overridden, IMethodBinding overridable) {
        ITypeBinding[] overridableTypes;
        if (overridden.getParameterTypes().length != overridable.getParameterTypes().length) {
            return false;
        }
        ITypeBinding overriddenReturn = overridden.getReturnType();
        ITypeBinding overridableReturn = overridable.getReturnType();
        if (overriddenReturn == null || overridableReturn == null) {
            return false;
        }
        if (!overriddenReturn.getErasure().isSubTypeCompatible(overridableReturn.getErasure())) {
            return false;
        }
        ITypeBinding[] overriddenTypes = overridden.getParameterTypes();
        Assert.isTrue((overriddenTypes.length == (overridableTypes = overridable.getParameterTypes()).length ? 1 : 0) != 0);
        int index = 0;
        while (index < overriddenTypes.length) {
            ITypeBinding overriddenErasure;
            ITypeBinding overridableErasure = overridableTypes[index].getErasure();
            if (!overridableErasure.isSubTypeCompatible(overriddenErasure = overriddenTypes[index].getErasure()) || !overridableErasure.getKey().equals(overriddenErasure.getKey())) {
                return false;
            }
            ++index;
        }
        ITypeBinding[] overriddenExceptions = overridden.getExceptionTypes();
        ITypeBinding[] overridableExceptions = overridable.getExceptionTypes();
        boolean checked = false;
        int index2 = 0;
        while (index2 < overriddenExceptions.length) {
            checked = false;
            int offset = 0;
            while (offset < overridableExceptions.length) {
                if (overriddenExceptions[index2].isSubTypeCompatible(overridableExceptions[offset])) {
                    checked = true;
                }
                ++offset;
            }
            if (!checked) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public static ITypeBinding getBoxedTypeBinding(ITypeBinding type, AST ast) {
        if (!type.isPrimitive()) {
            return type;
        }
        String boxedTypeName = Bindings.getBoxedTypeName(type.getName());
        if (boxedTypeName == null) {
            return type;
        }
        ITypeBinding boxed = ast.resolveWellKnownType(boxedTypeName);
        if (boxed == null) {
            return type;
        }
        return boxed;
    }

    private static String getBoxedTypeName(String primitiveName) {
        if ("long".equals(primitiveName)) {
            return "java.lang.Long";
        }
        if ("int".equals(primitiveName)) {
            return "java.lang.Integer";
        }
        if ("short".equals(primitiveName)) {
            return "java.lang.Short";
        }
        if ("char".equals(primitiveName)) {
            return "java.lang.Character";
        }
        if ("byte".equals(primitiveName)) {
            return "java.lang.Byte";
        }
        if ("boolean".equals(primitiveName)) {
            return "java.lang.Boolean";
        }
        if ("float".equals(primitiveName)) {
            return "java.lang.Float";
        }
        if ("double".equals(primitiveName)) {
            return "java.lang.Double";
        }
        return null;
    }

    public static ITypeBinding getUnboxedTypeBinding(ITypeBinding type, AST ast) {
        if (!type.isClass()) {
            return type;
        }
        String unboxedTypeName = Bindings.getUnboxedTypeName(type.getQualifiedName());
        if (unboxedTypeName == null) {
            return type;
        }
        ITypeBinding unboxed = ast.resolveWellKnownType(unboxedTypeName);
        if (unboxed == null) {
            return type;
        }
        return unboxed;
    }

    private static String getUnboxedTypeName(String boxedName) {
        if ("java.lang.Long".equals(boxedName)) {
            return "long";
        }
        if ("java.lang.Integer".equals(boxedName)) {
            return "int";
        }
        if ("java.lang.Short".equals(boxedName)) {
            return "short";
        }
        if ("java.lang.Character".equals(boxedName)) {
            return "char";
        }
        if ("java.lang.Byte".equals(boxedName)) {
            return "byte";
        }
        if ("java.lang.Boolean".equals(boxedName)) {
            return "boolean";
        }
        if ("java.lang.Float".equals(boxedName)) {
            return "float";
        }
        if ("java.lang.Double".equals(boxedName)) {
            return "double";
        }
        return null;
    }

    public static IBinding resolveExpressionBinding(Expression expression, boolean goIntoCast) {
        switch (expression.getNodeType()) {
            case 40: 
            case 42: {
                return ((Name)expression).resolveBinding();
            }
            case 22: {
                return ((FieldAccess)expression).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)expression).resolveFieldBinding();
            }
            case 32: {
                return ((MethodInvocation)expression).resolveMethodBinding();
            }
            case 48: {
                return ((SuperMethodInvocation)expression).resolveMethodBinding();
            }
            case 14: {
                return ((ClassInstanceCreation)expression).resolveConstructorBinding();
            }
            case 77: 
            case 78: 
            case 79: {
                return ((Annotation)expression).resolveAnnotationBinding();
            }
            case 2: {
                return Bindings.resolveExpressionBinding(((ArrayAccess)expression).getArray(), goIntoCast);
            }
            case 11: {
                if (goIntoCast) {
                    return Bindings.resolveExpressionBinding(((CastExpression)expression).getExpression(), true);
                }
                return null;
            }
            case 36: {
                return Bindings.resolveExpressionBinding(((ParenthesizedExpression)expression).getExpression(), goIntoCast);
            }
            case 38: {
                return Bindings.resolveExpressionBinding(((PrefixExpression)expression).getOperand(), goIntoCast);
            }
            case 37: {
                return Bindings.resolveExpressionBinding(((PostfixExpression)expression).getOperand(), goIntoCast);
            }
        }
        return null;
    }
}

