/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.refactoring.descriptors.ChangeMethodSignatureDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceParameterDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class IntroduceParameterRefactoring
extends Refactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_ARGUMENT = "argument";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private IMethod fMethod;
    private Refactoring fChangeSignatureRefactoring;
    private ChangeSignatureProcessor fChangeSignatureProcessor;
    private ParameterInfo fParameter;
    private String fParameterName;
    private JavaRefactoringArguments fArguments;
    private Expression fSelectedExpression;
    private String[] fExcludedParameterNames;
    static /* synthetic */ Class class$0;

    public IntroduceParameterRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSourceCU = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    public IntroduceParameterRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fChangeSignatureProcessor != null ? this.fChangeSignatureProcessor.getDelegateUpdating() : false;
    }

    public void setDelegateUpdating(boolean updating) {
        if (this.fChangeSignatureProcessor != null) {
            this.fChangeSignatureProcessor.setDelegateUpdating(updating);
        }
    }

    public void setDeprecateDelegates(boolean deprecate) {
        if (this.fChangeSignatureProcessor != null) {
            this.fChangeSignatureProcessor.setDeprecateDelegates(deprecate);
        }
    }

    public boolean getDeprecateDelegates() {
        return this.fChangeSignatureProcessor != null ? this.fChangeSignatureProcessor.getDeprecateDelegates() : false;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            CompilationUnitRewrite cuRewrite;
            pm.beginTask("", 7);
            if (!this.fSourceCU.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                return refactoringStatus;
            }
            IJavaElement enclosingElement = SelectionConverter.resolveEnclosingElement((IJavaElement)this.fSourceCU, (ITextSelection)new TextSelection(this.fSelectionStart, this.fSelectionLength));
            if (!(enclosingElement instanceof IMethod)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                return refactoringStatus;
            }
            this.fMethod = (IMethod)enclosingElement;
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fArguments != null) {
                this.fChangeSignatureProcessor = new ChangeSignatureProcessor(this.fArguments, result);
                if (result.hasFatalError()) {
                    pm.worked(2);
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            } else {
                ChangeSignatureProcessor changeSignatureProcessor = this.fChangeSignatureProcessor = RefactoringAvailabilityTester.isChangeSignatureAvailable(this.fMethod) ? new ChangeSignatureProcessor(this.fMethod) : null;
                if (this.fChangeSignatureProcessor == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatusEntry entry = result.getEntryMatchingSeverity(4);
                    if (entry.getCode() != 1 && entry.getCode() != 2) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                    IMethod method = (IMethod)entry.getData();
                    ChangeSignatureProcessor changeSignatureProcessor2 = this.fChangeSignatureProcessor = RefactoringAvailabilityTester.isChangeSignatureAvailable(method) ? new ChangeSignatureProcessor(method) : null;
                    if (this.fChangeSignatureProcessor == null) {
                        String msg = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_cannot_introduce, entry.getMessage());
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)msg);
                        return refactoringStatus;
                    }
                    result = this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                } else {
                    pm.worked(1);
                }
            }
            if (!(cuRewrite = this.fChangeSignatureProcessor.getBaseCuRewrite()).getCu().equals(this.fSourceCU)) {
                cuRewrite = new CompilationUnitRewrite(this.fSourceCU);
            }
            this.initializeSelectedExpression(cuRewrite);
            pm.worked(1);
            result.merge(this.checkSelection(cuRewrite, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.initializeExcludedParameterNames(cuRewrite);
            this.addParameterInfo(cuRewrite);
            this.fChangeSignatureProcessor.setBodyUpdater(new BodyUpdater(){

                public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite rewrite, RefactoringStatus updaterResult) {
                    IntroduceParameterRefactoring.this.replaceSelectedExpression(rewrite);
                }
            });
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
            if (this.fChangeSignatureRefactoring != null) {
                this.fChangeSignatureRefactoring.setValidationContext(null);
            }
        }
    }

    private void addParameterInfo(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        ITypeBinding typeBinding = Bindings.normalizeForDeclarationUse(this.fSelectedExpression.resolveTypeBinding(), this.fSelectedExpression.getAST());
        String typeName = cuRewrite.getImportRewrite().addImport(typeBinding);
        String name = this.fParameterName != null ? this.fParameterName : this.guessedParameterName();
        String defaultValue = this.fSourceCU.getBuffer().getText(this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        this.fParameter = ParameterInfo.createInfoForAddedParameter(typeBinding, typeName, name, defaultValue);
        if (this.fArguments == null) {
            List parameterInfos = this.fChangeSignatureProcessor.getParameterInfos();
            int parametersCount = parameterInfos.size();
            if (parametersCount > 0 && ((ParameterInfo)parameterInfos.get(parametersCount - 1)).isOldVarargs()) {
                parameterInfos.add(parametersCount - 1, this.fParameter);
            } else {
                parameterInfos.add(this.fParameter);
            }
        }
    }

    private void replaceSelectedExpression(CompilationUnitRewrite cuRewrite) {
        if (!this.fSourceCU.equals(cuRewrite.getCu())) {
            return;
        }
        Expression expression = (Expression)NodeFinder.perform((ASTNode)cuRewrite.getRoot(), (int)this.fSelectedExpression.getStartPosition(), (int)this.fSelectedExpression.getLength());
        SimpleName newExpression = cuRewrite.getRoot().getAST().newSimpleName(this.fParameter.getNewName());
        String description = RefactoringCoreMessages.IntroduceParameterRefactoring_replace;
        cuRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)newExpression, cuRewrite.createGroupDescription(description));
    }

    private void initializeSelectedExpression(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)cuRewrite.getRoot(), cuRewrite.getCu());
        if (!(fragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
        if (fragment.getStartPosition() != expression.getStartPosition() || fragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        if (Checks.isEnumCase(expression.getParent())) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(CompilationUnitRewrite cuRewrite, IProgressMonitor pm) {
        try {
            MethodDeclaration methodDeclaration;
            if (this.fSelectedExpression == null) {
                String message = RefactoringCoreMessages.IntroduceParameterRefactoring_select;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, cuRewrite.getRoot(), message);
                return refactoringStatus;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, clazz)) == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                return refactoringStatus;
            }
            if (methodDeclaration.resolveBinding() == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_binding);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkExpressionBinding());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: 
            case 3: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_select, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public List getParameterInfos() {
        return this.fChangeSignatureProcessor.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        return this.fChangeSignatureProcessor.getNewMethodSignature();
    }

    public void setParameterName(String name) {
        Assert.isNotNull((Object)name);
        this.fParameter.setNewName(name);
    }

    public String guessedParameterName() {
        String[] proposals = this.guessParameterNames();
        if (proposals.length == 0) {
            return "";
        }
        return proposals[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        if (this.fSelectedExpression instanceof MethodInvocation) {
            proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)this.fSelectedExpression, this.fExcludedParameterNames));
        }
        proposals.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, this.fExcludedParameterNames));
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        int i = 0;
        while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.EMPTY_LIST;
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++i;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = Bindings.normalizeForDeclarationUse(selectedExpression.resolveTypeBinding(), selectedExpression.getAST());
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames(CompilationUnitRewrite cuRewrite) {
        IBinding[] bindings = new ScopeAnalyzer(cuRewrite.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
            ++i;
        }
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureProcessor.checkSignature();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            RefactoringStatus refactoringStatus = this.fChangeSignatureRefactoring.checkFinalConditions(pm);
            return refactoringStatus;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            Change[] changes = this.fChangeSignatureProcessor.getAllChanges();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)this.getRefactoringDescriptor(), RefactoringCoreMessages.IntroduceParameterRefactoring_name, changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
            pm.done();
        }
    }

    private IntroduceParameterDescriptor getRefactoringDescriptor() {
        ChangeMethodSignatureDescriptor extended = (ChangeMethodSignatureDescriptor)this.fChangeSignatureProcessor.createDescriptor();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.jdt.ui.change.method.signature");
        Map argumentsMap = contribution.retrieveArgumentMap((RefactoringDescriptor)extended);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ATTRIBUTE_ARGUMENT, this.fParameter.getNewName());
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.putAll(argumentsMap);
        String signature = this.fChangeSignatureProcessor.getMethodName();
        try {
            signature = this.fChangeSignatureProcessor.getOldMethodSignature();
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fChangeSignatureProcessor.getMethod().getElementName()));
        String header = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fParameter.getNewName()), signature, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)this.fSelectedExpression))});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(extended.getProject(), this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_original_pattern, JavaElementLabels.getTextLabel(this.fChangeSignatureProcessor.getMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_expression_pattern, BasicElementLabels.getJavaCodeString(ASTNodes.asString((ASTNode)this.fSelectedExpression))));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_parameter_pattern, BasicElementLabels.getJavaElementName(this.getAddedParameterInfo().getNewName())));
        return RefactoringSignatureDescriptorFactory.createIntroduceParameterDescriptor((String)extended.getProject(), (String)description, (String)comment.asString(), arguments, (int)extended.getFlags());
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        this.fArguments = arguments;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.parameter");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fSourceCU = ((IMethod)element).getCompilationUnit();
        String name = arguments.getAttribute(ATTRIBUTE_ARGUMENT);
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ARGUMENT));
        }
        this.fParameterName = name;
        return new RefactoringStatus();
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }
}

