/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private final ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private final TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDVAR = 2;
    private final int IDX_ADDLIB = 3;
    private final int IDX_ADDFOL = 4;
    private final int IDX_ADDEXTFOL = 5;
    private final int IDX_EDIT = 7;
    private final int IDX_REMOVE = 8;
    private final int IDX_REPLACE = 10;

    public LibrariesWorkbookPage(CheckedListDialogField classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[11];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addjar_button;
        stringArray[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[2] = NewWizardMessages.LibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[5] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextfolder_button;
        stringArray[7] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[8] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        stringArray[10] = NewWizardMessages.LibrariesWorkbookPage_libraries_replace_button;
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(8, false);
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.enableButton(10, false);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
    }

    private void updateLibrariesList() {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 5: {
                libentries = this.openExternalClassFolderDialog(null);
                break;
            }
            case 7: {
                this.editEntry();
                return;
            }
            case 8: {
                this.removeEntry();
                return;
            }
            case 10: {
                this.replaceJarFile();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
                    curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 4) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fLibrariesList.addElements(elementsToAdd);
            if (index == 3 || index == 2) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    public void addElement(CPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        List existing = this.fClassPathList.getElements();
        LibrariesWorkbookPage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existing.toArray(new CPListElement[existing.size()]), modified);
        if (!modified.isEmpty()) {
            String title = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = field.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void replaceJarFile() {
        IPackageFragmentRoot root = this.getSelectedPackageFragmentRoot();
        if (root != null) {
            JarImportWizard wizard = new JarImportWizard(false);
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)root));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 520);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.jar_import_wizard_page_context");
            dialog.open();
        }
    }

    private IPackageFragmentRoot getSelectedPackageFragmentRoot() {
        IJavaProject project;
        CPListElement element;
        IClasspathEntry entry;
        Object object;
        List elements = this.fLibrariesList.getSelectedElements();
        if (elements.size() == 1 && (object = elements.get(0)) instanceof CPListElement && JarImportWizard.isValidClassPathEntry(entry = (element = (CPListElement)object).getClasspathEntry()) && (project = element.getJavaProject()) != null) {
            try {
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int index = 0;
                while (index < roots.length) {
                    if (entry.equals(roots[index].getRawClasspathEntry())) {
                        return roots[index];
                    }
                    ++index;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        return null;
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashMap<CPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<CPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn()) {
                    IAccessRule[] value = null;
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.setValue(value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof CPListElement) {
                    CPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        Iterator iter = containerEntriesToUpdate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            CPListElement curr = (CPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            IClasspathEntry changedEntry = curr.getClasspathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.isNonModifiable()) {
                    return false;
                }
                if (attrib.isBuiltIn()) {
                    if (attrib.getParent().isInContainer(JavaRuntime.JRE_CONTAINER) && "accessrules".equals(attrib.getKey())) {
                        return false;
                    }
                    if (attrib.getKey().equals("accessrules")) {
                        return ((IAccessRule[])attrib.getValue()).length > 0;
                    }
                    if (attrib.getValue() == null) {
                        return false;
                    }
                } else if (!this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else if (elem instanceof CPListElement) {
                CPListElement curr = (CPListElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        if (key.equals("sourcepath")) {
            IClasspathEntry result = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), selElement.getClasspathEntry());
            if (result != null) {
                selElement.setAttribute("sourcepath", result.getSourceAttachmentPath());
                String[] changedAttributes = new String[]{"sourcepath"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fLibrariesList.refresh(elem);
                this.fLibrariesList.update(selElement);
                this.fClassPathList.refresh();
                this.updateEnabledState();
            }
        } else if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null);
            int res = dialog.open();
            if (res == 0 || res == 10) {
                selElement.setAttribute("accessrules", dialog.getAccessRules());
                String[] changedAttributes = new String[]{"accessrules"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fLibrariesList.refresh(elem);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
                if (res == 10) {
                    dialog.performPageSwitch(this.fPageContainer);
                }
            }
        } else if (this.editCustomAttribute(this.getShell(), elem)) {
            String[] changedAttributes = new String[]{key};
            this.attributeUpdated(selElement, changedAttributes);
            this.fLibrariesList.refresh(elem);
            this.fClassPathList.dialogFieldChanged();
            this.updateEnabledState();
        }
    }

    private void attributeUpdated(CPListElement selElement, String[] changedAttributes) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof CPListElement) {
            IClasspathEntry updatedEntry = selElement.getClasspathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IClasspathEntry newEntry, final String[] changedAttributes, final IJavaProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, newEntry, changedAttributes, jproject, containerPath, false, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    File file = elem.getPath().toFile();
                    if (file.isDirectory()) {
                        res = this.openExternalClassFolderDialog(elem);
                        break;
                    }
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() == 2) {
                    if (resource.exists()) {
                        res = this.openClassFolderDialog(elem);
                        break;
                    }
                    res = this.openNewClassFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            curr.setAttributesFromExisting(elem);
            this.fLibrariesList.replaceElement(elem, curr);
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(7, this.canEdit(selElements));
        this.fLibrariesList.enableButton(8, this.canRemove(selElements));
        this.fLibrariesList.enableButton(10, this.getSelectedPackageFragmentRoot() != null);
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(4, noAttributes);
        this.fLibrariesList.enableButton(5, noAttributes);
        this.fLibrariesList.enableButton(0, noAttributes);
        this.fLibrariesList.enableButton(3, noAttributes);
        this.fLibrariesList.enableButton(2, noAttributes);
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement curr = (CPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (attrib.isNonModifiable()) {
                return false;
            }
            if (!attrib.isBuiltIn()) {
                return this.canEditCustomAttribute(attrib);
            }
            return true;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, BasicElementLabels.getPathLabel(projpath, false)));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedJARFiles(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(this.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry(this.getShell(), existing.getPath(), this.getUsedJARFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPackageFragmentRoot[] roots = existing.getJavaProject().findPackageFragmentRoots(existing.getClasspathEntry());
            IPath path = roots.length == 1 ? roots[0].getPath() : existing.getPath();
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), path);
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openExternalClassFolderDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalClassFolderEntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalClassFolderEntries(this.getShell(), existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    IPath path = paths[i2];
                    CPListElement elem = this.createCPVariableElement(path);
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                return new CPListElement[]{this.createCPVariableElement(path)};
            }
        }
        return null;
    }

    private CPListElement createCPVariableElement(IPath path) {
        CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
        return elem;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = CPListElement.create(created[i], true, this.fCurrJProject);
                    ++i;
                }
                return res;
            }
        } else {
            IClasspathEntry existingEntry = existing.getClasspathEntry();
            IClasspathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existingEntry, this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(null, this.fCurrJProject, 5, created.getPath(), !created.equals(existingEntry), null, null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            if (element instanceof CPListElementAttribute && "accessrules".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

