/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.VirtualItem;

class VirtualTree
extends VirtualItem {
    private boolean fLazy;
    private VirtualItem fTopItem;
    private Set fVirtualItemListeners = new HashSet(1);
    private VirtualItem[] fSelection = new VirtualItem[0];

    VirtualTree(int style) {
        super(null, new VirtualItem.Index(0));
        this.fLazy = (style & 0x10000000) != 0;
        this.clearNeedsLabelUpdate();
        this.clearNeedsDataUpdate();
    }

    void dispose() {
        super.dispose();
        this.fVirtualItemListeners.clear();
    }

    void setNeedsCountUpdate() {
        super.setNeedsCountUpdate();
        this.clearNeedsLabelUpdate();
        this.clearNeedsDataUpdate();
    }

    void setNeedsLabelUpdate() {
    }

    void setData(String key, Object data) {
        super.setData(key, data);
        if (data == null) {
            this.clearNeedsDataUpdate();
        }
    }

    void addItemListener(IVirtualItemListener listener) {
        this.fVirtualItemListeners.add(listener);
    }

    void removeItemListener(IVirtualItemListener listener) {
        this.fVirtualItemListeners.remove(listener);
    }

    VirtualItem[] getSelection() {
        return this.fSelection;
    }

    void setSelection(VirtualItem[] items) {
        this.fSelection = items;
    }

    void showItem(VirtualItem item) {
        this.setTopItem(item);
    }

    void fireItemDisposed(VirtualItem item) {
        Iterator itr = this.fVirtualItemListeners.iterator();
        while (itr.hasNext()) {
            ((IVirtualItemListener)itr.next()).disposed(item);
        }
    }

    void fireItemRevealed(VirtualItem item) {
        Iterator itr = this.fVirtualItemListeners.iterator();
        while (itr.hasNext()) {
            ((IVirtualItemListener)itr.next()).revealed(item);
        }
    }

    void setData(Object data) {
        super.setData(data);
        this.setHasItems(data != null);
    }

    void setTopItem(VirtualItem item) {
        this.fTopItem = item;
    }

    VirtualItem getTopItem() {
        return this.fTopItem;
    }

    void setHasItems(boolean hasChildren) {
        super.setHasItems(hasChildren);
        if (hasChildren) {
            this.setExpanded(true);
        }
    }

    boolean isItemVisible(VirtualItem item) {
        if (!this.fLazy) {
            return true;
        }
        int i = 0;
        while (i < this.fSelection.length) {
            VirtualItem selectionItem = this.fSelection[i];
            while (selectionItem != null) {
                if (item.equals(selectionItem)) {
                    return true;
                }
                selectionItem = selectionItem.getParent();
            }
            ++i;
        }
        return false;
    }

    void validate() {
        this.validate(this);
    }

    void validate(VirtualItem item) {
        if (item.needsDataUpdate()) {
            if (this.isItemVisible(item)) {
                this.fireItemRevealed(item);
            }
        } else if (item.getData() != null) {
            if ((item.needsLabelUpdate() || item.needsCountUpdate() && item.hasItems() && item.getExpanded()) && this.isItemVisible(item)) {
                this.fireItemRevealed(item);
            }
            if (item.getData() != null && item.getItemCount() > 0 && item.getExpanded()) {
                int i = 0;
                while (i < item.getItemCount()) {
                    this.validate(item.getItem(new VirtualItem.Index(i)));
                    ++i;
                }
            }
        }
    }

    public static interface IVirtualItemListener {
        public void revealed(VirtualItem var1);

        public void disposed(VirtualItem var1);
    }
}

