/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.e4.compatibility.E4Util;

public class ShowPartPaneMenuHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public ShowPartPaneMenuHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPartSite site;
        IWorkbenchPart part = HandlerUtil.getActivePart(event);
        if (part != null && (site = part.getSite()) instanceof PartSite) {
            E4Util.unsupported("Need to show the system menu");
        }
        return null;
    }

    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    IWorkbenchPart part = InternalHandlerUtil.getActivePart(context);
                    if (part != null) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }
}

