/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.EclipseInstallGeneratorInfoProvider;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Generator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;

public class EclipseGeneratorApplication
implements IApplication {
    private static final String[][] INPLACE_MAPPING_RULES = new String[][]{{"(& (classifier=osgi.bundle) (format=packed)", "${repoUrl}/features/${id}_${version}.jar.pack.gz"}, {"(& (classifier=org.eclipse.update.feature))", "${repoUrl}/features/${id}_${version}.jar"}, {"(& (classifier=osgi.bundle))", "${repoUrl}/plugins/${id}_${version}.jar"}, {"(& (classifier=binary))", "${repoUrl}/binary/${id}_${version}"}};
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private Generator.GeneratorResult incrementalResult = null;
    private boolean generateRootIU = true;
    private URI metadataLocation;
    private String metadataRepoName;
    private URI artifactLocation;
    private String artifactRepoName;
    private String operation;
    private String argument;
    private String features;
    private String bundles;
    private String base;
    private String compress = "false";
    private ServiceReference agentRef;
    private IProvisioningAgent agent;

    private File getExecutableName(String base, EclipseInstallGeneratorInfoProvider provider) {
        File location = provider.getExecutableLocation();
        if (location == null) {
            return new File(base, EclipseInstallGeneratorInfoProvider.getDefaultExecutableName(null));
        }
        if (location.isAbsolute()) {
            return location;
        }
        return new File(base, location.getPath());
    }

    private void initialize(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        if ("-source".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument));
        } else if ("-inplace".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument));
            this.initializeForInplace(provider);
        } else if ("-config".equalsIgnoreCase(this.operation)) {
            provider.initialize(new File(this.argument), new File(this.argument, "configuration"), this.getExecutableName(this.argument, provider), null, null);
        } else if ("-updateSite".equalsIgnoreCase(this.operation)) {
            provider.setAddDefaultIUs(false);
            provider.initialize(new File(this.argument), null, null, new File[]{new File(this.argument, "plugins")}, new File(this.argument, "features"));
            this.initializeForInplace(provider);
        } else if (this.base != null) {
            File[] fileArray;
            if (this.bundles == null) {
                fileArray = null;
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = new File(this.bundles);
            }
            File[] bundlesLocation = fileArray;
            File featuresLocation = this.features == null ? null : new File(this.features);
            provider.initialize(new File(this.base), null, null, bundlesLocation, featuresLocation);
        }
        this.initializeRepositories(provider);
    }

    private void initializeArtifactRepository(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        if (this.artifactLocation == null) {
            return;
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI location = this.artifactLocation;
        String repositoryName = this.artifactRepoName != null && this.artifactRepoName.length() > 0 ? this.artifactRepoName : this.artifactLocation + " - artifacts";
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("p2.compressed", this.compress);
        if (provider.reuseExistingPack200Files()) {
            properties.put(PUBLISH_PACK_FILES_AS_SIBLINGS, Boolean.TRUE.toString());
        }
        IArtifactRepository result = null;
        try {
            result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            manager.removeRepository(location);
            provider.setArtifactRepository(result);
            return;
        }
        catch (ProvisionException provisionException) {
            IArtifactRepository repository = manager.loadRepository(location, null);
            if (repository != null) {
                manager.removeRepository(location);
                if (!repository.isModifiable()) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoNotWritable, (Object)location));
                }
                provider.setArtifactRepository(repository);
                if (provider.reuseExistingPack200Files()) {
                    repository.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
                }
                if (!provider.append()) {
                    File repoLocation = URIUtil.toFile((URI)location);
                    if (repoLocation.isFile()) {
                        repoLocation = repoLocation.getParentFile();
                    }
                    if (repoLocation.equals(provider.getBaseLocation())) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoNoAppendDestroysInput, (Object)location));
                    }
                    repository.removeAll();
                }
            }
            return;
        }
    }

    public void initializeForInplace(EclipseInstallGeneratorInfoProvider provider) {
        File location = provider.getBaseLocation();
        if (location == null) {
            location = provider.getBundleLocations()[0];
        }
        this.metadataLocation = location.toURI();
        this.artifactLocation = location.toURI();
        provider.setPublishArtifactRepository(true);
        provider.setPublishArtifacts(false);
        provider.setAppend(true);
        provider.setMappingRules(INPLACE_MAPPING_RULES);
    }

    private void initializeMetadataRepository(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        if (this.metadataLocation == null) {
            return;
        }
        URI location = this.metadataLocation;
        String repositoryName = this.metadataRepoName == null || this.metadataRepoName.length() == 0 ? this.metadataLocation + " - metadata" : this.metadataRepoName;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("p2.compressed", this.compress);
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        try {
            IMetadataRepository result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            manager.removeRepository(location);
            provider.setMetadataRepository(result);
            return;
        }
        catch (ProvisionException provisionException) {
            IMetadataRepository repository = manager.loadRepository(location, null);
            if (repository != null) {
                manager.removeRepository(location);
                if (!repository.isModifiable()) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.exception_metadataRepoNotWritable, (Object)location));
                }
                provider.setMetadataRepository(repository);
                if (!provider.append()) {
                    repository.removeAll();
                }
                return;
            }
            return;
        }
    }

    private void initializeRepositories(EclipseInstallGeneratorInfoProvider provider) throws ProvisionException {
        this.initializeArtifactRepository(provider);
        this.initializeMetadataRepository(provider);
    }

    public void setCompress(String value) {
        if (Boolean.valueOf(value).booleanValue()) {
            this.compress = "true";
        }
    }

    public void processCommandLineArguments(String[] args, EclipseInstallGeneratorInfoProvider provider) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-publishArtifacts") || args[i].equalsIgnoreCase("-pa")) {
                provider.setPublishArtifacts(true);
            }
            if (args[i].equalsIgnoreCase("-publishArtifactRepository") || args[i].equalsIgnoreCase("-par")) {
                provider.setPublishArtifactRepository(true);
            }
            if (args[i].equalsIgnoreCase("-append")) {
                provider.setAppend(true);
            }
            if (args[i].equalsIgnoreCase("-noDefaultIUs")) {
                provider.setAddDefaultIUs(false);
            }
            if (args[i].equalsIgnoreCase("-compress")) {
                this.compress = "true";
            }
            if (args[i].equalsIgnoreCase("-reusePack200Files")) {
                provider.reuseExistingPack200Files(true);
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-inplace")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-config")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-updateSite")) {
                    this.operation = args[i - 1];
                    this.argument = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-exe")) {
                    provider.setExecutableLocation(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-launcherConfig")) {
                    provider.setLauncherConfig(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-metadataRepositoryName")) {
                    this.metadataRepoName = arg;
                }
                try {
                    if (args[i - 1].equalsIgnoreCase("-metadataRepository") || args[i - 1].equalsIgnoreCase("-mr")) {
                        this.metadataLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-artifactRepository") | args[i - 1].equalsIgnoreCase("-ar")) {
                        this.artifactLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-site")) {
                        provider.setSiteLocation(URIUtil.fromString((String)arg));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Repository location (" + arg + ") must be a URL.");
                }
                if (args[i - 1].equalsIgnoreCase("-artifactRepositoryName")) {
                    this.artifactRepoName = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-flavor")) {
                    provider.setFlavor(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-productFile")) {
                    provider.setProductFile(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-features")) {
                    this.features = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-bundles")) {
                    this.bundles = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-base")) {
                    this.base = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-root")) {
                    provider.setRootId(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-rootVersion")) {
                    provider.setRootVersion(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-p2.os")) {
                    provider.setOS(arg);
                }
            }
            ++i;
        }
    }

    public Object run(String[] args) throws Exception {
        EclipseInstallGeneratorInfoProvider provider = new EclipseInstallGeneratorInfoProvider();
        this.processCommandLineArguments(args, provider);
        Object result = this.run(provider);
        if (result != IApplication.EXIT_OK) {
            int i = 0;
            while (i < args.length) {
                System.out.println(args[i]);
                ++i;
            }
        }
        return result;
    }

    public Object run(EclipseInstallGeneratorInfoProvider provider) throws Exception {
        this.initializeAgent();
        this.initialize(provider);
        if (provider.getBaseLocation() == null && provider.getProductFile() == null && !this.generateRootIU) {
            System.out.println(Messages.exception_baseLocationNotSpecified);
            return new Integer(-1);
        }
        if ((provider.publishArtifactRepository() || provider.publishArtifacts()) && provider.getArtifactRepository() == null) {
            System.out.println(Messages.exception_artifactRepoNotSpecified);
            return new Integer(-1);
        }
        if (provider.getMetadataRepository() == null) {
            System.out.println(Messages.exception_metadataRepoNotSpecified);
            return new Integer(-1);
        }
        System.out.println(NLS.bind((String)Messages.message_generatingMetadata, (Object)provider.getBaseLocation()));
        long before = System.currentTimeMillis();
        IStatus result = this.generate(provider);
        long after = System.currentTimeMillis();
        if (result.isOK()) {
            System.out.println(NLS.bind((String)Messages.message_generationCompleted, (Object)String.valueOf((after - before) / 1000L)));
            return IApplication.EXIT_OK;
        }
        System.out.println(result);
        return new Integer(1);
    }

    private void initializeAgent() throws ProvisionException {
        ServiceReference providerRef;
        this.agentRef = Activator.getContext().getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (this.agentRef != null) {
            this.agent = (IProvisioningAgent)Activator.getContext().getService(this.agentRef);
            if (this.agent != null) {
                return;
            }
        }
        if ((providerRef = Activator.getContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME)) == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)Activator.getContext().getService(providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        this.agent = provider.createAgent(null);
        Activator.getContext().ungetService(providerRef);
    }

    protected IStatus generate(EclipseInstallGeneratorInfoProvider provider) {
        Generator generator = new Generator(provider);
        if (this.incrementalResult != null) {
            generator.setIncrementalResult(this.incrementalResult);
        }
        generator.setGenerateRootIU(this.generateRootIU);
        IStatus result = generator.generate();
        this.incrementalResult = null;
        return result;
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        if (this.agentRef != null) {
            Activator.getContext().ungetService(this.agentRef);
            this.agentRef = null;
        }
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setArtifactLocation(URI location) {
        this.artifactLocation = location;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public void setOperation(String operation, String argument) {
        this.operation = operation;
        this.argument = argument;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    public void setMetadataLocation(URI location) {
        this.metadataLocation = location;
    }

    public void setMetadataRepositoryName(String name) {
        this.metadataRepoName = name;
    }

    public void setArtifactRepositoryName(String name) {
        this.artifactRepoName = name;
    }

    public void setIncrementalResult(Generator.GeneratorResult ius) {
        this.incrementalResult = ius;
    }

    public void setGeneratorRootIU(boolean b) {
        this.generateRootIU = b;
    }
}

