/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewIdRegistry;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewSynchronizationService;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.SwitchMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ToggleMemoryMonitorsAction;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneOrientationAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class MemoryView
extends ViewPart
implements IMemoryRenderingSite {
    protected MemoryViewSelectionProvider fSelectionProvider;
    private MemoryViewPartListener fPartListener;
    private SashForm fSashForm;
    private Hashtable fViewPanes = new Hashtable();
    private Hashtable fViewPaneControls = new Hashtable();
    private ArrayList fVisibleViewPanes = new ArrayList();
    private boolean fVisible;
    private ArrayList fWeights = new ArrayList();
    private static final String VISIBILITY_PREF = "org.eclipse.debug.ui.MemoryView.viewPanesVisibility";
    private static final String ID_MEMORY_VIEW_CONTEXT = "org.eclipse.debug.ui.memoryview";
    private static final String ID_ADD_MEMORY_BLOCK_COMMAND = "org.eclipse.debug.ui.commands.addMemoryMonitor";
    private static final String ID_TOGGLE_MEMORY_MONITORS_PANE_COMMAND = "org.eclipse.debug.ui.commands.toggleMemoryMonitorsPane";
    private static final String ID_NEXT_MEMORY_BLOCK_COMMAND = "org.eclipse.debug.ui.commands.nextMemoryBlock";
    private static final String ID_NEW_RENDERING_COMMAND = "org.eclipse.debug.ui.commands.newRendering";
    private static final String ID_CLOSE_RENDERING_COMMAND = "org.eclipse.debug.ui.commands.closeRendering";
    public static final String VIEW_PANE_ORIENTATION_PREF = "org.eclipse.debug.ui.MemoryView.orientation";
    public static final int HORIZONTAL_VIEW_ORIENTATION = 0;
    public static final int VERTICAL_VIEW_ORIENTATION = 1;
    private String[] defaultVisiblePaneIds = new String[]{MemoryBlocksTreeViewPane.PANE_ID, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1"};
    private MemoryBlocksTreeViewPane fMemBlkViewer;
    private MemoryViewSynchronizationService fSyncService;
    private boolean fPinMBDisplay = false;
    private static int fViewCnt = 0;
    private AbstractHandler fAddHandler;
    private AbstractHandler fToggleMonitorsHandler;
    private AbstractHandler fNextMemoryBlockHandler;
    private AbstractHandler fNewRenderingHandler;
    private AbstractHandler fCloseRenderingHandler;
    private ViewPaneOrientationAction[] fOrientationActions;
    private int fViewOrientation = 0;
    private String fActivePaneId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ++fViewCnt;
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            MemoryViewIdRegistry.registerView(secondaryId);
        }
        if (fViewCnt == 1 && DebugUIPlugin.getActiveWorkbenchWindow() != null && DebugUIPlugin.getActiveWorkbenchWindow().getActivePage() != null) {
            IViewReference[] references = DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int i = 0;
            while (i < references.length) {
                if (references[i].getSecondaryId() != null) {
                    MemoryViewIdRegistry.registerView(references[i].getSecondaryId());
                }
                ++i;
            }
        }
        this.fSyncService = new MemoryViewSynchronizationService();
    }

    public void createPartControl(Composite parent) {
        this.fSashForm = new SashForm(parent, 256);
        this.fSelectionProvider = new MemoryViewSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.createMemoryBlocksTreeViewPane((Composite)this.fSashForm);
        this.createRenderingViewPane("org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
        this.createRenderingViewPane("org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
        this.setVisible(true);
        Integer[] weights = this.fWeights.toArray(new Integer[this.fWeights.size()]);
        int[] intWeights = new int[weights.length];
        int i = 0;
        while (i < weights.length) {
            intWeights[i] = weights[i];
            ++i;
        }
        this.fSashForm.setWeights(intWeights);
        this.loadViewPanesVisibility();
        this.createOrientationActions();
        this.loadOrientation();
        this.fPartListener = new MemoryViewPartListener(this);
        this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        this.activateHandlers();
        this.restoreView();
    }

    public void activateHandlers() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandSupport = (ICommandService)iWorkbenchPartSite.getService((Class)clazz);
        IWorkbenchPartSite iWorkbenchPartSite2 = this.getSite();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite2.getService((Class)clazz2);
        IWorkbenchPartSite iWorkbenchPartSite3 = this.getSite();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService contextSupport = (IContextService)iWorkbenchPartSite3.getService((Class)clazz3);
        if (commandSupport != null && handlerService != null && contextSupport != null) {
            contextSupport.activateContext(ID_MEMORY_VIEW_CONTEXT);
            this.fAddHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    IAdaptable context = DebugUITools.getDebugContext();
                    if (context != null && MemoryViewUtil.isValidSelection((ISelection)new StructuredSelection((Object)context))) {
                        RetargetAddMemoryBlockAction action = new RetargetAddMemoryBlockAction(MemoryView.this);
                        action.run();
                        action.dispose();
                    }
                    return null;
                }
            };
            handlerService.activateHandler(ID_ADD_MEMORY_BLOCK_COMMAND, (IHandler)this.fAddHandler);
            this.fToggleMonitorsHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    ToggleMemoryMonitorsAction action = new ToggleMemoryMonitorsAction();
                    action.init((IViewPart)MemoryView.this);
                    action.run();
                    action.dispose();
                    return null;
                }
            };
            handlerService.activateHandler(ID_TOGGLE_MEMORY_MONITORS_PANE_COMMAND, (IHandler)this.fToggleMonitorsHandler);
            this.fNextMemoryBlockHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    SwitchMemoryBlockAction action = new SwitchMemoryBlockAction();
                    action.init((IViewPart)MemoryView.this);
                    action.run();
                    action.dispose();
                    return null;
                }
            };
            handlerService.activateHandler(ID_NEXT_MEMORY_BLOCK_COMMAND, (IHandler)this.fNextMemoryBlockHandler);
            this.fCloseRenderingHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    IMemoryRenderingContainer container = MemoryView.this.getContainer(MemoryView.this.fActivePaneId);
                    if (container != null) {
                        if (container instanceof RenderingViewPane && !((RenderingViewPane)container).canRemoveRendering()) {
                            return null;
                        }
                        IMemoryRendering activeRendering = container.getActiveRendering();
                        if (activeRendering != null) {
                            container.removeMemoryRendering(activeRendering);
                        }
                    }
                    return null;
                }
            };
            handlerService.activateHandler(ID_CLOSE_RENDERING_COMMAND, (IHandler)this.fCloseRenderingHandler);
            this.fNewRenderingHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    RenderingViewPane pane;
                    IMemoryRenderingContainer container = MemoryView.this.getContainer(MemoryView.this.fActivePaneId);
                    if (container != null && container instanceof RenderingViewPane && (pane = (RenderingViewPane)container).canAddRendering()) {
                        pane.showCreateRenderingTab();
                    }
                    return null;
                }
            };
            handlerService.activateHandler(ID_NEW_RENDERING_COMMAND, (IHandler)this.fNewRenderingHandler);
        }
    }

    private void createMemoryBlocksTreeViewPane(Composite parent) {
        this.fMemBlkViewer = new MemoryBlocksTreeViewPane((IViewPart)this);
        this.fViewPanes.put(MemoryBlocksTreeViewPane.PANE_ID, this.fMemBlkViewer);
        ViewForm viewerViewForm = new ViewForm(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewerViewForm, "org.eclipse.debug.ui.MemoryView_context");
        this.fViewPaneControls.put(MemoryBlocksTreeViewPane.PANE_ID, viewerViewForm);
        this.fWeights.add(new Integer(15));
        this.fMemBlkViewer.addSelectionListener(this.fSelectionProvider);
        Control viewerControl = this.fMemBlkViewer.createViewPane((Composite)viewerViewForm, MemoryBlocksTreeViewPane.PANE_ID, DebugUIMessages.MemoryView_Memory_monitors);
        viewerViewForm.setContent(viewerControl);
        ISelection selection = this.fMemBlkViewer.getSelectionProvider().getSelection();
        if (selection != null) {
            this.fSelectionProvider.setSelection(selection);
        }
        ToolBarManager viewerToolBarMgr = new ToolBarManager(0x800000);
        IAction[] actions = this.fMemBlkViewer.getActions();
        int i = 0;
        while (i < actions.length) {
            viewerToolBarMgr.add(actions[i]);
            ++i;
        }
        ToolBar viewerToolbar = viewerToolBarMgr.createControl((Composite)viewerViewForm);
        viewerViewForm.setTopRight((Control)viewerToolbar);
        Label viewerLabel = new Label((Composite)viewerViewForm, 64);
        viewerLabel.setText(DebugUIMessages.MemoryView_Memory_monitors);
        viewerViewForm.setTopLeft((Control)viewerLabel);
        this.fMemBlkViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MemoryView.this.fActivePaneId = MemoryView.this.fMemBlkViewer.getId();
            }
        });
    }

    private Listener createDeactivateListener(final IMemoryViewPane viewPane) {
        Listener deactivateListener = new Listener(){
            private String id;
            {
                this.id = iMemoryViewPane.getId();
            }

            public void handleEvent(Event event) {
                if (MemoryView.this.fActivePaneId.equals(this.id)) {
                    viewPane.removeSelctionListener(MemoryView.this.fSelectionProvider);
                }
            }
        };
        return deactivateListener;
    }

    private Listener createActivateListener(final IMemoryViewPane viewPane) {
        Listener activateListener = new Listener(){
            private String id;
            {
                this.id = iMemoryViewPane.getId();
            }

            public void handleEvent(Event event) {
                MemoryView.this.fActivePaneId = this.id;
                viewPane.addSelectionListener(MemoryView.this.fSelectionProvider);
                MemoryView.this.fSelectionProvider.setSelection(viewPane.getSelectionProvider().getSelection());
            }
        };
        return activateListener;
    }

    public void createRenderingViewPane(String paneId) {
        RenderingViewPane renderingPane = new RenderingViewPane((IViewPart)this);
        this.fViewPanes.put(paneId, renderingPane);
        ViewForm renderingViewForm = new ViewForm((Composite)this.fSashForm, 0);
        this.fViewPaneControls.put(paneId, renderingViewForm);
        this.fWeights.add(new Integer(40));
        Control renderingControl = renderingPane.createViewPane((Composite)renderingViewForm, paneId, DebugUIMessages.MemoryView_Memory_renderings, true, true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(renderingControl, "org.eclipse.debug.ui.MemoryView_context");
        renderingViewForm.setContent(renderingControl);
        Listener renderingActivateListener = this.createActivateListener(renderingPane);
        renderingControl.addListener(26, renderingActivateListener);
        Listener renderingDeactivateListener = this.createDeactivateListener(renderingPane);
        renderingControl.addListener(27, renderingDeactivateListener);
    }

    public void setFocus() {
        if (this.fActivePaneId == null) {
            this.fActivePaneId = this.fMemBlkViewer.getId();
        }
        IMemoryViewPane pane = this.getViewPane(this.fActivePaneId);
        pane.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
        Enumeration enumeration = this.fViewPanes.elements();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof IMemoryViewPane)) continue;
            ((IMemoryViewPane)element).dispose();
        }
        this.fViewPaneControls.clear();
        IViewSite viewSite = this.getViewSite();
        String secondaryId = viewSite.getSecondaryId();
        if (secondaryId != null) {
            MemoryViewIdRegistry.deregisterView(secondaryId);
        }
        this.fSyncService.shutdown();
        if (this.fAddHandler != null) {
            this.fAddHandler.dispose();
        }
        if (this.fToggleMonitorsHandler != null) {
            this.fToggleMonitorsHandler.dispose();
        }
        if (this.fNextMemoryBlockHandler != null) {
            this.fNextMemoryBlockHandler.dispose();
        }
        super.dispose();
    }

    private void setVisible(boolean visible) {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            if (this.fVisible) {
                viewPanes[i].setVisible(visible && viewPanes[i].isVisible());
            } else if (this.isViewPaneVisible(viewPanes[i].getId())) {
                viewPanes[i].setVisible(visible);
            }
            ++i;
        }
        this.fVisible = visible;
    }

    public IMemoryViewPane getViewPane(String paneId) {
        return (IMemoryViewPane)this.fViewPanes.get(paneId);
    }

    public IMemoryViewPane[] getViewPanes() {
        IMemoryViewPane[] viewPanes = new IMemoryViewPane[this.fViewPanes.size()];
        Enumeration enumeration = this.fViewPanes.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            viewPanes[i] = (IMemoryViewPane)enumeration.nextElement();
            ++i;
        }
        return viewPanes;
    }

    private void restoreView() {
        IMemoryViewPane[] viewPanes = this.getViewPanes();
        int i = 0;
        while (i < viewPanes.length) {
            viewPanes[i].restoreViewPane();
            ++i;
        }
    }

    public void showViewPane(boolean show, String paneId) {
        Control viewPaneControl = (Control)this.fViewPaneControls.get(paneId);
        if (viewPaneControl != null) {
            Control[] children = this.fSashForm.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == viewPaneControl) {
                    children[i].setVisible(show);
                    IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
                    if (viewPane != null) {
                        viewPane.setVisible(show);
                    }
                }
                ++i;
            }
            this.fSashForm.layout();
        }
        this.storeViewPaneVisibility();
    }

    public boolean isViewPaneVisible(String paneId) {
        return this.fVisibleViewPanes.contains(paneId);
    }

    private void storeViewPaneVisibility() {
        this.fVisibleViewPanes.clear();
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        StringBuffer visibleViewPanes = new StringBuffer();
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            String paneId = (String)enumeration.nextElement();
            Control control = (Control)this.fViewPaneControls.get(paneId);
            if (!control.isVisible()) continue;
            visibleViewPanes.append(paneId);
            visibleViewPanes.append(",");
            this.fVisibleViewPanes.add(paneId);
        }
        prefs.setValue(this.getVisibilityPrefId(), visibleViewPanes.toString());
    }

    private void loadViewPanesVisibility() {
        String paneId;
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        String visiblePanes = prefs.getString(this.getVisibilityPrefId());
        if (visiblePanes != null && visiblePanes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(visiblePanes, ",");
            while (tokenizer.hasMoreTokens()) {
                paneId = tokenizer.nextToken();
                this.fVisibleViewPanes.add(paneId);
            }
        } else {
            int i = 0;
            while (i < this.defaultVisiblePaneIds.length) {
                this.fVisibleViewPanes.add(this.defaultVisiblePaneIds[i]);
                ++i;
            }
        }
        Enumeration enumeration = this.fViewPaneControls.keys();
        while (enumeration.hasMoreElements()) {
            paneId = (String)enumeration.nextElement();
            boolean visible = false;
            if (this.fVisibleViewPanes.contains(paneId)) {
                visible = true;
            }
            Control control = (Control)this.fViewPaneControls.get(paneId);
            control.setVisible(visible);
            IMemoryViewPane viewPane = (IMemoryViewPane)this.fViewPanes.get(paneId);
            viewPane.setVisible(visible);
        }
        this.fSashForm.layout();
    }

    private void loadOrientation() {
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        this.fViewOrientation = prefs.getInt(this.getOrientationPrefId());
        int i = 0;
        while (i < this.fOrientationActions.length) {
            if (this.fOrientationActions[i].getOrientation() == this.fViewOrientation) {
                this.fOrientationActions[i].run();
            }
            ++i;
        }
        this.updateOrientationActions();
    }

    private void saveOrientation() {
        Preferences prefs = DebugUIPlugin.getDefault().getPluginPreferences();
        prefs.setValue(this.getOrientationPrefId(), this.fViewOrientation);
    }

    private void updateOrientationActions() {
        int i = 0;
        while (i < this.fOrientationActions.length) {
            if (this.fOrientationActions[i].getOrientation() == this.fViewOrientation) {
                this.fOrientationActions[i].setChecked(true);
            } else {
                this.fOrientationActions[i].setChecked(false);
            }
            ++i;
        }
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return this.fSyncService;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        Enumeration enumeration = this.fViewPanes.elements();
        ArrayList containers = new ArrayList();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof IMemoryRenderingContainer)) continue;
            containers.add(obj);
        }
        return containers.toArray(new IMemoryRenderingContainer[containers.size()]);
    }

    public IMemoryRenderingContainer getContainer(String id) {
        Object viewPane = this.fViewPanes.get(id);
        if (viewPane instanceof IMemoryRenderingContainer) {
            return (IMemoryRenderingContainer)viewPane;
        }
        return null;
    }

    public boolean isPinMBDisplay() {
        return this.fPinMBDisplay;
    }

    public void setPinMBDisplay(boolean pinMBDisplay) {
        this.fPinMBDisplay = pinMBDisplay;
    }

    private String getVisibilityPrefId() {
        IViewSite vs = this.getViewSite();
        String viewId = vs.getSecondaryId();
        if (viewId != null) {
            return "org.eclipse.debug.ui.MemoryView.viewPanesVisibility." + viewId;
        }
        return VISIBILITY_PREF;
    }

    private String getOrientationPrefId() {
        IViewSite vs = this.getViewSite();
        String viewId = vs.getSecondaryId();
        if (viewId != null) {
            return "org.eclipse.debug.ui.MemoryView.orientation." + viewId;
        }
        return VIEW_PANE_ORIENTATION_PREF;
    }

    private void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fOrientationActions = new ViewPaneOrientationAction[2];
        this.fOrientationActions[0] = new ViewPaneOrientationAction(this, 0);
        this.fOrientationActions[1] = new ViewPaneOrientationAction(this, 1);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(VariablesViewMessages.VariablesView_40);
        layoutSubMenu.add((IAction)this.fOrientationActions[0]);
        layoutSubMenu.add((IAction)this.fOrientationActions[1]);
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
    }

    public void setViewPanesOrientation(int orientation) {
        this.fViewOrientation = orientation;
        if (this.fViewOrientation == 1) {
            this.fSashForm.setOrientation(512);
        } else {
            this.fSashForm.setOrientation(256);
        }
        this.saveOrientation();
        this.updateOrientationActions();
    }

    public int getViewPanesOrientation() {
        return this.fViewOrientation;
    }

    class MemoryViewPartListener
    implements IPartListener2 {
        IMemoryRenderingSite fView = null;

        public MemoryViewPartListener(IMemoryRenderingSite view) {
            this.fView = view;
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(false);
            }
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == this.fView) {
                MemoryView.this.setVisible(true);
                MemoryView.this.restoreView();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    }

    class MemoryViewSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        ArrayList fListeners = new ArrayList();
        IStructuredSelection fSelections = new StructuredSelection();

        MemoryViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return this.fSelections;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListeners.contains(listener)) {
                this.fListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                boolean fireChanged = false;
                if (this.fSelections.getFirstElement() != ((IStructuredSelection)selection).getFirstElement()) {
                    fireChanged = true;
                }
                this.fSelections = (IStructuredSelection)selection;
                if (fireChanged) {
                    this.fireChanged();
                }
            }
        }

        public void fireChanged() {
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < this.fListeners.size()) {
                ((ISelectionChangedListener)this.fListeners.get(i)).selectionChanged(evt);
                ++i;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection viewPaneSelection = event.getSelection();
            if (viewPaneSelection instanceof IStructuredSelection) {
                Object selected = ((IStructuredSelection)viewPaneSelection).getFirstElement();
                if (selected != null) {
                    StructuredSelection strucSelection = new StructuredSelection(new Object[]{selected});
                    this.setSelection((ISelection)strucSelection);
                } else {
                    this.setSelection(viewPaneSelection);
                }
            }
        }
    }
}

