/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragHost;

abstract class DragAgent {
    protected MUIElement dragElement;
    protected MElementContainer<MUIElement> originalParent;
    protected int originalIndex;
    private DragHost dragHost = null;

    DragAgent() {
    }

    public MUIElement getDragElement() {
        return this.dragElement;
    }

    public abstract MUIElement getElementToDrag(CursorInfo var1);

    public boolean canDrag(CursorInfo info) {
        return this.getElementToDrag(info) != null;
    }

    public void dragStart(MUIElement element) {
        this.dragElement = element;
        this.originalParent = element.getParent();
        if (this.originalParent != null) {
            this.originalIndex = element.getParent().getChildren().indexOf(element);
        }
        this.createDragFeedback();
    }

    public void cancelDrag() {
        this.removeDragFeedback();
    }

    public void dragFinished() {
        this.dragElement = null;
        this.originalIndex = -1;
        this.originalParent = null;
    }

    public void createDragFeedback() {
        this.dragHost = new DragHost(this.dragElement);
    }

    public void removeDragFeedback() {
        if (this.dragHost != null) {
            this.dragHost.dispose();
        }
    }

    public void trackDragFeedback(CursorInfo cursorInfo) {
    }
}

