/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabFolder2Adapter;
import org.eclipse.e4.ui.widgets.CTabFolder2Listener;
import org.eclipse.e4.ui.widgets.CTabFolderEvent;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MinMaxAddon {
    private static String trimURI = "platform:/plugin/org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack";
    static String ID_SUFFIX = "(minimized)";
    public static String MINIMIZED = "Minimized";
    public static String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    public static String EA_MAXIMIZED = "EAMaximized";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;
    private EventHandler ctfListener = new EventHandler(){

        public void handleEvent(Event event) {
            final MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            Widget widget = (Widget)event.getProperty("NewValue");
            if (changedElement instanceof MPartStack && widget instanceof CTabFolder && changedElement.getElementId() != null) {
                CTabFolder folder = (CTabFolder)widget;
                if (!changedElement.getTags().contains("EditorStack")) {
                    folder.setMinimizeVisible(true);
                    folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                        public void minimize(CTabFolderEvent event) {
                            changedElement.getTags().add(MINIMIZED);
                        }

                        public void restore(CTabFolderEvent event) {
                            changedElement.getTags().remove(MINIMIZED);
                        }
                    });
                } else {
                    folder.setMaximizeVisible(true);
                    folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                        public void maximize(CTabFolderEvent event) {
                            MWindow window = (this).MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                            MPerspective curPersp = (this).MinMaxAddon.this.modelService.getActivePerspective(window);
                            curPersp.getTags().add(EA_MAXIMIZED);
                        }

                        public void restore(CTabFolderEvent event) {
                            MWindow window = (this).MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                            MPerspective curPersp = (this).MinMaxAddon.this.modelService.getActivePerspective(window);
                            curPersp.getTags().remove(EA_MAXIMIZED);
                        }
                    });
                    folder.addMouseListener(new MouseListener(){

                        public void mouseUp(MouseEvent e) {
                        }

                        public void mouseDown(MouseEvent e) {
                        }

                        public void mouseDoubleClick(MouseEvent e) {
                            MWindow window = (this).MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                            MPerspective curPersp = (this).MinMaxAddon.this.modelService.getActivePerspective(window);
                            if (curPersp.getTags().contains(EA_MAXIMIZED)) {
                                curPersp.getTags().remove(EA_MAXIMIZED);
                            } else {
                                curPersp.getTags().add(EA_MAXIMIZED);
                            }
                        }
                    });
                }
            }
        }
    };
    private EventHandler perspectiveChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            MWindow win;
            MPartStack eStack;
            CTabFolder ctf;
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack ps = (MPerspectiveStack)changedElement;
            MPerspective curPersp = (MPerspective)ps.getSelectedElement();
            if (curPersp != null && (ctf = (CTabFolder)(eStack = MinMaxAddon.this.getEditorStack(win = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)curPersp))).getWidget()) != null) {
                boolean isMax = curPersp.getTags().contains(EA_MAXIMIZED);
                ctf.setMaximized(isMax);
            }
        }
    };
    private EventHandler initListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement.getWidget() instanceof CTabFolder && changedElement.getTags().contains("EditorStack")) {
                CTabFolder ctf = (CTabFolder)changedElement.getWidget();
                MWindow win = MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                MPerspective curPersp = MinMaxAddon.this.modelService.getActivePerspective(win);
                if (curPersp.getTags().contains(EA_MAXIMIZED)) {
                    ctf.setMaximized(true);
                }
                MinMaxAddon.this.eventBroker.unsubscribe(MinMaxAddon.this.initListener);
            }
        }
    };
    private EventHandler tagChangeListener = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedElement = event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            String tag = (String)event.getProperty("NewValue");
            String oldVal = (String)event.getProperty("OldValue");
            if ("ADD".equals(eventType)) {
                if (MINIMIZED.equals(tag)) {
                    this.handleMinimize((MUIElement)changedElement);
                } else if (EA_MAXIMIZED.equals(tag)) {
                    MPerspective persp = (MPerspective)changedElement;
                    MWindow win = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)persp);
                    MinMaxAddon.this.maximizeEA(MinMaxAddon.this.getEditorStack(win));
                }
            } else if ("REMOVE".equals(eventType)) {
                if (MINIMIZED.equals(oldVal)) {
                    this.handleRestore((MUIElement)changedElement);
                } else if (EA_MAXIMIZED.equals(oldVal)) {
                    MPerspective persp = (MPerspective)changedElement;
                    MWindow win = MinMaxAddon.this.modelService.getTopLevelWindowFor((MUIElement)persp);
                    MinMaxAddon.this.unmaximizeEA(MinMaxAddon.this.getEditorStack(win));
                }
            }
        }

        private void handleRestore(MUIElement element) {
            if (element instanceof MPartStack && element.getWidget() instanceof CTabFolder) {
                MinMaxAddon.this.restoreStack((MPartStack)element);
            }
        }

        private void handleMinimize(MUIElement element) {
            if (element instanceof MPartStack && element.getWidget() instanceof CTabFolder) {
                MinMaxAddon.this.minimizeStack((MPartStack)element);
            }
        }
    };
    private EventHandler perspectiveRemovedListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("REMOVE".equals(eventType)) {
                MUIElement removed = (MUIElement)event.getProperty("OldValue");
                String perspectiveId = removed.getElementId();
                MWindow window = MinMaxAddon.this.modelService.getTopLevelWindowFor(changedElement);
                MTrimBar bar = MinMaxAddon.this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    };

    @PostConstruct
    void hookListeners() {
        String topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget");
        this.eventBroker.subscribe(topic, null, this.ctfListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children");
        this.eventBroker.subscribe(topic, null, this.perspectiveRemovedListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement");
        this.eventBroker.subscribe(topic, null, this.perspectiveChangeListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ApplicationElement", (String)"tags");
        this.eventBroker.subscribe(topic, null, this.tagChangeListener, false);
        topic = UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget");
        this.eventBroker.subscribe(topic, null, this.initListener, false);
    }

    protected MPartStack getEditorStack(MWindow win) {
        MUIElement ea = this.modelService.find("org.eclipse.ui.editorss", (MUIElement)win);
        List eStacks = this.modelService.findElements(ea, null, MPartStack.class, null);
        if (eStacks.size() == 0) {
            return null;
        }
        return (MPartStack)eStacks.get(0);
    }

    @PreDestroy
    void unhookListeners() {
        this.eventBroker.unsubscribe(this.ctfListener);
        this.eventBroker.unsubscribe(this.perspectiveRemovedListener);
        this.eventBroker.unsubscribe(this.perspectiveChangeListener);
        this.eventBroker.unsubscribe(this.tagChangeListener);
        this.eventBroker.unsubscribe(this.initListener);
    }

    void minimizeStack(MPartStack stack) {
        CTabFolder ctf;
        MTrimmedWindow window = (MTrimmedWindow)this.modelService.getTopLevelWindowFor((MUIElement)stack);
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(stack.getElementId()) + this.getMinimizedStackSuffix(stack);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(trimURI);
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)stack.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            SideValue side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
            MTrimBar bar = this.modelService.getTrim(window, side);
            MToolControl spacer = (MToolControl)this.modelService.find("PerspectiveSpacer", (MUIElement)bar);
            if (spacer != null) {
                int spacerIndex = bar.getChildren().indexOf(spacer);
                bar.getChildren().add(spacerIndex - 1, trimStack);
                Control ctrl = (Control)trimStack.getWidget();
                if (ctrl != null) {
                    Control spacerCtrl = (Control)spacer.getWidget();
                    ctrl.moveAbove(spacerCtrl);
                }
            } else {
                bar.getChildren().add(trimStack);
                if (!bar.isToBeRendered()) {
                    bar.setToBeRendered(true);
                }
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
        if ((ctf = (CTabFolder)stack.getWidget()) != null) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        }
        stack.setVisible(false);
    }

    void restoreStack(MPartStack stack) {
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        String trimId = String.valueOf(stack.getElementId()) + this.getMinimizedStackSuffix(stack);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
        stack.getTags().remove(MINIMIZED_BY_ZOOM);
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf != null) {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(false);
            ctf.setMaximized(false);
        }
    }

    void maximizeEA(MPartStack stack) {
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MPerspective persp = this.modelService.getActivePerspective(win);
        MPerspective toSearch = persp != null ? persp : win;
        List stacks = this.modelService.findElements((MUIElement)toSearch, null, MPartStack.class, null);
        for (MPartStack theStack : stacks) {
            if (theStack.getTags().contains("EditorStack") || theStack.getWidget() == null || theStack.getTags().contains(MINIMIZED)) continue;
            theStack.getTags().add(MINIMIZED_BY_ZOOM);
            theStack.getTags().add(MINIMIZED);
        }
        persp.getTags().add(EA_MAXIMIZED);
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        ctf.setMaximized(true);
    }

    void unmaximizeEA(MPartStack stack) {
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MPerspective persp = this.modelService.getActivePerspective(win);
        MPerspective toSearch = persp != null ? persp : win;
        List stacks = this.modelService.findElements((MUIElement)toSearch, null, MPartStack.class, null);
        for (MPartStack theStack : stacks) {
            if (theStack.getTags().contains("EditorStack") || theStack.getWidget() == null || !theStack.getTags().contains(MINIMIZED) || !theStack.getTags().contains(MINIMIZED_BY_ZOOM)) continue;
            theStack.getTags().remove(MINIMIZED_BY_ZOOM);
            theStack.getTags().remove(MINIMIZED);
        }
        persp.getTags().remove(EA_MAXIMIZED);
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        ctf.setMaximized(false);
    }

    private String getMinimizedStackSuffix(MPartStack stack) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor((MUIElement)stack);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

