/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.internal.net.NetUIMessages;

public class ProxyEntriesLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider,
IColorProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element == null) {
            return null;
        }
        ProxyData data = (ProxyData)element;
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return data.getType();
            }
            case 2: {
                if (data.isDynamic()) {
                    return NetUIMessages.ProxyPreferencePage_18;
                }
                return data.getHost();
            }
            case 3: {
                if (data.isDynamic()) {
                    return NetUIMessages.ProxyPreferencePage_18;
                }
                if (data.getPort() == -1) {
                    return "";
                }
                return Integer.toString(data.getPort());
            }
            case 4: {
                return ProxySelector.localizeProvider((String)data.getSource());
            }
            case 5: {
                return Boolean.toString(data.isRequiresAuthentication());
            }
            case 6: {
                return data.getUserId();
            }
            case 7: {
                if (data.getPassword() == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < data.getPassword().length()) {
                    sb.append('*');
                    ++i;
                }
                return sb.toString();
            }
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void createColumns(TableViewer viewer) {
        String[] titles = new String[]{"", NetUIMessages.ProxyPreferencePage_2, NetUIMessages.ProxyPreferencePage_3, NetUIMessages.ProxyPreferencePage_4, NetUIMessages.ProxyPreferencePage_5, NetUIMessages.ProxyPreferencePage_6, NetUIMessages.ProxyPreferencePage_7, NetUIMessages.ProxyPreferencePage_8};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableViewerColumn(viewer, 0).getColumn();
            column.setText(titles[i]);
            column.setResizable(true);
            ++i;
        }
    }

    public Color getBackground(Object element) {
        String provider;
        if (element instanceof ProxyData && !ProxySelector.canSetProxyData((String)(provider = ((ProxyData)element).getSource()))) {
            return Display.getCurrent().getSystemColor(29);
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }
}

