/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.contributionsview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.ContributionProxyMBean;
import org.eclipse.equinox.jmx.common.RootContribution;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.MBeanServerProxy;
import org.eclipse.equinox.jmx.internal.client.ui.mbeaninfoview.MBeanInfoViewPart;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ContributionContentProvider
implements ITreeContentProvider,
NotificationListener {
    private static final Object[] NO_CHILDS = new Object[0];
    private MBeanServerProxy serverProxy;
    private TreeViewer viewer;
    private Hashtable objNameProxies = new Hashtable();

    public ContributionContentProvider(TreeViewer viewer, MBeanServerProxy serverProxy) {
        this.viewer = viewer;
        this.serverProxy = serverProxy;
    }

    public void setServerContributionProxy(MBeanServerProxy serverProxy) {
        this.removeListeners();
        this.objNameProxies.clear();
        this.serverProxy = serverProxy;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ContributionProxy) {
            ContributionProxy parentProxy = (ContributionProxy)parentElement;
            try {
                this.monitorProxies(new ContributionProxy[]{parentProxy});
                MBeanServerConnection mbServer = this.serverProxy.getMBeanServerConnection();
                ContributionProxy[] contribs = parentProxy.getChildContributions(mbServer);
                this.monitorProxies(contribs);
                Object[] ret = null;
                if (contribs != null && contribs.length > 0) {
                    ret = new Object[contribs.length];
                    System.arraycopy(contribs, 0, ret, 0, ret.length);
                    return ret;
                }
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        } else if (parentElement instanceof ContributionProxy[]) {
            try {
                this.monitorProxies((ContributionProxy[])parentElement);
            }
            catch (Exception e) {
                Activator.logError(e);
            }
            return (ContributionProxy[])parentElement;
        }
        return NO_CHILDS;
    }

    public Object getParent(Object element) {
        return element;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContributionProxyMBean && this.serverProxy != null) {
            try {
                ContributionProxy[] contribs = ((ContributionProxy)element).getChildContributions(this.serverProxy.getMBeanServerConnection());
                return contribs != null && contribs.length > 0;
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof RootContribution) {
            RootContribution rc = (RootContribution)inputElement;
            try {
                this.monitorProxies(new ContributionProxy[]{rc});
            }
            catch (Exception e) {
                Activator.log(e);
            }
            return this.getChildren(rc.queryRootContributions());
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        Object obj = notification.getSource();
        if (!(obj instanceof ObjectName) || this.serverProxy == null) {
            return;
        }
        final ObjectName objectName = (ObjectName)obj;
        List proxiesRef = (List)this.objNameProxies.get(objectName);
        if (proxiesRef == null) {
            return;
        }
        final ArrayList proxies = new ArrayList(proxiesRef);
        final Iterator iter = proxies.iterator();
        String type = notification.getType();
        if (type.equals("contribution.updated") || type.equals("contribution.added")) {
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    if (proxies.size() != 1 || !(proxies.get(0) instanceof RootContribution)) ** GOTO lbl18
                    try {
                        ContributionContentProvider.access$0(ContributionContentProvider.this).remove(((RootContribution)ContributionContentProvider.access$1(ContributionContentProvider.this).getInput()).getObjectName());
                        ContributionContentProvider.access$1(ContributionContentProvider.this).setInput((Object)ContributionContentProvider.access$2(ContributionContentProvider.this).getRootContribution());
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        proxy = (ContributionProxy)iter.next();
                        try {
                            proxy.refresh(ContributionContentProvider.access$2(ContributionContentProvider.this).getMBeanServerConnection());
                            ContributionContentProvider.access$1(ContributionContentProvider.this).update((Object)proxy, null);
                            ContributionContentProvider.access$1(ContributionContentProvider.this).refresh((Object)proxy);
                            continue;
                        }
                        catch (Exception e) {
                            Activator.log(e);
                        }
lbl18:
                        // 3 sources

                        ** while (iter.hasNext())
                    }
lbl19:
                    // 1 sources

                }
            });
        } else if (type.equals("contribution.removed")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ContributionContentProvider.this.objNameProxies.remove(objectName);
                    MBeanInfoViewPart vp = this.getMBeanInfoViewPart();
                    while (iter.hasNext()) {
                        ContributionProxy proxy = (ContributionProxy)iter.next();
                        ContributionContentProvider.this.viewer.remove((Object)proxy);
                        if (vp == null) continue;
                        vp.contributionRemoved(proxy);
                    }
                }

                private MBeanInfoViewPart getMBeanInfoViewPart() {
                    return (MBeanInfoViewPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.equinox.jmx.client.ui.mbeaninfoview");
                }
            });
        }
    }

    private void monitorProxies(ContributionProxy[] proxies) throws InstanceNotFoundException, IOException {
        int i = 0;
        while (i < proxies.length) {
            ObjectName name = proxies[i].getObjectName();
            Vector<ContributionProxy> l = null;
            l = (Vector<ContributionProxy>)this.objNameProxies.get(name);
            if (l == null) {
                l = new Vector<ContributionProxy>(2);
                this.serverProxy.getMBeanServerConnection().addNotificationListener(name, this, null, null);
                this.objNameProxies.put(name, l);
            }
            l.add(proxies[i]);
            ++i;
        }
    }

    private void removeListeners() {
        if (this.serverProxy == null) {
            return;
        }
        Iterator iter = this.objNameProxies.keySet().iterator();
        try {
            while (iter.hasNext()) {
                ObjectName name = (ObjectName)iter.next();
                this.serverProxy.getMBeanServerConnection().removeNotificationListener(name, this);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    static /* synthetic */ MBeanServerProxy access$2(ContributionContentProvider contributionContentProvider) {
        return contributionContentProvider.serverProxy;
    }
}

