/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.viewsupport;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.ImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class JMXPluginImages {
    public static final IPath ICONS_PATH = new Path("$nl$/icons/");
    public static final IPath ICONS_MB_PATH = new Path(ICONS_PATH.append("mb/").toString());
    private static ImageRegistry registry;
    public static final Image IMG_MANAGED_BUNDLE;
    public static final Image IMG_MANAGED_COMPONENT;
    public static final Image IMG_MBEAN_OPERATION;
    public static final Image IMG_MBEAN_OPERATIONS;
    public static final Image IMG_MBEAN_OPERATIONS_NONE;
    public static final ImageDescriptor IMGDESC_OVR_BUNDLE_ACTIVE;
    public static final ImageDescriptor IMGDESC_OVR_BUNDLE_INSTALLED;
    public static final ImageDescriptor IMGDESC_OVR_BUNDLE_RESOLVED;

    static {
        IMG_MANAGED_BUNDLE = JMXPluginImages.createManaged(ICONS_MB_PATH, "bundle.gif");
        IMG_MANAGED_COMPONENT = JMXPluginImages.createManaged(ICONS_MB_PATH, "component.gif");
        IMG_MBEAN_OPERATION = JMXPluginImages.createManaged(ICONS_MB_PATH, "mbean_operation.gif");
        IMG_MBEAN_OPERATIONS = JMXPluginImages.createManaged(ICONS_MB_PATH, "mbean_operations.gif");
        IMG_MBEAN_OPERATIONS_NONE = JMXPluginImages.createManaged(ICONS_MB_PATH, "mbean_operation_none.gif");
        IMGDESC_OVR_BUNDLE_ACTIVE = JMXPluginImages.create("mb/", "ovr_bundle_active.gif", true);
        IMGDESC_OVR_BUNDLE_INSTALLED = JMXPluginImages.create("mb/", "ovr_bundle_installed.gif", true);
        IMGDESC_OVR_BUNDLE_RESOLVED = JMXPluginImages.create("mb/", "ovr_bundle_resolved.gif", true);
    }

    public static Image createManaged(IPath path, String name) {
        ImageDescriptor desc = JMXPluginImages.createImageDescriptor(Activator.getDefault().getBundle(), path.append(name), true);
        if (registry == null) {
            registry = new ImageRegistry();
        }
        return registry.get(desc);
    }

    public Image getImage(ImageDescriptor descriptor) {
        return registry.get(descriptor);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return JMXPluginImages.createImageDescriptor(Activator.getDefault().getBundle(), path, useMissingImageDescriptor);
    }
}

