/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhCursorDef_t;

public final class Cursor
extends Resource {
    public int type;
    public int bitmap;

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int style) {
        super(device);
        switch (style) {
            case 0: {
                this.type = 59648;
                break;
            }
            case 1: {
                this.type = 59656;
                break;
            }
            case 21: {
                this.type = 59660;
                break;
            }
            case 2: {
                this.type = 59654;
                break;
            }
            case 3: {
                this.type = 59672;
                break;
            }
            case 4: {
                this.type = 59676;
                break;
            }
            case 5: {
                this.type = 59652;
                break;
            }
            case 6: {
                this.type = 59652;
                break;
            }
            case 7: {
                this.type = 59664;
                break;
            }
            case 8: {
                this.type = 59652;
                break;
            }
            case 9: {
                this.type = 59666;
                break;
            }
            case 10: {
                this.type = 59664;
                break;
            }
            case 11: {
                this.type = 59664;
                break;
            }
            case 12: {
                this.type = 59666;
                break;
            }
            case 13: {
                this.type = 59666;
                break;
            }
            case 14: {
                this.type = 59670;
                break;
            }
            case 15: {
                this.type = 59668;
                break;
            }
            case 16: {
                this.type = 59670;
                break;
            }
            case 17: {
                this.type = 59668;
                break;
            }
            case 18: {
                this.type = 59660;
                break;
            }
            case 19: {
                this.type = 59662;
                break;
            }
            case 20: {
                this.type = 59658;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (this.type == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        this.type = 251;
        int w = source.width;
        int h = source.height;
        ImageData mask1 = new ImageData(w, h, 1, source.palette);
        ImageData mask2 = new ImageData(w, h, 1, mask.palette);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int mask2_pixel;
                int mask1_pixel;
                int src_pixel = source.getPixel(x, y);
                int mask_pixel = mask.getPixel(x, y);
                if (src_pixel == 0 && mask_pixel == 0) {
                    mask1_pixel = 0;
                    mask2_pixel = 1;
                } else if (src_pixel == 0 && mask_pixel == 1) {
                    mask1_pixel = 1;
                    mask2_pixel = 0;
                } else if (src_pixel == 1 && mask_pixel == 0) {
                    mask1_pixel = 0;
                    mask2_pixel = 0;
                } else {
                    mask1_pixel = 0;
                    mask2_pixel = 0;
                }
                mask1.setPixel(x, y, mask1_pixel);
                mask2.setPixel(x, y, mask2_pixel);
                ++x;
            }
            ++y;
        }
        PhCursorDef_t cursor = new PhCursorDef_t();
        cursor.size1_x = w;
        cursor.size1_y = (short)h;
        cursor.offset1_x = (short)(-hotspotX);
        cursor.offset1_y = (short)(-hotspotY);
        cursor.bytesperline1 = (byte)mask1.bytesPerLine;
        cursor.color1 = 0xFFFFE0;
        cursor.size2_x = w;
        cursor.size2_y = (short)h;
        cursor.offset2_x = (short)(-hotspotX);
        cursor.offset2_y = (short)(-hotspotY);
        cursor.bytesperline2 = (byte)mask2.bytesPerLine;
        cursor.color2 = 0;
        int mask1Size = cursor.bytesperline1 * cursor.size1_y;
        int mask2Size = cursor.bytesperline2 * cursor.size2_y;
        this.bitmap = OS.malloc(47 + mask1Size + mask2Size);
        if (this.bitmap == 0) {
            SWT.error(2);
        }
        OS.memmove(this.bitmap, cursor, 47);
        OS.memmove(this.bitmap + 47, mask1.data, mask1Size);
        OS.memmove(this.bitmap + 47 + mask1Size, mask2.data, mask2Size);
        this.init();
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        ImageData mask = source.getTransparencyMask();
        if (source.depth > 1) {
            byte[] newReds;
            ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] newGreens = newReds = byArray;
            byte[] newBlues = newReds;
            PaletteData palette = source.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, newReds, newGreens, newBlues, false, false);
            }
            source = newSource;
        }
        this.type = 251;
        int w = source.width;
        int h = source.height;
        ImageData mask1 = new ImageData(w, h, 1, source.palette);
        ImageData mask2 = new ImageData(w, h, 1, mask.palette);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int mask2_pixel;
                int mask1_pixel;
                int src_pixel = source.getPixel(x, y);
                int mask_pixel = mask.getPixel(x, y);
                if (src_pixel == 0 && mask_pixel == 1) {
                    mask1_pixel = 0;
                    mask2_pixel = 1;
                } else if (src_pixel == 1 && mask_pixel == 1) {
                    mask1_pixel = 1;
                    mask2_pixel = 0;
                } else if (src_pixel == 0 && mask_pixel == 0) {
                    mask1_pixel = 0;
                    mask2_pixel = 0;
                } else {
                    mask1_pixel = 0;
                    mask2_pixel = 0;
                }
                mask1.setPixel(x, y, mask1_pixel);
                mask2.setPixel(x, y, mask2_pixel);
                ++x;
            }
            ++y;
        }
        PhCursorDef_t cursor = new PhCursorDef_t();
        cursor.size1_x = w;
        cursor.size1_y = (short)h;
        cursor.offset1_x = (short)(-hotspotX);
        cursor.offset1_y = (short)(-hotspotY);
        cursor.bytesperline1 = (byte)mask1.bytesPerLine;
        cursor.color1 = 0xFFFFE0;
        cursor.size2_x = w;
        cursor.size2_y = (short)h;
        cursor.offset2_x = (short)(-hotspotX);
        cursor.offset2_y = (short)(-hotspotY);
        cursor.bytesperline2 = (byte)mask2.bytesPerLine;
        cursor.color2 = 0;
        int mask1Size = cursor.bytesperline1 * cursor.size1_y;
        int mask2Size = cursor.bytesperline2 * cursor.size2_y;
        this.bitmap = OS.malloc(47 + mask1Size + mask2Size);
        if (this.bitmap == 0) {
            SWT.error(2);
        }
        OS.memmove(this.bitmap, cursor, 47);
        OS.memmove(this.bitmap + 47, mask1.data, mask1Size);
        OS.memmove(this.bitmap + 47 + mask1Size, mask2.data, mask2Size);
        this.init();
    }

    void destroy() {
        if (this.type == 251 && this.bitmap != 0) {
            OS.free(this.bitmap);
        }
        this.bitmap = 0;
        this.type = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.type == cursor.type && this.bitmap == cursor.bitmap;
    }

    public int hashCode() {
        return this.bitmap ^ this.type;
    }

    public boolean isDisposed() {
        return this.type == 0;
    }

    public static Cursor photon_new(Device device, int type, int bitmap) {
        Cursor cursor = new Cursor(device);
        cursor.type = type;
        cursor.bitmap = bitmap;
        return cursor;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.type + "," + this.bitmap + "}";
    }
}

