/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PgAlpha_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhImage_t;
import org.eclipse.swt.internal.photon.PhPoint_t;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    int transparentPixel = -1;
    GC memGC;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: {
                this.type = srcImage.type;
                int srcHandle = srcImage.handle;
                int newHandle = OS.PiDuplicateImage(srcHandle, 0);
                if (newHandle == 0) {
                    SWT.error(2);
                }
                if (flag == 0) {
                    int ptr;
                    PhImage_t phImage = new PhImage_t();
                    OS.memmove(phImage, srcHandle, 56);
                    PhImage_t newPhImage = new PhImage_t();
                    OS.memmove(newPhImage, newHandle, 56);
                    if (newPhImage.mask_bm != 0 && phImage.mask_bm == newPhImage.mask_bm) {
                        int length = newPhImage.mask_bpl * newPhImage.size_h;
                        ptr = OS.malloc(length);
                        OS.memmove(ptr, newPhImage.mask_bm, length);
                        newPhImage.mask_bm = ptr;
                    }
                    if (newPhImage.alpha != 0 && phImage.alpha == newPhImage.alpha) {
                        PgAlpha_t alpha = new PgAlpha_t();
                        OS.memmove(alpha, phImage.alpha, 104);
                        if (alpha.src_alpha_map_map != 0) {
                            int length = alpha.src_alpha_map_bpl * alpha.src_alpha_map_dim_h;
                            int ptr2 = OS.malloc(length);
                            OS.memmove(ptr2, alpha.src_alpha_map_map, length);
                            alpha.src_alpha_map_map = ptr2;
                        }
                        ptr = OS.malloc(104);
                        OS.memmove(ptr, alpha, 104);
                        newPhImage.alpha = ptr;
                    }
                    OS.memmove(newHandle, newPhImage, 56);
                    this.transparentPixel = srcImage.transparentPixel;
                } else {
                    PhImage_t phImage = new PhImage_t();
                    OS.PhMakeGhostBitmap(newHandle);
                    OS.memmove(phImage, newHandle, 56);
                    phImage.mask_bm = phImage.ghost_bitmap;
                    phImage.mask_bpl = phImage.ghost_bpl;
                    phImage.ghost_bitmap = 0;
                    phImage.ghost_bpl = 0;
                    phImage.alpha = 0;
                    OS.memmove(newHandle, phImage, 56);
                }
                this.handle = newHandle;
                break;
            }
            case 2: {
                Rectangle r = srcImage.getBounds();
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(r.width, r.height, 8, new PaletteData(rgbs));
                    newData.alpha = data.alpha;
                    newData.alphaData = data.alphaData;
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    if (data.transparentPixel != -1) {
                        newData.transparentPixel = 254;
                    }
                    int[] scanline = new int[r.width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < r.height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, r.width, scanline, 0);
                        int x = 0;
                        while (x < r.width) {
                            int pixel = scanline[x];
                            if (pixel != data.transparentPixel) {
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int intensity = red + red + green + green + green + green + green + blue >> 3;
                                if (newData.transparentPixel == intensity) {
                                    intensity = 255;
                                }
                                newData.data[offset] = (byte)intensity;
                            } else {
                                newData.data[offset] = -2;
                            }
                            ++offset;
                            ++x;
                        }
                        ++y;
                    }
                }
                this.init(newData);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(image);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.init(new ImageData(stream));
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        this.init(new ImageData(filename));
        this.init();
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        Image.destroyImage(this.handle);
        this.handle = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, this.handle, 56);
        int color = 0;
        if ((phImage.type & 0x38) == 16) {
            int phPalette = phImage.palette;
            if (phPalette == 0 || this.transparentPixel > phImage.colors) {
                return null;
            }
            int[] pgColor = new int[1];
            OS.memmove(pgColor, phPalette + this.transparentPixel * 4, 4);
            color = pgColor[0];
        } else {
            switch (phImage.type) {
                case 33: {
                    color = (this.transparentPixel & 0xFF) << 16 | this.transparentPixel & 0xFF00 | (this.transparentPixel & 0xFF0000) >> 16;
                    break;
                }
                case 32: {
                    color = (this.transparentPixel & 0xFF00) << 8 | (this.transparentPixel & 0xFF0000) >> 8 | (this.transparentPixel & 0xFF000000) >> 24;
                    break;
                }
                case 34: {
                    color = (this.transparentPixel & 0xF800) << 8 | (this.transparentPixel & 0x7E0) << 5 | (this.transparentPixel & 0x1F) << 3;
                    break;
                }
                case 35: {
                    color = (this.transparentPixel & 0x7C00) << 9 | (this.transparentPixel & 0x3E0) << 6 | (this.transparentPixel & 0x1F) << 3;
                    break;
                }
                case 36: {
                    color = (this.transparentPixel & 0xF00) << 12 | (this.transparentPixel & 0xF0) << 8 | (this.transparentPixel & 0xF) << 4;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return Color.photon_new(this.device, color);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        PhImage_t image = new PhImage_t();
        OS.memmove(image, this.handle, 56);
        return new Rectangle(0, 0, image.size_w, image.size_h);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.memGC != null) {
            this.memGC.flushImage();
        }
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, this.handle, 56);
        int depth = 0;
        PaletteData palette = null;
        switch (phImage.type) {
            case 35: {
                depth = 16;
                palette = new PaletteData(31744, 992, 31);
                break;
            }
            case 34: {
                depth = 16;
                palette = new PaletteData(63488, 2016, 31);
                break;
            }
            case 36: {
                depth = 16;
                palette = new PaletteData(3840, 240, 15);
                break;
            }
            case 33: {
                depth = 24;
                palette = new PaletteData(255, 65280, 0xFF0000);
                break;
            }
            case 32: {
                depth = 32;
                palette = new PaletteData(65280, 0xFF0000, -16777216);
                break;
            }
            case -1: {
                depth = 1;
                palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                break;
            }
            case 16: 
            case 17: {
                depth = phImage.type == 16 ? 8 : 4;
                RGB[] rgbs = new RGB[phImage.colors];
                int[] colors = new int[phImage.colors];
                OS.memmove(colors, phImage.palette, colors.length * 4);
                int i = 0;
                while (i < rgbs.length) {
                    int rgb = colors[i];
                    rgbs[i] = new RGB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                    ++i;
                }
                palette = new PaletteData(rgbs);
                break;
            }
            default: {
                SWT.error(38);
            }
        }
        int bpl = phImage.bpl;
        short width = phImage.size_w;
        short height = phImage.size_h;
        int dataBytesPerLine = (width * depth + 7) / 8;
        int scanLinePad = 1;
        while (scanLinePad < 128) {
            int calcBpl = (dataBytesPerLine + (scanLinePad - 1)) / scanLinePad * scanLinePad;
            if (bpl == calcBpl) break;
            ++scanLinePad;
        }
        byte[] data = new byte[height * bpl];
        OS.memmove(data, phImage.image, data.length);
        ImageData imageData = new ImageData(width, height, depth, palette, scanLinePad, data);
        if (this.transparentPixel != -1) {
            imageData.transparentPixel = this.transparentPixel;
        } else if (phImage.mask_bm != 0) {
            imageData.maskData = new byte[height * phImage.mask_bpl];
            OS.memmove(imageData.maskData, phImage.mask_bm, imageData.maskData.length);
            imageData.maskPad = 2;
        } else if (phImage.alpha != 0) {
            PgAlpha_t alpha = new PgAlpha_t();
            OS.memmove(alpha, phImage.alpha, 104);
            imageData.alpha = alpha.src_global_alpha;
            if ((alpha.alpha_op & 0x80000) != 0 && alpha.src_alpha_map_map != 0) {
                int length = alpha.src_alpha_map_dim_w * alpha.src_alpha_map_dim_h;
                imageData.alphaData = new byte[length];
                OS.memmove(imageData.alphaData, alpha.src_alpha_map_map, length);
            }
        }
        return imageData;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.handle = OS.PhCreateImage(null, (short)width, (short)height, 33, 0, 0, 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    void init(ImageData i) {
        if (i == null) {
            SWT.error(4);
        }
        if (!(i.depth != 1 && i.depth != 2 && i.depth != 4 || i.palette.isDirect)) {
            ImageData img = new ImageData(i.width, i.height, 8, i.palette);
            ImageData.blit(1, i.data, i.depth, i.bytesPerLine, img.getByteOrder(), 0, 0, i.width, i.height, null, null, null, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), 0, 0, img.width, img.height, null, null, null, false, false);
            img.transparentPixel = i.transparentPixel;
            img.maskPad = i.maskPad;
            img.maskData = i.maskData;
            img.alpha = i.alpha;
            img.alphaData = i.alphaData;
            i = img;
        }
        int type = 0;
        int[] phPalette = null;
        if (!i.palette.isDirect) {
            switch (i.depth) {
                case 4: {
                    type = 17;
                    break;
                }
                case 8: {
                    type = 16;
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            RGB[] rgbs = i.palette.getRGBs();
            phPalette = new int[rgbs.length];
            int j = 0;
            while (j < rgbs.length) {
                RGB rgb = rgbs[j];
                phPalette[j] = (rgb.red & 0xFF) << 16 | (rgb.green & 0xFF) << 8 | rgb.blue & 0xFF;
                ++j;
            }
        } else {
            PaletteData palette = i.palette;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int newDepth = i.depth;
            int newOrder = 1;
            PaletteData newPalette = null;
            switch (i.depth) {
                case 8: {
                    newDepth = 16;
                    newOrder = 0;
                    newPalette = new PaletteData(63488, 2016, 31);
                    type = 34;
                    break;
                }
                case 16: {
                    newOrder = 0;
                    if (redMask == 31744 && greenMask == 992 && blueMask == 31) {
                        type = 35;
                        break;
                    }
                    if (redMask == 63488 && greenMask == 2016 && blueMask == 31) {
                        type = 34;
                        break;
                    }
                    if (redMask == 3840 && greenMask == 240 && blueMask == 15) {
                        type = 36;
                        break;
                    }
                    type = 34;
                    newPalette = new PaletteData(63488, 2016, 31);
                    break;
                }
                case 24: {
                    if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) {
                        type = 33;
                        break;
                    }
                    type = 33;
                    newPalette = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) {
                        type = 32;
                        break;
                    }
                    type = 32;
                    newPalette = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (newPalette != null) {
                ImageData img = new ImageData(i.width, i.height, newDepth, newPalette);
                ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, redMask, greenMask, blueMask, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, newOrder, 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
                if (i.transparentPixel != -1) {
                    img.transparentPixel = newPalette.getPixel(palette.getRGB(i.transparentPixel));
                }
                img.maskPad = i.maskPad;
                img.maskData = i.maskData;
                img.alpha = i.alpha;
                img.alphaData = i.alphaData;
                i = img;
            }
        }
        int handle = OS.malloc(56);
        if (handle == 0) {
            SWT.error(2);
        }
        PhImage_t phImage = new PhImage_t();
        phImage.type = type;
        phImage.flags = (byte)31;
        int size = i.data.length;
        int ptr = OS.malloc(size);
        if (ptr == 0) {
            OS.free(handle);
            SWT.error(2);
        }
        OS.memmove(ptr, i.data, size);
        phImage.image = ptr;
        phImage.size_w = (short)i.width;
        phImage.size_h = (short)i.height;
        phImage.bpl = i.bytesPerLine;
        if (phPalette != null) {
            size = phPalette.length * 4;
            ptr = OS.malloc(size);
            if (ptr == 0) {
                OS.free(phImage.image);
                OS.free(handle);
                SWT.error(2);
            }
            OS.memmove(ptr, phPalette, size);
            phImage.palette = ptr;
            phImage.colors = phPalette.length;
        }
        if (i.getTransparencyType() == 2) {
            this.type = 1;
            int maskBpl = (i.width * 1 + 7) / 8;
            size = (maskBpl = (maskBpl + (i.maskPad - 1)) / i.maskPad * i.maskPad) * i.height;
            ptr = OS.malloc(size);
            if (ptr == 0) {
                if (phImage.palette != 0) {
                    OS.free(phImage.palette);
                }
                OS.free(phImage.image);
                OS.free(handle);
                SWT.error(2);
            }
            OS.memmove(ptr, i.maskData, size);
            phImage.mask_bm = ptr;
            phImage.mask_bpl = maskBpl;
        } else {
            this.type = 0;
            if (i.transparentPixel != -1) {
                this.transparentPixel = i.transparentPixel;
            } else if (i.alpha != -1 || i.alphaData != null) {
                PgAlpha_t alpha = new PgAlpha_t();
                alpha.alpha_op = i.alpha != -1 ? 262144 : 524288;
                alpha.alpha_op |= 0x405;
                alpha.src_global_alpha = (byte)i.alpha;
                if (i.alpha == -1 && i.alphaData != null) {
                    ptr = OS.malloc(i.alphaData.length);
                    if (ptr == 0) {
                        if (phImage.palette != 0) {
                            OS.free(phImage.palette);
                        }
                        OS.free(phImage.image);
                        OS.free(handle);
                        SWT.error(2);
                    }
                    OS.memmove(ptr, i.alphaData, i.alphaData.length);
                    alpha.src_alpha_map_bpl = (short)i.width;
                    alpha.src_alpha_map_dim_w = (short)i.width;
                    alpha.src_alpha_map_dim_h = (short)i.height;
                    alpha.src_alpha_map_map = ptr;
                }
                if ((ptr = OS.malloc(104)) == 0) {
                    if (alpha.src_alpha_map_map != 0) {
                        OS.free(alpha.src_alpha_map_map);
                    }
                    if (phImage.palette != 0) {
                        OS.free(phImage.palette);
                    }
                    OS.free(phImage.image);
                    OS.free(handle);
                    SWT.error(2);
                }
                OS.memmove(ptr, alpha, 104);
                phImage.alpha = ptr;
            }
        }
        OS.memmove(handle, phImage, 56);
        this.handle = handle;
    }

    public int internal_new_GC(GCData data) {
        int mask;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, this.handle, 56);
        PhDim_t dim = new PhDim_t();
        dim.w = phImage.size_w;
        dim.h = phImage.size_h;
        PhPoint_t trans = new PhPoint_t();
        int pmMC = OS.PmMemCreateMC(this.handle, dim, trans);
        if (pmMC == 0) {
            SWT.error(2);
        }
        if ((data.style & (mask = 0x6000000)) == 0) {
            data.style |= 0x2000000;
        }
        data.device = this.device;
        data.image = this;
        return pmMC;
    }

    public void internal_dispose_GC(int pmMC, GCData data) {
        OS.PmMemReleaseMC(pmMC);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, this.handle, 56);
        int phPalette = phImage.palette;
        if (phPalette == 0 || this.transparentPixel > phImage.colors) {
            return;
        }
        int[] pgColor = new int[]{color.handle};
        OS.memmove(phPalette + this.transparentPixel * 4, pgColor, 4);
    }

    static void destroyImage(int image) {
        if (image == 0) {
            return;
        }
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, image, 56);
        phImage.flags = (byte)31;
        OS.memmove(image, phImage, 56);
        OS.PhReleaseImage(image);
        OS.free(image);
    }

    public static Image photon_new(Device device, int type, int handle) {
        Image image = new Image(device);
        image.type = type;
        image.handle = handle;
        return image;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

