/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PtColorSelectInfo_t;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int parentHandle = 0;
        if (this.parent != null && OS.PtWidgetIsRealized(this.parent.shellHandle)) {
            parentHandle = this.parent.shellHandle;
        }
        byte[] title = null;
        if (this.title != null) {
            title = Converter.wcsToMbcs(null, this.title, true);
        }
        PtColorSelectInfo_t info = new PtColorSelectInfo_t();
        info.flags = (short)4;
        if (this.rgb != null) {
            info.rgb = this.rgb.blue & 0xFF | (this.rgb.green & 0xFF) << 8 | (this.rgb.red & 0xFF) << 16;
        }
        this.rgb = null;
        OS.PtColorSelect(parentHandle, title, info);
        if ((info.flags & 0x8000) != 0) {
            int color = info.rgb;
            this.rgb = new RGB((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

